/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.model.armor.layers;

import iskallia.vault.dynamodel.model.armor.ArmorLayers;
import iskallia.vault.dynamodel.model.armor.ArmorPieceModel;
import iskallia.vault.gear.data.GearDataCache;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModDynamicModels;
import java.util.HashSet;
import java.util.function.Supplier;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class GoblinArmorLayers
extends ArmorLayers {
    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Supplier<LayerDefinition> getGeometrySupplier(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.LEGS ? LeggingsLayer::createBodyLayer : MainLayer::createBodyLayer;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ArmorLayers.VaultArmorLayerSupplier<? extends ArmorLayers.BaseLayer> getLayerSupplier(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.LEGS ? LeggingsLayer::new : MainLayer::new;
    }

    @SubscribeEvent
    public static void shiningParticles(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (!entity.f_19853_.m_5776_()) {
            return;
        }
        Level world = entity.f_19853_;
        Minecraft minecraft = Minecraft.m_91087_();
        if (entity == minecraft.f_91074_ && minecraft.f_91066_.m_92176_() == CameraType.FIRST_PERSON) {
            return;
        }
        HashSet<EquipmentSlot> slots = new HashSet<EquipmentSlot>();
        for (ItemStack itemStack : entity.m_6168_()) {
            ArmorPieceModel armorPieceModel;
            GearDataCache vaultGearData;
            ResourceLocation modelId;
            if (!(itemStack.m_41720_() instanceof VaultGearItem) || (modelId = (ResourceLocation)(vaultGearData = GearDataCache.of(itemStack)).getGearModel().orElse(null)) == null || (armorPieceModel = (ArmorPieceModel)ModDynamicModels.Armor.PIECE_REGISTRY.get(modelId).orElse(null)) == null || ModDynamicModels.Armor.GOBLIN != armorPieceModel.getArmorModel()) continue;
            slots.add(armorPieceModel.getEquipmentSlot());
        }
        if (slots.contains(EquipmentSlot.HEAD)) {
            GoblinArmorLayers.addShiningParticle(entity, world, 1.75f);
        }
        if (slots.contains(EquipmentSlot.CHEST)) {
            GoblinArmorLayers.addShiningParticle(entity, world, 1.1f);
        }
        if (slots.contains(EquipmentSlot.LEGS)) {
            GoblinArmorLayers.addShiningParticle(entity, world, 0.8f);
        }
        if (slots.contains(EquipmentSlot.FEET)) {
            GoblinArmorLayers.addShiningParticle(entity, world, 0.1f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void addShiningParticle(LivingEntity entity, Level world, float yOffset) {
        Particle particle;
        Minecraft minecraft = Minecraft.m_91087_();
        if (entity.f_19797_ % 4 == 0 && world.f_46441_.nextBoolean() && (particle = minecraft.f_91061_.m_107370_((ParticleOptions)ParticleTypes.f_175831_, entity.m_20185_() + (double)(world.f_46441_.nextFloat() - 0.5f), entity.m_20186_() + (double)(world.f_46441_.nextFloat() - 0.5f) + (double)yOffset, entity.m_20189_() + (double)(world.f_46441_.nextFloat() - 0.5f), 0.0, 0.0, 0.0)) != null) {
            particle.m_107253_(0.5f, 0.5f, 0.2f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LeggingsLayer
    extends ArmorLayers.LeggingsLayer {
        public LeggingsLayer(ArmorPieceModel definition, ModelPart root) {
            super(definition, root);
        }

        public static LayerDefinition createBodyLayer() {
            MeshDefinition meshdefinition = LeggingsLayer.createBaseLayer();
            PartDefinition partdefinition = meshdefinition.m_171576_();
            PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.51f)).m_171514_(24, 0).m_171488_(-3.0f, 9.0f, -4.0f, 6.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(24, 32).m_171488_(-1.0f, 10.0f, -5.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r1 = body.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(14, 32).m_171488_(-2.25f, 0.0f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(28, 16).m_171488_(-2.25f, -1.0f, -0.5f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.25f, (float)10.0f, (float)-3.5f, (float)0.0f, (float)0.1309f, (float)-0.6109f));
            PartDefinition cube_r2 = body.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(32, 20).m_171488_(-1.75f, 0.0f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(28, 18).m_171488_(-2.75f, -1.0f, -0.5f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.25f, (float)10.0f, (float)-3.5f, (float)0.0f, (float)-0.1309f, (float)0.6109f));
            PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
            PartDefinition cube_r3 = right_leg.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(32, 22).m_171488_(-3.5f, -3.0f, -1.0f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(24, 11).m_171488_(-4.0f, -2.0f, -1.0f, 4.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)4.0f, (float)-3.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r4 = right_leg.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(29, 29).m_171488_(-2.5f, -0.2146f, -2.6955f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)4.4611f, (float)-5.4797f, (float)-0.6545f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r5 = right_leg.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(8, 32).m_171488_(-3.0f, -0.803f, -0.2744f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)4.4611f, (float)-5.4797f, (float)0.0f, (float)0.0f, (float)0.0f));
            PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
            PartDefinition cube_r6 = left_leg.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(12, 16).m_171488_(1.5f, -0.2146f, -2.6955f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.8f, (float)4.4611f, (float)-5.4797f, (float)-0.6545f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r7 = left_leg.m_171599_("cube_r7", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(1.0f, -0.803f, -0.2744f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.8f, (float)4.4611f, (float)-5.4797f, (float)0.0f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r8 = left_leg.m_171599_("cube_r8", CubeListBuilder.m_171558_().m_171514_(32, 24).m_171488_(0.5f, -3.0f, -1.0f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(24, 6).m_171488_(0.0f, -2.0f, -1.0f, 4.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.8f, (float)4.0f, (float)-3.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
            return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MainLayer
    extends ArmorLayers.MainLayer {
        public MainLayer(ArmorPieceModel definition, ModelPart root) {
            super(definition, root);
        }

        public static LayerDefinition createBodyLayer() {
            MeshDefinition meshdefinition = MainLayer.createBaseLayer();
            PartDefinition partdefinition = meshdefinition.m_171576_();
            PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(32, 35).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(1.0f)).m_171514_(34, 67).m_171488_(-3.0f, -20.0f, -6.0f, 2.0f, 16.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(34, 35).m_171488_(-5.0f, -6.0f, -6.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(58, 67).m_171488_(-1.0f, -13.0f, -6.0f, 1.0f, 9.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 22).m_171488_(-6.0f, -6.0f, -5.0f, 12.0f, 2.0f, 11.0f, new CubeDeformation(0.0f)).m_171514_(34, 38).m_171488_(2.0f, -6.0f, -6.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(40, 67).m_171488_(0.0f, -15.0f, -6.0f, 2.0f, 11.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(35, 22).m_171488_(3.0f, -10.0f, -6.0f, 2.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r1 = head.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(46, 67).m_171488_(-0.5f, -4.0f, -1.0f, 1.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.5f, (float)-8.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)-0.2182f));
            PartDefinition cube_r2 = head.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(52, 67).m_171488_(-0.5f, -4.0f, -1.0f, 1.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)5.5f, (float)-8.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.1309f));
            PartDefinition cube_r3 = head.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(0, 35).m_171488_(-1.0f, -3.5f, -0.5f, 2.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.0f, (float)-7.5f, (float)-6.5f, (float)0.0f, (float)0.0f, (float)-0.2618f));
            PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(44, 0).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(1.01f)).m_171514_(0, 0).m_171488_(-6.0f, -3.0f, 3.0f, 12.0f, 12.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(35, 22).m_171488_(-4.0f, -5.0f, 5.0f, 8.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r4 = body.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(6, 67).m_171488_(4.25f, -7.25f, -1.0f, 3.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(1.25f, -5.25f, -1.0f, 3.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(66, 34).m_171488_(-0.75f, -5.25f, -1.0f, 2.0f, 18.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.75f, (float)-13.75f, (float)8.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
            PartDefinition cube_r5 = body.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(16, 67).m_171488_(-9.0f, -2.0f, -1.5f, 6.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 22).m_171488_(-7.0f, -10.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 51).m_171488_(-7.0f, -1.0f, -0.5f, 2.0f, 26.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-13.0f, (float)10.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
            PartDefinition right_arm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(54, 51).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.0f)), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
            PartDefinition cube_r6 = right_arm.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(0, 35).m_171488_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.48f));
            PartDefinition left_arm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(38, 51).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.0f)), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
            PartDefinition cube_r7 = left_arm.m_171599_("cube_r7", CubeListBuilder.m_171558_().m_171514_(44, 16).m_171488_(-6.0f, -0.5f, -1.0f, 12.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)6.7014f, (float)-1.8278f, (float)3.0f, (float)0.0f, (float)-0.2182f, (float)0.2618f));
            PartDefinition cube_r8 = left_arm.m_171599_("cube_r8", CubeListBuilder.m_171558_().m_171514_(44, 19).m_171488_(0.0f, -4.0f, -1.0f, 12.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
            PartDefinition cube_r9 = left_arm.m_171599_("cube_r9", CubeListBuilder.m_171558_().m_171514_(46, 31).m_171488_(-6.0f, -0.5f, -1.0f, 12.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)6.7599f, (float)-2.3073f, (float)-3.0f, (float)0.0f, (float)0.2618f, (float)0.2618f));
            PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(22, 51).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.0f)).m_171514_(65, 62).m_171488_(-2.0f, 10.0f, -7.0f, 4.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
            PartDefinition cube_r10 = right_leg.m_171599_("cube_r10", CubeListBuilder.m_171558_().m_171514_(56, 34).m_171488_(-1.5f, -1.5f, -1.0f, 3.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(24, 35).m_171488_(-1.5f, -1.5f, -3.0f, 3.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)7.5f, (float)-6.0f, (float)0.48f, (float)0.0f, (float)0.0f));
            PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(65, 22).m_171488_(-1.8f, 10.0f, -7.0f, 4.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(6, 51).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.0f)), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
            PartDefinition cube_r11 = left_leg.m_171599_("cube_r11", CubeListBuilder.m_171558_().m_171514_(34, 7).m_171488_(2.5f, -1.7f, -1.2f, 3.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.8f, (float)7.5f, (float)-6.0f, (float)0.48f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r12 = left_leg.m_171599_("cube_r12", CubeListBuilder.m_171558_().m_171514_(34, 0).m_171488_(-1.5f, -2.5f, -2.0f, 3.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.2f, (float)8.7544f, (float)-6.653f, (float)0.48f, (float)0.0f, (float)0.0f));
            return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
        }
    }
}

