/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.modification;

import com.google.common.collect.Lists;
import iskallia.vault.event.event.GearModificationEvent;
import iskallia.vault.gear.crafting.VaultGearCraftingHelper;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class GearModification
extends ForgeRegistryEntry<GearModification> {
    private final Component description;

    public GearModification(ResourceLocation id) {
        this.setRegistryName(id);
        this.description = this.makeModificationComponent("description", new Component[0]);
    }

    protected TranslatableComponent makeModificationComponent(String suffix, Component ... arguments) {
        return new TranslatableComponent(this.getTranslationKey(suffix), arguments == null ? new Object[]{} : arguments);
    }

    protected String getTranslationKey(String suffix) {
        return String.format("the_vault.gear_modification.%s.%s", this.getRegistryName().m_135815_(), suffix);
    }

    protected String getGenericTranslationKey(String suffix) {
        return String.format("the_vault.gear_modification.%s", suffix);
    }

    public List<Component> getDescription(ItemStack materialStack) {
        return Lists.newArrayList((Object[])new Component[]{this.description.m_6881_()});
    }

    public Predicate<ItemStack> getStackFilter() {
        return stack -> stack.m_150930_(this.getDisplayStack().m_41720_());
    }

    public abstract ItemStack getDisplayStack();

    public abstract Result doModification(ItemStack var1, ItemStack var2, Player var3, Random var4);

    public boolean apply(ItemStack stack, ItemStack materialStack, Player player, Random rand) {
        if (!this.doModification(stack, materialStack, player, rand).success()) {
            return false;
        }
        VaultGearCraftingHelper.reducePotential(stack, player, this);
        MinecraftForge.EVENT_BUS.post((Event)new GearModificationEvent(player, this));
        return true;
    }

    public Result canApply(ItemStack stack, ItemStack materialStack, Player player, Random rand) {
        return this.doModification(stack.m_41777_(), materialStack, player, rand);
    }

    public record Result(boolean success, boolean genericError, String errorSuffixKey, @Nullable Component[] arguments) {
        public static Result makeSuccess() {
            return new Result(true, false, "", new Component[0]);
        }

        public static Result makeGenericError(String suffix, Component ... arguments) {
            return new Result(false, true, suffix, arguments);
        }

        public static Result makeActionError(String suffix, Component ... arguments) {
            return new Result(false, false, suffix, arguments);
        }

        public static Result errorUnmodifiable() {
            return Result.makeGenericError("unmodifiable", new Component[0]);
        }

        public static Result errorInternal() {
            return Result.makeGenericError("internal_error", new Component[0]);
        }

        public MutableComponent getError(GearModification mod) {
            if (this.genericError) {
                String key = mod.getGenericTranslationKey(this.errorSuffixKey);
                Object[] args = this.arguments == null ? new Object[]{} : this.arguments;
                return new TranslatableComponent(key, args).m_130940_(ChatFormatting.RED);
            }
            return mod.makeModificationComponent(this.errorSuffixKey, new Component[0]).m_130940_(ChatFormatting.RED);
        }
    }
}

