/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.modification;

import iskallia.vault.config.gear.VaultGearModificationConfig;
import iskallia.vault.gear.modification.GearModification;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearModifications;
import net.minecraft.util.Mth;

public record GearModificationCost(int costPlating, int costBronze) {
    private static final float BASE_PLATING_COST = 4.0f;
    private static final float BASE_BRONZE_COST = 35.0f;
    private static final float BASE_POTENTIAL_SCALING_COST = 200.0f;

    public static GearModificationCost getCost(int gearPotential, float maxPotential, GearModification modification, int level) {
        VaultGearModificationConfig.OperationConfig cfg = ModConfigs.VAULT_GEAR_MODIFICATION_CONFIG.getOperationConfig(modification);
        if (cfg == null) {
            return new GearModificationCost(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        float maxPotentialMultiplier = Math.max(maxPotential / 200.0f, 1.0f);
        float multiplier = cfg.getBaseCostMultiplier() * maxPotentialMultiplier;
        float basePlating = Math.max(4.0f * multiplier, 1.0f);
        float baseBronze = 35.0f * multiplier;
        if (modification == ModGearModifications.IMPROVE_GEARLEVEL) {
            basePlating = (float)level * 1.0f;
            baseBronze = (float)level * cfg.getBaseCostMultiplier();
            float positiveCostPlating = basePlating;
            float positiveCostBronze = baseBronze;
            if (gearPotential < 0) {
                float potentialPercent = Mth.m_14036_((float)Math.max(0.01f, maxPotential), (float)1.0f, (float)25.0f);
                positiveCostPlating = Math.max(Math.round(basePlating * potentialPercent), 1);
                positiveCostBronze = Math.max(Math.round(baseBronze * potentialPercent), 1);
                int absPotential = Math.abs(gearPotential);
                float negativeMultiplier = cfg.getNegativePotentialCostMultiplier();
                float scale = 1.0f + (float)absPotential * negativeMultiplier / 20.0f;
                float negativeCostPlating = Math.max(Math.round(basePlating * (scale - 1.0f)), 0);
                float negativeCostBronze = Math.max(Math.round(baseBronze * (scale - 1.0f)), 0);
                return new GearModificationCost(Math.max(Math.round(positiveCostPlating + negativeCostPlating), 1), Math.max(Math.round(positiveCostBronze + negativeCostBronze), 1));
            }
            float potentialPercent = Mth.m_14036_((float)Math.max(0.01f, maxPotential / Math.max((float)gearPotential, 1.0f)), (float)1.0f, (float)25.0f);
            positiveCostPlating = Math.max(Math.round(basePlating * potentialPercent), 1);
            positiveCostBronze = Math.max(Math.round(baseBronze * potentialPercent), 1);
            return new GearModificationCost((int)positiveCostPlating, (int)positiveCostBronze);
        }
        if (gearPotential >= 0) {
            float potentialPercent = Mth.m_14036_((float)Math.max(0.01f, 1.0f - (float)gearPotential / maxPotential), (float)0.01f, (float)1.0f);
            int offset = 3;
            return new GearModificationCost(Math.max(Math.round(basePlating), 1), Math.max(offset + Math.round((baseBronze - (float)offset) * potentialPercent), 1));
        }
        int absPotential = Math.abs(gearPotential);
        float negativeMultiplier = cfg.getNegativePotentialCostMultiplier();
        float scale = 1.0f + (float)absPotential * negativeMultiplier / 20.0f;
        return new GearModificationCost(Math.max(Math.round(basePlating * scale), 1), Math.max(Math.round(baseBronze * scale), 1));
    }
}

