/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.modification.operation;

import iskallia.vault.VaultMod;
import iskallia.vault.gear.VaultGearLegendaryHelper;
import iskallia.vault.gear.VaultGearModifierHelper;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.modification.GearModification;
import iskallia.vault.init.ModItems;
import iskallia.vault.util.MiscUtils;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.function.TriFunction;

public class CorruptGearModification
extends GearModification {
    public CorruptGearModification() {
        super(VaultMod.id("corrupt_gear"));
    }

    @Override
    public ItemStack getDisplayStack() {
        return new ItemStack((ItemLike)ModItems.VORPAL_FOCUS);
    }

    @Override
    public GearModification.Result canApply(ItemStack stack, ItemStack materialStack, Player player, Random rand) {
        if (stack.m_150930_((Item)ModItems.VOID_STONE)) {
            return GearModification.Result.errorUnmodifiable();
        }
        if (!((AttributeGearData)AttributeGearData.read(stack)).isModifiable()) {
            return GearModification.Result.errorUnmodifiable();
        }
        return GearModification.Result.makeSuccess();
    }

    @Override
    public GearModification.Result doModification(ItemStack stack, ItemStack materialStack, Player player, Random rand) {
        List indices = IntStream.range(0, Operation.values().length).boxed().collect(Collectors.toList());
        Collections.shuffle(indices, rand);
        Iterator iterator = indices.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            Operation operation = MiscUtils.getEnumEntry(Operation.class, index);
            GearModification.Result result = operation.apply(stack.m_41777_(), player, rand);
            if (!result.success()) continue;
            operation.apply(stack, player, rand);
            return GearModification.Result.makeSuccess();
        }
        return GearModification.Result.errorInternal();
    }

    static enum Operation {
        NOTHING((TriFunction<ItemStack, Player, Random, GearModification.Result>)((TriFunction)(stack, player, random) -> GearModification.Result.makeSuccess())),
        IMPROVE_ONE((TriFunction<ItemStack, Player, Random, GearModification.Result>)((TriFunction)(stack, player, random) -> VaultGearLegendaryHelper.improveExistingModifier(stack, 1, random, List.of(VaultGearModifier.AffixCategory.CORRUPTED)))),
        REROLL_ALL((TriFunction<ItemStack, Player, Random, GearModification.Result>)((TriFunction)(stack, player, random) -> {
            GearModification.Result result = VaultGearModifierHelper.reForgeAllModifiers(stack, random);
            if (!result.success()) {
                return result;
            }
            return VaultGearModifierHelper.generateCorruptedImplicit(stack, random);
        })),
        ADD_IMPLICIT((TriFunction<ItemStack, Player, Random, GearModification.Result>)((TriFunction)(stack, player, random) -> VaultGearModifierHelper.generateCorruptedImplicit(stack, random)));

        private final TriFunction<ItemStack, Player, Random, GearModification.Result> applyFn;

        private Operation(TriFunction<ItemStack, Player, Random, GearModification.Result> applyFn) {
            this.applyFn = applyFn;
        }

        private GearModification.Result apply(ItemStack stack, Player player, Random random) {
            GearModification.Result res = (GearModification.Result)this.applyFn.apply((Object)stack, (Object)player, (Object)random);
            if (!res.success()) {
                return res;
            }
            return VaultGearModifierHelper.setGearCorrupted(stack);
        }
    }
}

