/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.modification.operation;

import iskallia.vault.VaultMod;
import iskallia.vault.gear.VaultGearModifierHelper;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.modification.GearModification;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.util.SidedHelper;
import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ImproveGearlevelModification
extends GearModification {
    public ImproveGearlevelModification() {
        super(VaultMod.id("improve_gear_level"));
    }

    @Override
    public ItemStack getDisplayStack() {
        return new ItemStack((ItemLike)ModItems.ADAPTIVE_FOCUS);
    }

    @Override
    public GearModification.Result doModification(ItemStack stack, ItemStack materialStack, Player player, Random rand) {
        VaultGearData data = VaultGearData.read(stack);
        String craftedBY = (String)data.get(ModGearAttributes.CRAFTED_BY, VaultGearAttributeTypeMerger.firstNonNull());
        if (!data.isModifiable() || craftedBY != null && !craftedBY.isEmpty()) {
            return GearModification.Result.makeActionError("crafted", new Component[0]);
        }
        return VaultGearModifierHelper.reforgeModifiersForNewLevel(stack, SidedHelper.getVaultLevel(player), rand, true);
    }
}

