/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.reader;

import com.google.gson.JsonArray;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.reader.VaultGearModifierReader;
import java.text.DecimalFormat;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;

public abstract class DecimalModifierReader<T extends Number>
extends VaultGearModifierReader<T> {
    protected static final DecimalFormat FORMAT = new DecimalFormat("0.##");

    public DecimalModifierReader(String modifierName, int rgbColor) {
        super(modifierName, rgbColor);
    }

    @Override
    @Nullable
    public MutableComponent getDisplay(VaultGearAttributeInstance<T> instance, VaultGearModifier.AffixType type) {
        MutableComponent valueDisplay = this.getValueDisplay((Number)instance.getValue());
        if (valueDisplay == null) {
            return null;
        }
        return new TextComponent(type.getAffixPrefix(((Number)instance.getValue()).doubleValue() >= 0.0)).m_130948_(this.getColoredTextStyle()).m_7220_((Component)valueDisplay).m_130948_(this.getColoredTextStyle()).m_7220_((Component)new TextComponent(" " + this.getModifierName())).m_130948_(this.getColoredTextStyle());
    }

    @Override
    protected void serializeTextElements(JsonArray out, VaultGearAttributeInstance<T> instance, VaultGearModifier.AffixType type) {
        MutableComponent valueDisplay = this.getValueDisplay((Number)instance.getValue());
        if (valueDisplay == null) {
            return;
        }
        out.add(type.getAffixPrefix(((Number)instance.getValue()).doubleValue() >= 0.0));
        out.add(valueDisplay.getString());
        out.add(" " + this.getModifierName());
    }

    public static class Round<T extends Float>
    extends DecimalModifierReader<T> {
        private final float multiplier;

        public Round(String modifierName, int rgbColor) {
            this(modifierName, rgbColor, 1.0f);
        }

        public Round(String modifierName, int rgbColor, float multiplier) {
            super(modifierName, rgbColor);
            this.multiplier = multiplier;
        }

        @Override
        @Nullable
        public MutableComponent getValueDisplay(T value) {
            return new TextComponent(String.valueOf(Math.round(((Float)value).floatValue() * this.multiplier)));
        }
    }

    public static class Added<T extends Number>
    extends DecimalModifierReader<T> {
        public Added(String modifierName, int rgbColor) {
            super(modifierName, rgbColor);
        }

        @Override
        @Nullable
        public MutableComponent getValueDisplay(T value) {
            return new TextComponent(FORMAT.format(value));
        }
    }

    public static class Percentage<T extends Number>
    extends DecimalModifierReader<T> {
        public Percentage(String modifierName, int rgbColor) {
            super(modifierName, rgbColor);
        }

        @Override
        @Nullable
        public MutableComponent getValueDisplay(T value) {
            return new TextComponent(FORMAT.format(((Number)value).doubleValue() * 100.0) + "%");
        }
    }
}

