/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.reader;

import com.google.gson.JsonArray;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.reader.VaultGearModifierReader;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class FlagModifierReader
extends VaultGearModifierReader<Boolean> {
    private final String moreInfo;

    public FlagModifierReader(String modifierName, int rgbColor) {
        super(modifierName, rgbColor);
        this.moreInfo = null;
    }

    public FlagModifierReader(String modifierName, int rgbColor, String moreInfo) {
        super(modifierName, rgbColor);
        this.moreInfo = moreInfo;
    }

    @Override
    public MutableComponent getDisplay(VaultGearAttributeInstance<Boolean> instance, VaultGearModifier.AffixType type) {
        return new TextComponent(type.getAffixPrefix(true) + this.getModifierName()).m_130948_(this.getColoredTextStyle());
    }

    @Override
    @Nullable
    public MutableComponent getDisplay(VaultGearAttributeInstance<Boolean> instance, VaultGearData data, VaultGearModifier.AffixType type, ItemStack stack, boolean displayDetail) {
        if (this.moreInfo != null && displayDetail) {
            return Objects.requireNonNull(this.getDisplay(instance, type)).m_7220_((Component)new TextComponent(" (" + this.moreInfo + ")").m_130940_(ChatFormatting.GRAY));
        }
        return this.getDisplay(instance, type);
    }

    @Override
    @Nullable
    public MutableComponent getValueDisplay(Boolean value) {
        return null;
    }

    @Override
    protected void serializeTextElements(JsonArray out, VaultGearAttributeInstance<Boolean> instance, VaultGearModifier.AffixType type) {
        out.add(type.getAffixPrefix(true));
        out.add(this.getModifierName());
    }
}

