/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.reader;

import com.google.gson.JsonArray;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.reader.DecimalModifierReader;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;

public class SweepingDamageReader
extends DecimalModifierReader<Float> {
    public SweepingDamageReader(int rgbColor) {
        super("Sweeping Hit Damage", rgbColor);
    }

    @Override
    @Nullable
    public MutableComponent getDisplay(VaultGearAttributeInstance<Float> instance, VaultGearModifier.AffixType type) {
        MutableComponent valueDisplay = this.getValueDisplay(instance.getValue());
        if (valueDisplay == null) {
            return null;
        }
        return new TextComponent(type.getAffixPrefix(instance.getValue().doubleValue() >= 0.0)).m_130948_(this.getColoredTextStyle()).m_7220_((Component)valueDisplay).m_130948_(this.getColoredTextStyle()).m_7220_((Component)new TextComponent(" of Attack Damage dealt as Sweeping Hit").m_130948_(this.getColoredTextStyle()));
    }

    @Override
    @Nullable
    public MutableComponent getValueDisplay(Float value) {
        return new TextComponent(FORMAT.format(value.doubleValue() * 100.0) + "%");
    }

    @Override
    protected void serializeTextElements(JsonArray out, VaultGearAttributeInstance<Float> instance, VaultGearModifier.AffixType type) {
        MutableComponent valueDisplay = this.getValueDisplay(instance.getValue());
        if (valueDisplay == null) {
            return;
        }
        out.add(type.getAffixPrefix(instance.getValue().doubleValue() >= 0.0));
        out.add(valueDisplay.getString());
        out.add(" of Attack Damage dealt as Sweeping Hit");
    }
}

