/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.tooltip;

import com.mojang.blaze3d.platform.InputConstants;
import iskallia.vault.client.gui.overlay.VaultBarOverlay;
import iskallia.vault.config.UniqueGearConfig;
import iskallia.vault.config.gear.VaultEtchingConfig;
import iskallia.vault.dynamodel.model.armor.ArmorPieceModel;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.etching.EtchingHelper;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.gear.tooltip.GearTooltip;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.util.TextUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface VaultGearTooltipItem {
    default public List<Component> createTooltip(ItemStack stack, GearTooltip flag) {
        if (!ModConfigs.isInitialized()) {
            return Collections.emptyList();
        }
        long window = Minecraft.m_91087_().m_91268_().m_85439_();
        boolean shiftDown = InputConstants.m_84830_((long)window, (int)340) || InputConstants.m_84830_((long)window, (int)344);
        VaultGearData data = VaultGearData.read(stack);
        ArrayList<Component> tooltip = new ArrayList<Component>();
        VaultGearState state = data.getState();
        if (shiftDown && data.getState() == VaultGearState.IDENTIFIED && data.hasAttribute(ModGearAttributes.UNIQUE_ITEM_KEY)) {
            data.getFirstValue(ModGearAttributes.UNIQUE_ITEM_KEY).flatMap(ModConfigs.UNIQUE_GEAR::getEntry).map(UniqueGearConfig.Entry::getLore).filter(lore -> !lore.isEmpty()).map(TextUtil::applyColorTags).ifPresent(mutableComponent -> tooltip.add((Component)mutableComponent.m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC)));
        }
        this.addTooltipItemLevel(data, stack, tooltip, state);
        if (flag.displayCraftingDetail()) {
            this.addTooltipCraftingPotential(data, stack, tooltip, state);
            this.addTooltipToolCapacity(data, stack, tooltip, state);
        }
        if (flag.displayBase()) {
            data.getFirstValue(ModGearAttributes.CRAFTED_BY).ifPresent(crafter -> tooltip.add((Component)new TextComponent("Crafted by: ").m_7220_((Component)new TextComponent(crafter).m_6270_(Style.f_131099_.m_178520_(16770048)))));
        }
        if (shiftDown || state == VaultGearState.UNIDENTIFIED) {
            this.addTooltipRarity(data, stack, tooltip, state);
        }
        if (state == VaultGearState.IDENTIFIED) {
            VaultGearItem gearItem;
            EquipmentSlot slot;
            Item item;
            if (flag.displayBase()) {
                this.addTooltipEtchingSet(stack, tooltip, data);
            }
            if ((item = stack.m_41720_()) instanceof VaultGearItem && (slot = (gearItem = (VaultGearItem)item).getGearType(stack).getEquipmentSlot()) != null) {
                this.addSlotTooltip(tooltip, slot);
            }
            int usedRepairs = data.getUsedRepairSlots();
            int totalRepairs = data.getRepairSlots();
            this.addRepairTooltip(tooltip, usedRepairs, totalRepairs);
            this.addTooltipDurability(tooltip, stack);
            if (shiftDown && flag.displayBase()) {
                this.addTooltipGearModel(data, stack, tooltip);
            }
            this.addTooltipImportantBaseAttributes(data, stack, tooltip, flag.displayModifierDetail());
            List<VaultGearModifier<?>> implicits = data.getModifiers(VaultGearModifier.AffixType.IMPLICIT);
            if (!implicits.isEmpty()) {
                this.addTooltipAffixGroup(data, VaultGearModifier.AffixType.IMPLICIT, stack, tooltip, flag.displayModifierDetail());
                tooltip.add(TextComponent.f_131282_);
            }
            int maxPrefixes = data.getFirstValue(ModGearAttributes.PREFIXES).orElse(0);
            List<VaultGearModifier<?>> prefixes = data.getModifiers(VaultGearModifier.AffixType.PREFIX);
            int maxSuffixes = data.getFirstValue(ModGearAttributes.SUFFIXES).orElse(0);
            List<VaultGearModifier<?>> suffixes = data.getModifiers(VaultGearModifier.AffixType.SUFFIX);
            if (maxPrefixes > 0 || !prefixes.isEmpty()) {
                this.addTooltipAffixGroup(data, VaultGearModifier.AffixType.PREFIX, stack, tooltip, flag.displayModifierDetail());
                if (flag.displayModifierDetail() && (maxSuffixes > 0 || !suffixes.isEmpty())) {
                    tooltip.add(TextComponent.f_131282_);
                }
            }
            if (maxSuffixes > 0 || !suffixes.isEmpty()) {
                this.addTooltipAffixGroup(data, VaultGearModifier.AffixType.SUFFIX, stack, tooltip, flag.displayModifierDetail());
                if (!data.isModifiable()) {
                    tooltip.add(TextComponent.f_131282_);
                }
            }
        }
        if (!data.isModifiable()) {
            MutableComponent ct = new TextComponent("").m_7220_((Component)new TextComponent("Corrupted").m_6270_(Style.f_131099_.m_178520_(0xAD0000)));
            if (flag.displayModifierDetail()) {
                ct.m_7220_((Component)new TextComponent(" (Unmodifiable Item)").m_130940_(ChatFormatting.GRAY));
            }
            tooltip.add((Component)ct);
        }
        return tooltip;
    }

    default public void addTooltipAffixGroup(VaultGearData data, VaultGearModifier.AffixType type, ItemStack stack, List<Component> tooltip, boolean displayDetails) {
        List<VaultGearModifier<?>> affixes = data.getModifiers(type);
        VaultGearAttribute<Integer> affixAttribute = type == VaultGearModifier.AffixType.PREFIX ? ModGearAttributes.PREFIXES : ModGearAttributes.SUFFIXES;
        int emptyAffixes = data.getFirstValue(affixAttribute).orElse(0);
        if (displayDetails) {
            tooltip.add((Component)new TextComponent(type.getPlural() + ":").m_130940_(ChatFormatting.GRAY));
        }
        affixes.forEach(modifier -> modifier.getDisplay(data, type, stack, displayDetails).ifPresent(tooltip::add));
        if (displayDetails && type != VaultGearModifier.AffixType.IMPLICIT) {
            for (int i = 0; i < emptyAffixes - affixes.size(); ++i) {
                tooltip.add(this.addTooltipEmptyAffixes(type));
            }
        }
    }

    default public void addRepairTooltip(List<Component> tooltip, int usedRepairs, int totalRepairs) {
        if (totalRepairs <= 0) {
            return;
        }
        int remaining = totalRepairs - usedRepairs;
        tooltip.add((Component)new TextComponent("Repairs: ").m_7220_(this.addTooltipDots(usedRepairs, ChatFormatting.YELLOW)).m_7220_(this.addTooltipDots(remaining, ChatFormatting.GRAY)));
    }

    default public void addSlotTooltip(List<Component> tooltip, EquipmentSlot slot) {
        tooltip.add((Component)new TextComponent("Slot: ").m_7220_((Component)new TranslatableComponent("the_vault.equipment." + slot.m_20751_()).m_130948_(Style.f_131099_.m_178520_(14869130))));
    }

    default public void addTooltipEtchingSet(ItemStack stack, List<Component> tooltip, VaultGearData data) {
        data.getFirstValue(ModGearAttributes.ETCHING).ifPresent(etchingId -> {
            VaultEtchingConfig.EtchingEntry cfg = ModConfigs.ETCHINGS.getEtchingConfig((ResourceLocation)etchingId);
            if (cfg == null) {
                return;
            }
            boolean shiftDown = Screen.m_96638_();
            tooltip.add((Component)new TextComponent("Etching: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)new TextComponent(cfg.getName()).m_6270_(Style.f_131099_.m_131148_(cfg.getComponentColor()))));
            if (shiftDown) {
                String desc = EtchingHelper.formatDescription(cfg.getDescription(), EtchingHelper.getEtching(stack));
                tooltip.add((Component)new TextComponent("  ").m_7220_((Component)TextUtil.applyColorTags(desc)).m_130940_(ChatFormatting.DARK_GRAY));
            }
        });
    }

    default public void addTooltipImportantBaseAttributes(VaultGearData data, ItemStack stack, List<Component> tooltip, boolean displayDetail) {
        int txtLength = tooltip.size();
        data.getAttributes(ModGearAttributes.DURABILITY).filter(inst -> (Integer)inst.getValue() > 0).forEach(attr -> attr.getDisplay(data, VaultGearModifier.AffixType.IMPLICIT, stack, displayDetail).ifPresent(tooltip::add));
        data.getAttributes(ModGearAttributes.SOULBOUND).filter(VaultGearAttributeInstance::getValue).forEach(attr -> attr.getDisplay(data, VaultGearModifier.AffixType.IMPLICIT, stack, displayDetail).ifPresent(tooltip::add));
        data.getAttributes(ModGearAttributes.LIVING).filter(VaultGearAttributeInstance::getValue).forEach(attr -> attr.getDisplay(data, VaultGearModifier.AffixType.IMPLICIT, stack, displayDetail).ifPresent(tooltip::add));
        if (tooltip.size() > txtLength && displayDetail) {
            tooltip.add(TextComponent.f_131282_);
        }
    }

    default public void addTooltipGearModel(VaultGearData data, ItemStack stack, List<Component> tooltip) {
        data.getFirstValue(ModGearAttributes.GEAR_MODEL).flatMap(modelId -> ModDynamicModels.REGISTRIES.getModel(stack.m_41720_(), (ResourceLocation)modelId)).ifPresent(gearModel -> {
            Item patt10111$temp = stack.m_41720_();
            if (patt10111$temp instanceof VaultGearItem) {
                VaultGearItem gearItem = (VaultGearItem)patt10111$temp;
                String name = gearModel.getDisplayName();
                if (gearModel instanceof ArmorPieceModel) {
                    ArmorPieceModel modelPiece = (ArmorPieceModel)gearModel;
                    name = modelPiece.getArmorModel().getDisplayName();
                }
                VaultGearRarity rollRarity = ModConfigs.GEAR_MODEL_ROLL_RARITIES.getRarityOf(stack, gearModel.getId());
                MutableComponent modelTooltip = new TextComponent("Model: ").m_130944_(new ChatFormatting[0]).m_7220_((Component)new TextComponent(name).m_130948_(Style.f_131099_.m_178520_(rollRarity.getColor().m_131265_())));
                tooltip.add((Component)modelTooltip);
            }
        });
    }

    default public void addTooltipRarity(VaultGearData data, ItemStack stack, List<Component> tooltip, VaultGearState state) {
        switch (state) {
            case UNIDENTIFIED: {
                data.getFirstValue(ModGearAttributes.GEAR_ROLL_TYPE).flatMap(ModConfigs.VAULT_GEAR_TYPE_CONFIG::getRollPool).ifPresent(pool -> tooltip.add((Component)new TextComponent("Roll: ").m_7220_((Component)new TextComponent(pool.getName()).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)pool.getColor()))))));
                break;
            }
            case IDENTIFIED: {
                MutableComponent rarityText = new TextComponent("Rarity: ").m_7220_((Component)data.getRarity().getDisplayName().m_6881_().m_130948_(Style.f_131099_.m_131148_(data.getRarity().getColor())));
                tooltip.add((Component)rarityText);
            }
        }
    }

    default public void addTooltipItemLevel(VaultGearData data, ItemStack stack, List<Component> tooltip, VaultGearState state) {
        if (VaultBarOverlay.vaultLevel >= data.getItemLevel()) {
            tooltip.add((Component)new TextComponent("Level: ").m_7220_((Component)new TextComponent(String.valueOf(data.getItemLevel())).m_6270_(Style.f_131099_.m_178520_(11583738))));
        } else {
            tooltip.add((Component)new TextComponent("Requires Level: ").m_130940_(ChatFormatting.RED).m_7220_((Component)new TextComponent(String.valueOf(data.getItemLevel())).m_130940_(ChatFormatting.RED)));
        }
    }

    default public void addTooltipCraftingPotential(VaultGearData data, ItemStack stack, List<Component> tooltip, VaultGearState state) {
        if (state != VaultGearState.IDENTIFIED) {
            return;
        }
        data.getFirstValue(ModGearAttributes.CRAFTING_POTENTIAL).ifPresent(craftingPotential -> {
            TextComponent potential = new TextComponent(String.valueOf(craftingPotential));
            int maxPotential = 0;
            int color = Color.HSBtoRGB(0.0f, 1.0f, 0.66f);
            if (data.hasAttribute(ModGearAttributes.MAX_CRAFTING_POTENTIAL) && (maxPotential = data.getFirstValue(ModGearAttributes.MAX_CRAFTING_POTENTIAL).orElse(0).intValue()) > 0) {
                float percentage = Math.max((float)craftingPotential.intValue() / (float)maxPotential, 0.0f);
                color = Color.HSBtoRGB(0.33f * percentage, 1.0f, 0.66f);
            }
            if (craftingPotential > 0) {
                potential.m_130948_(Style.f_131099_.m_178520_(color));
            } else {
                potential.m_130948_(Style.f_131099_.m_178520_(color));
            }
            MutableComponent txt = new TextComponent("").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent("Crafting Potential: ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)potential);
            if (maxPotential > 0) {
                txt.m_130946_("/").m_130946_(String.valueOf(maxPotential));
            }
            tooltip.add((Component)txt);
        });
    }

    default public void addTooltipToolCapacity(VaultGearData data, ItemStack stack, List<Component> tooltip, VaultGearState state) {
        if (state != VaultGearState.IDENTIFIED) {
            return;
        }
        data.getFirstValue(ModGearAttributes.TOOL_CAPACITY).ifPresent(craftingPotential -> {
            TextComponent potential = new TextComponent(String.valueOf(craftingPotential));
            if (craftingPotential > 0) {
                potential.m_130948_(Style.f_131099_.m_178520_(16757593));
            } else {
                potential.m_130940_(ChatFormatting.RED);
            }
            tooltip.add((Component)new TextComponent("Capacity: ").m_7220_((Component)potential));
        });
    }

    default public Component addTooltipEmptyAffixes(VaultGearModifier.AffixType type) {
        return new TextComponent("\u25a0 empty %s".formatted(type.name().toLowerCase(Locale.ROOT))).m_130940_(ChatFormatting.GRAY);
    }

    default public Component addTooltipDots(int amount, ChatFormatting formatting) {
        return new TextComponent("\u2b22 ".repeat(Math.max(0, amount))).m_130940_(formatting);
    }

    default public void addTooltipDurability(List<Component> tooltip, ItemStack stack) {
        if (VaultGearItem.of(stack).isBroken(stack)) {
            tooltip.add((Component)new TextComponent("Durability: ").m_7220_((Component)new TextComponent("BROKEN").m_130940_(ChatFormatting.RED)));
        } else if (stack.m_41763_() && stack.m_41776_() > 0) {
            tooltip.add((Component)new TextComponent("Durability: ").m_7220_((Component)new TextComponent("%d/%d".formatted(stack.m_41776_() - stack.m_41773_(), stack.m_41776_())).m_130940_(ChatFormatting.GRAY)));
        }
    }
}

