/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.trinket;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.TrinketConfig;
import iskallia.vault.core.vault.ClientVaults;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.gear.TrinketItem;
import iskallia.vault.world.data.ServerVaults;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.Nullable;

public abstract class TrinketEffect<T extends Config>
extends ForgeRegistryEntry<TrinketEffect<?>> {
    public TrinketEffect(ResourceLocation name) {
        this.setRegistryName(name);
    }

    public abstract Class<T> getConfigClass();

    public abstract T getDefaultConfig();

    public TrinketConfig.Trinket getTrinketConfig() {
        return ModConfigs.TRINKET.getTrinketConfig(this);
    }

    public T getConfig() {
        return (T)((Config)this.getTrinketConfig().getConfig());
    }

    public boolean isUsable(ItemStack trinket, Player player) {
        Vault vault;
        if (trinket == null) {
            return true;
        }
        if (!TrinketItem.isIdentified(trinket)) {
            return false;
        }
        Vault vault2 = vault = player.f_19853_.f_46443_ ? (Vault)ClientVaults.getActive().orElse(null) : (Vault)ServerVaults.get(player.f_19853_).orElse(null);
        if (vault == null) {
            return TrinketItem.hasUsesLeft(trinket);
        }
        return TrinketItem.isUsableInVault(trinket, vault.get(Vault.ID));
    }

    public void onEquip(LivingEntity entity, @Nullable ItemStack stack) {
    }

    public void onUnEquip(LivingEntity entity, @Nullable ItemStack stack) {
    }

    public void onWornTick(LivingEntity entity, @Nullable ItemStack stack) {
    }

    public static class Config {
        @Expose
        private String curiosSlot = "trinket";

        public Config() {
        }

        public Config(String curiosSlot) {
            this.curiosSlot = curiosSlot;
        }

        public boolean hasCuriosSlot() {
            return !this.getCuriosSlot().isEmpty();
        }

        public String getCuriosSlot() {
            return this.curiosSlot;
        }
    }

    public static class Simple
    extends TrinketEffect<NoOpConfig> {
        public Simple(ResourceLocation name) {
            super(name);
        }

        @Override
        public final Class<NoOpConfig> getConfigClass() {
            return NoOpConfig.class;
        }

        @Override
        public final NoOpConfig getDefaultConfig() {
            return new NoOpConfig();
        }

        public static class NoOpConfig
        extends Config {
        }
    }
}

