/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.trinket;

import iskallia.vault.gear.trinket.TrinketEffect;
import iskallia.vault.gear.trinket.effects.CombinedTrinketEffect;
import iskallia.vault.integration.IntegrationCurios;
import iskallia.vault.item.gear.TrinketItem;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.TieredSkill;
import iskallia.vault.skill.prestige.core.ActivatableTrinketPrestigePower;
import iskallia.vault.skill.prestige.core.TrinketPrestigePower;
import iskallia.vault.skill.prestige.helper.PrestigeHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class TrinketHelper {
    public static List<TrinketStack<TrinketEffect<?>>> getTrinkets(LivingEntity entity) {
        return TrinketHelper.getTrinkets(IntegrationCurios.getCuriosItemStacks(entity), TrinketEffect.class);
    }

    public static <T extends TrinketEffect<?>> List<TrinketStack<T>> getTrinkets(LivingEntity entity, Class<T> trinketClass) {
        List trinkets = TrinketHelper.getTrinkets(IntegrationCurios.getCuriosItemStacks(entity), trinketClass);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            PrestigeHelper.getPrestige(player).iterate(TieredSkill.class, prestige -> {
                LearnableSkill patt1721$temp;
                LearnableSkill patt1403$temp;
                if (prestige.isUnlocked() && (patt1403$temp = prestige.getChild()) instanceof TrinketPrestigePower) {
                    TrinketPrestigePower trinketPrestigePower = (TrinketPrestigePower)patt1403$temp;
                    trinketEffect = trinketPrestigePower.getTrinketEffect();
                    TrinketHelper.addMatchingTrinkets(trinkets, null, trinketEffect, trinketClass);
                } else if (prestige.isUnlocked() && (patt1721$temp = prestige.getChild()) instanceof ActivatableTrinketPrestigePower) {
                    ActivatableTrinketPrestigePower trinketPrestigePower = (ActivatableTrinketPrestigePower)patt1721$temp;
                    if (!trinketPrestigePower.isActive()) {
                        return;
                    }
                    trinketEffect = trinketPrestigePower.getTrinketEffect();
                    TrinketHelper.addMatchingTrinkets(trinkets, null, trinketEffect, trinketClass);
                }
            });
        }
        return trinkets;
    }

    public static <T extends TrinketEffect<?>> List<TrinketStack<T>> getTrinkets(Map<String, List<Tuple<ItemStack, Integer>>> slotCurios, Class<? super T> trinketClass) {
        ArrayList trinkets = new ArrayList();
        slotCurios.values().forEach(curios -> curios.forEach(curioTpl -> {
            ItemStack curioStack = (ItemStack)curioTpl.m_14418_();
            if (!(curioStack.m_41720_() instanceof TrinketItem)) {
                return;
            }
            TrinketItem.getTrinket(curioStack).ifPresent(trinket -> TrinketHelper.addMatchingTrinkets(trinkets, curioStack, trinket, trinketClass));
        }));
        return trinkets;
    }

    private static <T extends TrinketEffect<?>> void addMatchingTrinkets(List<TrinketStack<T>> list, @Nullable ItemStack stack, @Nullable TrinketEffect<?> effect, Class<? super T> clazz) {
        if (effect == null) {
            return;
        }
        if (clazz.isInstance(effect)) {
            list.add(new TrinketStack(stack, effect));
        }
        if (effect instanceof CombinedTrinketEffect) {
            CombinedTrinketEffect combined = (CombinedTrinketEffect)effect;
            combined.getEffects().forEach(child -> {
                if (clazz.isInstance(child)) {
                    list.add(new TrinketStack<TrinketEffect>(stack, (TrinketEffect)((Object)child)));
                }
            });
        }
    }

    public record TrinketStack<T extends TrinketEffect<?>>(@Nullable ItemStack stack, T trinket) {
        public boolean isUsable(Player player) {
            return ((TrinketEffect)((Object)this.trinket())).isUsable(this.stack(), player);
        }
    }
}

