/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.trinket.effects;

import com.google.gson.annotations.Expose;
import iskallia.vault.core.vault.modifier.modifier.EntityEffectModifier;
import iskallia.vault.gear.trinket.TrinketEffect;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.MultiJumpMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AetherTrinket
extends TrinketEffect<AetherConfig> {
    private static boolean clientIsJumpHeld = false;
    private static boolean clientAetherTrinket = false;
    private static boolean clientAetherUsedThisAirTime = false;
    private static int clientAetherTicks = 0;
    private final int durationTicks;
    private final double aetherStrength;

    public AetherTrinket(ResourceLocation name, int durationTicks, double aetherStrength) {
        super(name);
        this.durationTicks = durationTicks;
        this.aetherStrength = aetherStrength;
    }

    @Override
    public Class<AetherConfig> getConfigClass() {
        return AetherConfig.class;
    }

    @Override
    public AetherConfig getDefaultConfig() {
        return new AetherConfig(this.durationTicks, this.aetherStrength);
    }

    @Override
    public void onWornTick(LivingEntity entity, ItemStack stack) {
        Player player;
        super.onWornTick(entity, stack);
        if (entity.m_183503_().m_5776_() && entity instanceof Player && this.isUsable(stack, player = (Player)entity)) {
            this.onClientTick(player);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void onClientTick(Player player) {
        if (!(player instanceof LocalPlayer)) {
            return;
        }
        LocalPlayer clientPlayer = (LocalPlayer)player;
        if (clientPlayer != Minecraft.m_91087_().f_91074_) {
            return;
        }
        if (clientPlayer.m_150110_().f_35935_) {
            return;
        }
        AetherConfig config = (AetherConfig)this.getConfig();
        int maxJetpackTicks = config.getDurationTicks();
        if (clientPlayer.m_20096_()) {
            clientAetherTrinket = false;
            clientAetherTicks = 0;
            clientAetherUsedThisAirTime = false;
        } else if (clientPlayer.f_108618_.f_108572_) {
            if (!clientIsJumpHeld && !clientAetherUsedThisAirTime) {
                clientAetherTrinket = true;
                clientAetherTicks = 0;
                clientAetherUsedThisAirTime = true;
                clientPlayer.m_6135_();
            } else if (clientAetherTrinket && clientAetherTicks < maxJetpackTicks) {
                Vec3 movement = clientPlayer.m_20184_();
                double jetpackStrength = config.getAetherStrength();
                if (jetpackStrength < 0.0) {
                    jetpackStrength = (double)((EntityEffectModifier.ILivingEntityAccessor)clientPlayer).vaultGetJumpPower() + clientPlayer.m_182332_();
                }
                clientPlayer.m_20256_(new Vec3(movement.m_7096_(), jetpackStrength, movement.m_7094_()));
                ModNetwork.CHANNEL.sendToServer((Object)MultiJumpMessage.getInstance());
            }
            if (clientAetherTrinket && ++clientAetherTicks >= maxJetpackTicks) {
                clientAetherTrinket = false;
            }
            clientIsJumpHeld = true;
        } else {
            clientIsJumpHeld = false;
            clientAetherTrinket = false;
        }
    }

    public static class AetherConfig
    extends TrinketEffect.Config {
        @Expose
        private int durationTicks;
        @Expose
        private double aetherStrength;

        public AetherConfig(int durationTicks, double aetherStrength) {
            this.durationTicks = durationTicks;
            this.aetherStrength = aetherStrength;
        }

        public int getDurationTicks() {
            return this.durationTicks;
        }

        public double getAetherStrength() {
            return this.aetherStrength;
        }
    }
}

