/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.trinket.effects;

import iskallia.vault.gear.trinket.TrinketEffect;
import iskallia.vault.gear.trinket.TrinketHelper;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class BounceTrinket
extends TrinketEffect.Simple {
    private static final double BOUNCE_MULTIPLIER = 0.8;
    private static final double MIN_BOUNCE_HEIGHT = 0.5;

    public BounceTrinket(ResourceLocation name) {
        super(name);
    }

    @SubscribeEvent
    public static void onFall(LivingFallEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        List<TrinketHelper.TrinketStack<BounceTrinket>> trinkets = TrinketHelper.getTrinkets((LivingEntity)player, BounceTrinket.class);
        if (trinkets.stream().noneMatch(trinketStack -> trinketStack.isUsable(player))) {
            return;
        }
        float fallDistance = event.getDistance();
        if (fallDistance <= 2.5f || player.m_6047_()) {
            return;
        }
        event.setDamageMultiplier(0.0f);
        event.setCanceled(true);
        double bounceHeight = (double)fallDistance * 0.8;
        if (bounceHeight > 0.5) {
            double upwardVelocity = Math.sqrt(0.16 * bounceHeight) * 1.02;
            player.m_5997_(0.0, upwardVelocity, 0.0);
            player.f_19789_ = 0.0f;
            player.f_19864_ = true;
            player.f_19812_ = true;
            player.m_183503_().m_5594_(null, player.m_142538_(), SoundEvents.f_12387_, SoundSource.BLOCKS, 0.5f, 1.0f);
        }
    }
}

