/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.trinket.effects;

import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.trinket.GearAttributeTrinket;
import iskallia.vault.gear.trinket.TrinketEffect;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class CombinedTrinketEffect
extends TrinketEffect.Simple
implements GearAttributeTrinket {
    private final List<TrinketEffect<?>> effects;

    public CombinedTrinketEffect(ResourceLocation name, List<TrinketEffect<?>> effects) {
        super(name);
        this.effects = effects;
    }

    public List<TrinketEffect<?>> getEffects() {
        return this.effects;
    }

    @Override
    public boolean isUsable(ItemStack trinket, Player player) {
        return super.isUsable(trinket, player);
    }

    @Override
    public void onEquip(LivingEntity entity, ItemStack stack) {
        super.onEquip(entity, stack);
        this.effects.forEach(effect -> effect.onEquip(entity, stack));
    }

    @Override
    public void onUnEquip(LivingEntity entity, ItemStack stack) {
        super.onUnEquip(entity, stack);
        this.effects.forEach(effect -> effect.onUnEquip(entity, stack));
    }

    @Override
    public void onWornTick(LivingEntity entity, ItemStack stack) {
        super.onWornTick(entity, stack);
        this.effects.forEach(effect -> effect.onWornTick(entity, stack));
    }

    @Override
    public List<VaultGearAttributeInstance<?>> getAttributes() {
        ArrayList attributes = new ArrayList();
        return attributes;
    }
}

