/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.trinket.effects;

import iskallia.vault.gear.trinket.TrinketEffect;
import iskallia.vault.gear.trinket.TrinketHelper;
import iskallia.vault.init.ModEffects;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DamageImmunityTrinket
extends TrinketEffect.Simple {
    private final Predicate<DamageSource> dmgImmunityFilter;
    private final boolean isFireDamage;

    public DamageImmunityTrinket(ResourceLocation name, Predicate<DamageSource> dmgImmunityFilter, boolean isFireDamage) {
        super(name);
        this.dmgImmunityFilter = dmgImmunityFilter;
        this.isFireDamage = isFireDamage;
    }

    public boolean isFireDamage() {
        return this.isFireDamage;
    }

    @SubscribeEvent
    public static void onPotionEffect(PotionEvent.PotionApplicableEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            TrinketHelper.getTrinkets((LivingEntity)player, DamageImmunityTrinket.class).forEach(immunityTrinket -> {
                if (((DamageImmunityTrinket)((Object)((Object)immunityTrinket.trinket()))).getRegistryName() != null && ((DamageImmunityTrinket)((Object)((Object)immunityTrinket.trinket()))).getRegistryName().m_135815_().equals("carapace") && !event.getPotionEffect().m_19544_().m_19486_() && event.getPotionEffect().m_19544_() != ModEffects.TIMER_ACCELERATION && event.getPotionEffect().m_19544_() != ModEffects.BLEED) {
                    if (event.getPotionEffect().m_19544_().getRegistryName() != null && (event.getPotionEffect().m_19544_().getRegistryName().m_135827_().equals("xaeroworldmap") || event.getPotionEffect().m_19544_().getRegistryName().m_135827_().equals("xaerominimap"))) {
                        return;
                    }
                    event.setResult(Event.Result.DENY);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onAttack(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            TrinketHelper.getTrinkets((LivingEntity)player, DamageImmunityTrinket.class).forEach(immunityTrinket -> {
                if (immunityTrinket.isUsable(player) && ((DamageImmunityTrinket)((Object)((Object)immunityTrinket.trinket()))).dmgImmunityFilter.test(event.getSource())) {
                    event.setCanceled(true);
                }
            });
        }
    }
}

