/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.trinket.effects;

import com.google.gson.annotations.Expose;
import iskallia.vault.gear.trinket.TrinketEffect;
import iskallia.vault.gear.trinket.TrinketHelper;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DiceTrinket
extends TrinketEffect<DiceConfig> {
    private final float minimumMultiplier;
    private final float maximumMultiplier;

    public DiceTrinket(ResourceLocation name, float minimumMultiplier, float maximumMultiplier) {
        super(name);
        this.minimumMultiplier = minimumMultiplier;
        this.maximumMultiplier = maximumMultiplier;
    }

    @Override
    public Class<DiceConfig> getConfigClass() {
        return DiceConfig.class;
    }

    @Override
    public DiceConfig getDefaultConfig() {
        return new DiceConfig(this.minimumMultiplier, this.maximumMultiplier);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingHurt(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (event.getEntityLiving().m_183503_().m_5776_()) {
            return;
        }
        List<TrinketHelper.TrinketStack<DiceTrinket>> trinkets = TrinketHelper.getTrinkets((LivingEntity)player, DiceTrinket.class);
        TrinketHelper.TrinketStack usableTrinket = trinkets.stream().filter(stack -> stack.isUsable(player)).findFirst().orElse(null);
        if (usableTrinket == null) {
            return;
        }
        DiceTrinket trinketEffect = (DiceTrinket)((Object)usableTrinket.trinket());
        DiceConfig config = (DiceConfig)trinketEffect.getConfig();
        float range = config.getMaximumMultiplier() - config.getMinimumMultiplier();
        float multiplier = config.getMinimumMultiplier() + player.m_21187_().nextFloat() * range;
        float originalDamage = event.getAmount();
        event.setAmount(originalDamage * multiplier);
    }

    public static class DiceConfig
    extends TrinketEffect.Config {
        @Expose
        private float minimumMultiplier;
        @Expose
        private float maximumMultiplier;

        public DiceConfig(float minimumMultiplier, float maximumMultiplier) {
            this.minimumMultiplier = minimumMultiplier;
            this.maximumMultiplier = maximumMultiplier;
        }

        public float getMinimumMultiplier() {
            return this.minimumMultiplier;
        }

        public float getMaximumMultiplier() {
            return this.maximumMultiplier;
        }
    }
}

