/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.trinket.effects;

import com.google.common.collect.Lists;
import com.google.gson.annotations.Expose;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.custom.effect.EffectGearAttribute;
import iskallia.vault.gear.trinket.GearAttributeTrinket;
import iskallia.vault.gear.trinket.TrinketEffect;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.item.gear.TrinketItem;
import iskallia.vault.network.message.ClientboundHunterPositionsMessage;
import iskallia.vault.skill.ability.effect.spi.HunterAbility;
import iskallia.vault.util.calc.AreaOfEffectHelper;
import iskallia.vault.world.data.ServerVaults;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.registries.ForgeRegistries;

public class NightVisionTrinket
extends TrinketEffect<Config>
implements GearAttributeTrinket {
    private final MobEffect effect;
    private final int addedAmplifier;
    private final float radius;

    public NightVisionTrinket(ResourceLocation name, MobEffect effect, int addedAmplifier, float radius) {
        super(name);
        this.effect = effect;
        this.addedAmplifier = addedAmplifier;
        this.radius = radius;
    }

    @Override
    public Class<Config> getConfigClass() {
        return Config.class;
    }

    @Override
    public Config getDefaultConfig() {
        return new Config(this.effect.getRegistryName(), this.addedAmplifier, this.radius);
    }

    @Override
    public List<VaultGearAttributeInstance<?>> getAttributes() {
        Config cfg = (Config)this.getConfig();
        if (cfg.getEffect() == null) {
            return List.of();
        }
        return Lists.newArrayList((Object[])new VaultGearAttributeInstance[]{new VaultGearAttributeInstance<EffectGearAttribute>(ModGearAttributes.EFFECT, new EffectGearAttribute(cfg.getEffect(), cfg.getAddedAmplifier()))});
    }

    @Override
    public void onWornTick(LivingEntity entity, ItemStack stack) {
        super.onWornTick(entity, stack);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (ServerVaults.get(player.f_19853_).isEmpty()) {
                return;
            }
            Optional<TrinketEffect<?>> trinketEffect = TrinketItem.getTrinket(stack);
            if (trinketEffect.isPresent()) {
                if (!trinketEffect.get().isUsable(stack, (Player)player)) {
                    return;
                }
                if (player.f_19797_ % 10 != 0) {
                    return;
                }
                Config cfg = (Config)this.getConfig();
                float radius = AreaOfEffectHelper.adjustAreaOfEffect((LivingEntity)player, null, cfg.radius);
                List<HunterAbility.HighlightPosition> positions = HunterAbility.selectPositions((ServerLevel)player.f_19853_, (Player)player, (double)radius);
                positions.removeIf(highlightPosition -> HunterAbility.Target.OBJECTIVES == highlightPosition.target() || HunterAbility.Target.GOD_ALTARS == highlightPosition.target());
                ModNetwork.CHANNEL.sendTo((Object)new ClientboundHunterPositionsMessage(positions, 30), player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
            }
        }
    }

    public static class Config
    extends TrinketEffect.Config {
        @Expose
        private ResourceLocation effect;
        @Expose
        private int addedAmplifier;
        @Expose
        private float radius;

        public Config(ResourceLocation effect, int addedAmplifier, float radius) {
            this.effect = effect;
            this.addedAmplifier = addedAmplifier;
            this.radius = radius;
        }

        public MobEffect getEffect() {
            return (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(this.effect);
        }

        public int getAddedAmplifier() {
            return this.addedAmplifier;
        }

        public float getRadius() {
            return this.radius;
        }
    }
}

