/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.trinket.effects;

import com.google.gson.annotations.Expose;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.world.data.entity.EntityPredicate;
import iskallia.vault.entity.Targeting;
import iskallia.vault.gear.trinket.TrinketEffect;
import iskallia.vault.gear.trinket.TrinketHelper;
import iskallia.vault.init.ModEffects;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ShadowCloakTrinket
extends TrinketEffect<Config> {
    private static final Map<UUID, Integer> cloakCooldowns;
    private final int disableLength;
    private final List<EntityPredicate> dontShadowMobs;

    public ShadowCloakTrinket(ResourceLocation name, int disableLength, List<EntityPredicate> dontShadowMobs) {
        super(name);
        this.disableLength = disableLength;
        this.dontShadowMobs = dontShadowMobs;
    }

    @Override
    public Class<Config> getConfigClass() {
        return Config.class;
    }

    @Override
    public Config getDefaultConfig() {
        return new Config(this.disableLength, this.dontShadowMobs);
    }

    @Override
    public void onWornTick(LivingEntity entity, ItemStack stack) {
        super.onWornTick(entity, stack);
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        UUID playerId = player.m_142081_();
        if (cloakCooldowns.containsKey(playerId)) {
            int remainingTicks;
            MobEffectInstance instance = player.m_21124_((MobEffect)ModEffects.SHADOW_CLOAK);
            if (instance != null) {
                player.m_21195_(instance.m_19544_());
            }
            if ((remainingTicks = cloakCooldowns.get(playerId).intValue()) > 0) {
                cloakCooldowns.put(playerId, remainingTicks - 1);
            } else {
                cloakCooldowns.remove(playerId);
            }
        } else {
            MobEffectInstance instance = player.m_21124_((MobEffect)ModEffects.SHADOW_CLOAK);
            if (instance == null) {
                MobEffectInstance newEffect = new MobEffectInstance((MobEffect)ModEffects.SHADOW_CLOAK, Integer.MAX_VALUE, 0, false, false, true);
                player.m_7292_(newEffect);
            }
        }
    }

    @Override
    public void onEquip(LivingEntity entity, ItemStack stack) {
        super.onEquip(entity, stack);
        MobEffectInstance instance = new MobEffectInstance((MobEffect)ModEffects.SHADOW_CLOAK, Integer.MAX_VALUE, 0, false, false, true);
        entity.m_7292_(instance);
        CommonEvents.ABILITY_CAST.register(entity, data -> {
            Entity patt3832$temp = data.getEntity();
            if (patt3832$temp instanceof Player) {
                Player player = (Player)patt3832$temp;
                ShadowCloakTrinket.breakInvisibility(player);
            }
        });
    }

    @Override
    public void onUnEquip(LivingEntity entity, ItemStack stack) {
        Player player;
        MobEffectInstance instance;
        super.onUnEquip(entity, stack);
        if (entity instanceof Player && (instance = (player = (Player)entity).m_21124_((MobEffect)ModEffects.SHADOW_CLOAK)) != null) {
            player.m_21195_(instance.m_19544_());
        }
    }

    public static boolean isInvisible(Player player) {
        if (player == null) {
            return false;
        }
        return TrinketHelper.getTrinkets((LivingEntity)player, ShadowCloakTrinket.class).stream().anyMatch(trinket -> trinket.isUsable(player) && !cloakCooldowns.containsKey(player.m_142081_()));
    }

    private static void breakInvisibility(Player player) {
        if (player == null) {
            return;
        }
        UUID playerId = player.m_142081_();
        TrinketHelper.getTrinkets((LivingEntity)player, ShadowCloakTrinket.class).stream().filter(trinket -> trinket.isUsable(player)).findFirst().ifPresent(trinket -> {
            int disableLength = ((Config)((ShadowCloakTrinket)((Object)((Object)trinket.trinket()))).getConfig()).getDisableLength();
            cloakCooldowns.put(playerId, disableLength);
            MobEffectInstance instance = player.m_21124_((MobEffect)ModEffects.SHADOW_CLOAK);
            if (instance != null) {
                player.m_21195_(instance.m_19544_());
            }
        });
    }

    public static boolean isInvisible(@Nullable LivingEntity entity, @Nullable DamageSource source) {
        ServerPlayer player;
        if (entity instanceof ServerPlayer && !cloakCooldowns.containsKey((player = (ServerPlayer)entity).m_142081_()) && TrinketHelper.getTrinkets((LivingEntity)player, ShadowCloakTrinket.class).stream().anyMatch(trinket -> trinket.isUsable((Player)player))) {
            return source == null || !source.m_19378_();
        }
        return false;
    }

    public static boolean shouldTarget(@Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        ServerPlayer player;
        if (attacker == null || target == null) {
            return true;
        }
        if (target instanceof ServerPlayer && !cloakCooldowns.containsKey((player = (ServerPlayer)target).m_142081_()) && TrinketHelper.getTrinkets((LivingEntity)player, ShadowCloakTrinket.class).stream().anyMatch(trinket -> trinket.isUsable((Player)player))) {
            return TrinketHelper.getTrinkets((LivingEntity)player, ShadowCloakTrinket.class).stream().noneMatch(trinket -> ((Config)((ShadowCloakTrinket)((Object)((Object)trinket.trinket()))).getConfig()).getDontShadowMobs().stream().anyMatch(predicate -> predicate.test((Entity)attacker)));
        }
        return true;
    }

    @SubscribeEvent
    public static void onBlockInteract(PlayerInteractEvent.RightClickBlock event) {
        ShadowCloakTrinket.breakInvisibility(event.getPlayer());
    }

    @SubscribeEvent
    public static void onBlockInteract(PlayerInteractEvent.LeftClickBlock event) {
        ShadowCloakTrinket.breakInvisibility(event.getPlayer());
    }

    @SubscribeEvent
    public static void onHurtEvent(LivingHurtEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Player) {
            player = (Player)livingEntity;
            ShadowCloakTrinket.breakInvisibility(player);
        }
        if ((livingEntity = event.getSource().m_7639_()) instanceof Player) {
            player = (Player)livingEntity;
            ShadowCloakTrinket.breakInvisibility(player);
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        ShadowCloakTrinket.breakInvisibility(event.getPlayer());
    }

    static {
        Targeting.addIgnoredTargetOverride((attacker, target) -> {
            LivingEntity livingEntity;
            return target instanceof LivingEntity && ShadowCloakTrinket.isInvisible(livingEntity = (LivingEntity)target, null) && ShadowCloakTrinket.shouldTarget(attacker, livingEntity);
        });
        cloakCooldowns = new HashMap<UUID, Integer>();
    }

    public static final class Config
    extends TrinketEffect.Config {
        @Expose
        private int disableLength;
        @Expose
        private List<EntityPredicate> dontShadowMobs;

        public Config(int disableLength, List<EntityPredicate> dontShadowMobs) {
            this.disableLength = disableLength;
            this.dontShadowMobs = dontShadowMobs;
        }

        public int getDisableLength() {
            return this.disableLength;
        }

        public List<EntityPredicate> getDontShadowMobs() {
            return this.dontShadowMobs;
        }
    }
}

