/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.init;

import iskallia.vault.skill.ability.component.AbilityLabelBindingRegistry;
import iskallia.vault.skill.ability.component.AbilityLabelFormatters;
import iskallia.vault.skill.ability.component.IAbilityLabelBinding;
import iskallia.vault.skill.ability.effect.ArcaneAbility;
import iskallia.vault.skill.ability.effect.ArcaneRailAbility;
import iskallia.vault.skill.ability.effect.BonkAbility;
import iskallia.vault.skill.ability.effect.BonkLuckyStrikeAbility;
import iskallia.vault.skill.ability.effect.BonkSpectralStrikeAbility;
import iskallia.vault.skill.ability.effect.BouncingFireballAbility;
import iskallia.vault.skill.ability.effect.ChainLightningAbility;
import iskallia.vault.skill.ability.effect.DashAbility;
import iskallia.vault.skill.ability.effect.DashDamageAbility;
import iskallia.vault.skill.ability.effect.DashWarpAbility;
import iskallia.vault.skill.ability.effect.EarthquakeAbility;
import iskallia.vault.skill.ability.effect.EarthquakeLandmineAbility;
import iskallia.vault.skill.ability.effect.EmpowerAbility;
import iskallia.vault.skill.ability.effect.EmpowerIceArmourAbility;
import iskallia.vault.skill.ability.effect.EmpowerSlownessAuraAbility;
import iskallia.vault.skill.ability.effect.FarmerAbility;
import iskallia.vault.skill.ability.effect.FarmerAnimalAbility;
import iskallia.vault.skill.ability.effect.FarmerCactusAbility;
import iskallia.vault.skill.ability.effect.FarmerMelonAbility;
import iskallia.vault.skill.ability.effect.FireballAbility;
import iskallia.vault.skill.ability.effect.FireballFireshotAbility;
import iskallia.vault.skill.ability.effect.GhostWalkAbility;
import iskallia.vault.skill.ability.effect.GhostWalkSpiritAbility;
import iskallia.vault.skill.ability.effect.GrenadeAbility;
import iskallia.vault.skill.ability.effect.HealAbility;
import iskallia.vault.skill.ability.effect.HealEffectAbility;
import iskallia.vault.skill.ability.effect.HealGroupAbility;
import iskallia.vault.skill.ability.effect.IceBoltArrowAbility;
import iskallia.vault.skill.ability.effect.IceBoltChunkAbility;
import iskallia.vault.skill.ability.effect.ImplodeAbility;
import iskallia.vault.skill.ability.effect.JavelinAbility;
import iskallia.vault.skill.ability.effect.JavelinPiercingAbility;
import iskallia.vault.skill.ability.effect.JavelinScatterAbility;
import iskallia.vault.skill.ability.effect.JavelinSightAbility;
import iskallia.vault.skill.ability.effect.LifeTapAbility;
import iskallia.vault.skill.ability.effect.LightningOrbsAbility;
import iskallia.vault.skill.ability.effect.ManaBarrierAbility;
import iskallia.vault.skill.ability.effect.ManaShieldAbility;
import iskallia.vault.skill.ability.effect.MegaJumpAbility;
import iskallia.vault.skill.ability.effect.MegaJumpBreakDownAbility;
import iskallia.vault.skill.ability.effect.MegaJumpBreakUpAbility;
import iskallia.vault.skill.ability.effect.NovaAbility;
import iskallia.vault.skill.ability.effect.NovaDotAbility;
import iskallia.vault.skill.ability.effect.NovaSpeedAbility;
import iskallia.vault.skill.ability.effect.RampageAbility;
import iskallia.vault.skill.ability.effect.RampageChainAbility;
import iskallia.vault.skill.ability.effect.RampageLeechAbility;
import iskallia.vault.skill.ability.effect.ShellAbility;
import iskallia.vault.skill.ability.effect.ShellPorcupineAbility;
import iskallia.vault.skill.ability.effect.ShellQuillAbility;
import iskallia.vault.skill.ability.effect.ShieldBashAbility;
import iskallia.vault.skill.ability.effect.ShieldBashRetributionAbility;
import iskallia.vault.skill.ability.effect.SmiteAbility;
import iskallia.vault.skill.ability.effect.SmiteArchonAbility;
import iskallia.vault.skill.ability.effect.SmiteThunderstormAbility;
import iskallia.vault.skill.ability.effect.StonefallAbility;
import iskallia.vault.skill.ability.effect.StonefallColdAbility;
import iskallia.vault.skill.ability.effect.StonefallSnowAbility;
import iskallia.vault.skill.ability.effect.StormArrowAbility;
import iskallia.vault.skill.ability.effect.StormArrowBlizzardAbility;
import iskallia.vault.skill.ability.effect.SummonEternalAbility;
import iskallia.vault.skill.ability.effect.TauntAbility;
import iskallia.vault.skill.ability.effect.TauntCharmAbility;
import iskallia.vault.skill.ability.effect.TauntRepelAbility;
import iskallia.vault.skill.ability.effect.TotemAbility;
import iskallia.vault.skill.ability.effect.TotemManaRegenAbility;
import iskallia.vault.skill.ability.effect.TotemMobDamageAbility;
import iskallia.vault.skill.ability.effect.TotemPlayerDamageAbility;
import iskallia.vault.skill.ability.effect.ToxicGrenadeAbility;
import iskallia.vault.skill.ability.effect.VeinMinerAbility;
import iskallia.vault.skill.ability.effect.VeinMinerDurabilityAbility;
import iskallia.vault.skill.ability.effect.VeinMinerFortuneAbility;
import iskallia.vault.skill.ability.effect.VeinMinerVoidAbility;
import iskallia.vault.skill.ability.effect.spi.HunterAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.ability.effect.spi.core.IInstantManaAbility;
import iskallia.vault.skill.ability.effect.spi.core.IPerSecondManaAbility;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.Skill;
import java.util.Collections;
import java.util.Map;

public class ModAbilityLabelBindings {
    public static void register() {
        AbilityLabelBindingRegistry.clear();
        ModAbilityLabelBindings.register(DashAbility.class, Map.of("distance", ability -> AbilityLabelFormatters.integer(ability.getExtraDistance())));
        ModAbilityLabelBindings.register(DashDamageAbility.class, Map.of("distance", ability -> AbilityLabelFormatters.integer(ability.getExtraDistance()), "damage", ability -> AbilityLabelFormatters.percentRounded(ability.getAttackDamagePercentPerDash())));
        ModAbilityLabelBindings.register(DashWarpAbility.class, Map.of("force", ability -> AbilityLabelFormatters.decimal(ability.getProjectileLaunchForce())));
        ModAbilityLabelBindings.register(FarmerAbility.class, Map.of("delay", ability -> AbilityLabelFormatters.ticks(ability.getTickDelay()), "rangeHorizontal", ability -> AbilityLabelFormatters.integer(ability.getHorizontalRange()), "rangeVertical", ability -> AbilityLabelFormatters.integer(ability.getVerticalRange())));
        ModAbilityLabelBindings.register(FarmerCactusAbility.class, Map.of("delay", ability -> AbilityLabelFormatters.ticks(ability.getTickDelay()), "rangeHorizontal", ability -> AbilityLabelFormatters.integer(ability.getHorizontalRange()), "rangeVertical", ability -> AbilityLabelFormatters.integer(ability.getVerticalRange())));
        ModAbilityLabelBindings.register(FarmerMelonAbility.class, Map.of("delay", ability -> AbilityLabelFormatters.ticks(ability.getTickDelay()), "rangeHorizontal", ability -> AbilityLabelFormatters.integer(ability.getHorizontalRange()), "rangeVertical", ability -> AbilityLabelFormatters.integer(ability.getVerticalRange())));
        ModAbilityLabelBindings.register(FarmerAnimalAbility.class, Map.of("delay", ability -> AbilityLabelFormatters.ticks(ability.getTickDelay()), "rangeHorizontal", ability -> AbilityLabelFormatters.integer(ability.getHorizontalRange()), "rangeVertical", ability -> AbilityLabelFormatters.integer(ability.getVerticalRange()), "chance", ability -> AbilityLabelFormatters.percentRounded(ability.getAdultChance())));
        ModAbilityLabelBindings.register(GhostWalkAbility.class, Map.of("adjustedDuration", ability -> AbilityLabelFormatters.ticks(ability.getUnmodifiedDurationTicks())));
        ModAbilityLabelBindings.register(GhostWalkSpiritAbility.class, Map.of("adjustedDuration", ability -> AbilityLabelFormatters.ticks(ability.getUnmodifiedDurationTicks())));
        ModAbilityLabelBindings.register(HealAbility.class, Map.of("heal", ability -> AbilityLabelFormatters.decimal(ability.getFlatLifeHealed())));
        ModAbilityLabelBindings.register(HealEffectAbility.class);
        ModAbilityLabelBindings.register(HealGroupAbility.class, Map.of("heal", ability -> AbilityLabelFormatters.decimal(ability.getFlatLifeHealed()), "adjustedRadius", ability -> AbilityLabelFormatters.decimal(ability.getUnmodifiedRadius())));
        ModAbilityLabelBindings.register(HunterAbility.class, Map.of("adjustedRadius", ability -> AbilityLabelFormatters.decimal(ability.getUnmodifiedSearchRadius()), "adjustedDuration", ability -> AbilityLabelFormatters.ticks(ability.getUnmodifiedDurationTicks())));
        ModAbilityLabelBindings.register(ManaShieldAbility.class, Map.of("duration", ability -> AbilityLabelFormatters.percentRounded(ability.getDurationTicks()), "barrierPoints", ability -> AbilityLabelFormatters.decimal(ability.getHealthPoints())));
        ModAbilityLabelBindings.register(ShieldBashAbility.class, Map.of("adjustedRadius", ability -> AbilityLabelFormatters.decimal(ability.getUnmodifiedDamageRadius()), "thornsDamage", ability -> AbilityLabelFormatters.percentTwoDecimalPlaces(ability.getPercentageThornsDamageDealt())));
        ModAbilityLabelBindings.register(ImplodeAbility.class, Map.of("adjustedRadius", ability -> AbilityLabelFormatters.decimal(ability.getUnmodifiedRadius()), "manaDamage", ability -> AbilityLabelFormatters.percentRounded(ability.getPercentManaDealt())));
        ModAbilityLabelBindings.register(ManaBarrierAbility.class, Map.of("adjustedRadius", ability -> AbilityLabelFormatters.integer(ability.getUnmodifiedRadius()), "duration", ability -> AbilityLabelFormatters.ticks(ability.getDurationTicks())));
        ModAbilityLabelBindings.register(MegaJumpAbility.class, Map.of("rangeVertical", ability -> AbilityLabelFormatters.integer(ability.getUnmodifiedHeight())));
        ModAbilityLabelBindings.register(MegaJumpBreakUpAbility.class, Map.of("rangeVertical", ability -> AbilityLabelFormatters.integer(ability.getUnmodifiedHeight())));
        ModAbilityLabelBindings.register(MegaJumpBreakDownAbility.class, Map.of("rangeVertical", ability -> AbilityLabelFormatters.integer(ability.getUnmodifiedHeight()), "radius", ability -> AbilityLabelFormatters.integer(ability.getRadius())));
        ModAbilityLabelBindings.register(NovaAbility.class, Map.of("adjustedRadius", ability -> AbilityLabelFormatters.decimal(ability.getUnmodifiedRadius()), "ability_power", ability -> AbilityLabelFormatters.percentRounded(ability.getPercentAbilityPowerDealt()), "knockback", ability -> AbilityLabelFormatters.percentRounded(ability.getKnockbackStrengthMultiplier())));
        ModAbilityLabelBindings.register(NovaDotAbility.class, Map.of("adjustedRadius", ability -> AbilityLabelFormatters.decimal(ability.getUnmodifiedRadius()), "ability_power", ability -> AbilityLabelFormatters.percentRounded(ability.getPercentAbilityPowerDealt()), "adjustedDuration", ability -> AbilityLabelFormatters.seconds(ability.getDurationSecondsUnmodified())));
        ModAbilityLabelBindings.register(NovaSpeedAbility.class, Map.of("adjustedRadius", ability -> AbilityLabelFormatters.decimal(ability.getUnmodifiedRadius()), "adjustedDuration", ability -> AbilityLabelFormatters.ticks(ability.getDurationTicksUnmodified()), "slowness", ability -> AbilityLabelFormatters.integer(ability.getAmplifier())));
        ModAbilityLabelBindings.register(RampageAbility.class, Map.of("damage", ability -> AbilityLabelFormatters.percentRounded(ability.getUnmodifiedDamageIncrease())));
        ModAbilityLabelBindings.register(RampageChainAbility.class, Map.of("chains", ability -> AbilityLabelFormatters.integer(ability.getAdditionalChainCount())));
        ModAbilityLabelBindings.register(RampageLeechAbility.class, Map.of("leech", ability -> AbilityLabelFormatters.percentTwoDecimalPlaces(ability.getLeechPercent())));
        ModAbilityLabelBindings.register(StonefallAbility.class, Map.of("adjustedDuration", ability -> AbilityLabelFormatters.ticks(ability.getDurationTicksUnmodified()), "knockback", ability -> AbilityLabelFormatters.decimal(ability.getKnockbackMultiplier()), "adjustedRadius", ability -> AbilityLabelFormatters.decimal(ability.getUnmodifiedRadius()), "damageReduction", ability -> AbilityLabelFormatters.percentTwoDecimalPlaces(ability.getDamageReduction())));
        ModAbilityLabelBindings.register(StonefallSnowAbility.class, Map.of("adjustedDuration", ability -> AbilityLabelFormatters.ticks(ability.getDurationTicksUnmodified()), "adjustedRadius", ability -> AbilityLabelFormatters.decimal(ability.getUnmodifiedRadius()), "damageReduction", ability -> AbilityLabelFormatters.percentTwoDecimalPlaces(ability.getDamageReduction()), "ability_power", ability -> AbilityLabelFormatters.percentTwoDecimalPlaces(ability.getDamageMultiplier())));
        ModAbilityLabelBindings.register(StonefallColdAbility.class, Map.of("adjustedDuration", ability -> AbilityLabelFormatters.ticks(ability.getDurationTicksUnmodified()), "adjustedRadius", ability -> AbilityLabelFormatters.decimal(ability.getUnmodifiedRadius()), "damageReduction", ability -> AbilityLabelFormatters.percentTwoDecimalPlaces(ability.getDamageReduction()), "freezeDuration", ability -> AbilityLabelFormatters.ticks(ability.getFreezeTicks()), "amplifier", ability -> AbilityLabelFormatters.integer(ability.getAmplifier()), "maxGlacialPrison", ability -> AbilityLabelFormatters.integer(ability.getMaxGlacialPrison())));
        ModAbilityLabelBindings.register(SummonEternalAbility.class, Map.of("eternals", ability -> AbilityLabelFormatters.integer(ability.getNumberOfEternals()), "duration", ability -> AbilityLabelFormatters.ticks(ability.getDespawnTime()), "chance", ability -> AbilityLabelFormatters.percentRounded(ability.getAncientChance())));
        ModAbilityLabelBindings.register(EmpowerAbility.class, Map.of("adjustedDuration", ability -> AbilityLabelFormatters.ticks(ability.getDurationTicks()), "adjustedRadius", ability -> AbilityLabelFormatters.decimal(ability.getUnmodifiedBuffRadius()), "speed", ability -> AbilityLabelFormatters.percentRounded(ability.getSpeedPercentAdded())));
        ModAbilityLabelBindings.register(EmpowerIceArmourAbility.class, Map.of("chilled", ability -> AbilityLabelFormatters.integer(ability.getChilledAmplifier()), "adjustedDuration", ability -> AbilityLabelFormatters.ticks(ability.getChilledDurationUnmodified()), "additionalManaPerHit", ability -> AbilityLabelFormatters.decimal(ability.getAdditionalManaPerHit())));
        ModAbilityLabelBindings.register(EmpowerSlownessAuraAbility.class, Map.of("slowness", ability -> AbilityLabelFormatters.integer(ability.getSlownessAmplifier()), "adjustedRadius", ability -> AbilityLabelFormatters.decimal(ability.getUnmodifiedRadius())));
        ModAbilityLabelBindings.register(TauntAbility.class, Map.of("adjustedRadius", ability -> AbilityLabelFormatters.decimal(ability.getUnmodifiedRadius()), "adjustedDuration", ability -> AbilityLabelFormatters.ticks(ability.getUnmodifiedDurationTicks()), "vulnerable", ability -> AbilityLabelFormatters.integer(ability.getAmplifier())));
        ModAbilityLabelBindings.register(TauntRepelAbility.class, Map.of("adjustedRadius", ability -> AbilityLabelFormatters.decimal(ability.getUnmodifiedRadius()), "adjustedDuration", ability -> AbilityLabelFormatters.ticks(ability.getUnmodifiedDurationTicks()), "distance", ability -> AbilityLabelFormatters.decimal(ability.getRepelForce())));
        ModAbilityLabelBindings.register(TauntCharmAbility.class, Map.of("adjustedRadius", ability -> AbilityLabelFormatters.decimal(ability.getUnmodifiedRadius()), "adjustedDuration", ability -> AbilityLabelFormatters.ticks(ability.getUnmodifiedDurationTicks()), "maxTargets", ability -> AbilityLabelFormatters.integer(ability.getMaxCharmedMobs()), "damage", ability -> AbilityLabelFormatters.percentTwoDecimalPlaces(ability.getPercentPlayerDamage()), "speed", ability -> AbilityLabelFormatters.percentTwoDecimalPlaces(ability.getSpeedMultiplier())));
        ModAbilityLabelBindings.register(VeinMinerAbility.class, Map.of("blocks", ability -> AbilityLabelFormatters.decimal(ability.getUnmodifiedBlockLimit())));
        ModAbilityLabelBindings.register(VeinMinerDurabilityAbility.class, Map.of("blocks", ability -> AbilityLabelFormatters.decimal(ability.getUnmodifiedBlockLimit()), "unbreaking", ability -> AbilityLabelFormatters.integer(ability.getAdditionalUnbreakingLevel())));
        ModAbilityLabelBindings.register(VeinMinerFortuneAbility.class, Map.of("blocks", ability -> AbilityLabelFormatters.decimal(ability.getUnmodifiedBlockLimit()), "fortune", ability -> AbilityLabelFormatters.integer(ability.getAdditionalFortuneLevel())));
        ModAbilityLabelBindings.register(VeinMinerVoidAbility.class, Map.of("blocks", ability -> AbilityLabelFormatters.decimal(ability.getUnmodifiedBlockLimit())));
        ModAbilityLabelBindings.register(TotemAbility.class, Map.of("adjustedDuration", ability -> AbilityLabelFormatters.ticks(ability.getUnmodifiedTotemDurationTicks()), "adjustedRadius", ability -> AbilityLabelFormatters.decimal(ability.getUnmodifiedTotemEffectRadius()), "heal", ability -> AbilityLabelFormatters.decimal(ability.getTotemHealthPerSecond())));
        ModAbilityLabelBindings.register(TotemMobDamageAbility.class, Map.of("adjustedDuration", ability -> AbilityLabelFormatters.ticks(ability.getUnmodifiedTotemDurationTicks()), "adjustedRadius", ability -> AbilityLabelFormatters.decimal(ability.getUnmodifiedTotemEffectRadius()), "ability_power", ability -> AbilityLabelFormatters.percentTwoDecimalPlaces(ability.getTotemPercentDamagePerInterval()), "delay", ability -> AbilityLabelFormatters.ticks(ability.getTotemDamageIntervalTicks())));
        ModAbilityLabelBindings.register(TotemManaRegenAbility.class, Map.of("adjustedDuration", ability -> AbilityLabelFormatters.ticks(ability.getUnmodifiedTotemDurationTicks()), "adjustedRadius", ability -> AbilityLabelFormatters.decimal(ability.getUnmodifiedTotemEffectRadius()), "manaRegen", ability -> AbilityLabelFormatters.percentTwoDecimalPlaces(ability.getTotemManaRegenPercent())));
        ModAbilityLabelBindings.register(TotemPlayerDamageAbility.class, Map.of("adjustedDuration", ability -> AbilityLabelFormatters.ticks(ability.getUnmodifiedTotemDurationTicks()), "adjustedRadius", ability -> AbilityLabelFormatters.decimal(ability.getUnmodifiedTotemEffectRadius()), "damage", ability -> AbilityLabelFormatters.percentTwoDecimalPlaces(ability.getTotemPlayerDamagePercent())));
        ModAbilityLabelBindings.register(JavelinAbility.class, Map.of("damage", config -> AbilityLabelFormatters.percentTwoDecimalPlaces(config.getPercentAttackDamageDealt()), "knockback", config -> AbilityLabelFormatters.decimal(config.getKnockback()), "throwPower", config -> AbilityLabelFormatters.decimal(config.getThrowPower())));
        ModAbilityLabelBindings.register(JavelinPiercingAbility.class, Map.of("damage", config -> AbilityLabelFormatters.percentTwoDecimalPlaces(config.getPercentAttackDamageDealt()), "piercing", config -> AbilityLabelFormatters.integer(config.getPiercing()), "throwPower", config -> AbilityLabelFormatters.decimal(config.getThrowPower())));
        ModAbilityLabelBindings.register(JavelinScatterAbility.class, Map.of("damage", config -> AbilityLabelFormatters.percentTwoDecimalPlaces(config.getPercentAttackDamageDealt()), "numberOfJavelins", config -> AbilityLabelFormatters.integer(config.getNumberOfJavelins()), "numberOfBounces", config -> AbilityLabelFormatters.integer(config.getNumberOfBounces()), "throwPower", config -> AbilityLabelFormatters.decimal(config.getThrowPower())));
        ModAbilityLabelBindings.register(JavelinSightAbility.class, Map.of("damage", config -> AbilityLabelFormatters.percentTwoDecimalPlaces(config.getPercentAttackDamageDealt()), "adjustedRadius", config -> AbilityLabelFormatters.decimal(config.getUnmodifiedRadius()), "adjustedDuration", config -> AbilityLabelFormatters.integer(config.getEffectDurationUnmodified()), "throwPower", config -> AbilityLabelFormatters.decimal(config.getThrowPower())));
        ModAbilityLabelBindings.register(SmiteAbility.class, Map.of("adjustedRadius", ability -> AbilityLabelFormatters.decimal(ability.getUnmodifiedRadius()), "damageInterval", ability -> AbilityLabelFormatters.ticks(ability.getIntervalTicks()), "ability_power_min", ability -> AbilityLabelFormatters.percentTwoDecimalPlaces(ability.getAbilityPowerPercentMin()), "ability_power_max", ability -> AbilityLabelFormatters.percentTwoDecimalPlaces(ability.getAbilityPowerPercentMax()), "additionalManaPerBolt", ability -> AbilityLabelFormatters.decimal(ability.getAdditionalManaPerBolt())));
        ModAbilityLabelBindings.register(SmiteArchonAbility.class, Map.of("adjustedRadius", ability -> AbilityLabelFormatters.decimal(ability.getUnmodifiedRadius()), "damageInterval", ability -> AbilityLabelFormatters.ticks(ability.getIntervalTicks()), "ability_power_min", ability -> AbilityLabelFormatters.percentTwoDecimalPlaces(ability.getAbilityPowerPercentMin()), "ability_power_max", ability -> AbilityLabelFormatters.percentTwoDecimalPlaces(ability.getAbilityPowerPercentMax()), "additionalManaPerBolt", ability -> AbilityLabelFormatters.decimal(ability.getAdditionalManaPerBolt()), "durabilityWearReduction", ability -> AbilityLabelFormatters.percentRounded(ability.getAdditionalDurabilityWearReduction())));
        ModAbilityLabelBindings.register(SmiteThunderstormAbility.class, Map.of("adjustedRadius", ability -> AbilityLabelFormatters.decimal(ability.getUnmodifiedRadius()), "damageInterval", ability -> AbilityLabelFormatters.ticks(ability.getIntervalTicks()), "ability_power_min", ability -> AbilityLabelFormatters.percentTwoDecimalPlaces(ability.getAbilityPowerPercentMin()), "ability_power_max", ability -> AbilityLabelFormatters.percentTwoDecimalPlaces(ability.getAbilityPowerPercentMax()), "additionalManaPerBolt", ability -> AbilityLabelFormatters.decimal(ability.getAdditionalManaPerBolt())));
        ModAbilityLabelBindings.register(ShellAbility.class, Map.of("stunChance", ability -> AbilityLabelFormatters.percentRounded(ability.getStunChance()), "stunDuration", ability -> AbilityLabelFormatters.seconds(ability.getStunDurationSeconds()), "stunAmplifier", ability -> AbilityLabelFormatters.integer(ability.getStunAmplifier()), "additionalManaPerHit", ability -> AbilityLabelFormatters.decimal(ability.getAdditionalManaPerHit())));
        ModAbilityLabelBindings.register(ShellPorcupineAbility.class, Map.of("durabilityWearReduction", ability -> AbilityLabelFormatters.percentRounded(ability.getAdditionalDurabilityWearReduction()), "additional_thorns_damage", ability -> AbilityLabelFormatters.percentRounded(ability.getAdditionalThornsDamagePercent()), "additionalManaPerHit", ability -> AbilityLabelFormatters.decimal(ability.getAdditionalManaPerHit())));
        ModAbilityLabelBindings.register(ShellQuillAbility.class, Map.of("durabilityWearReduction", ability -> AbilityLabelFormatters.percentRounded(ability.getAdditionalDurabilityWearReduction()), "additional_thorns_damage", ability -> AbilityLabelFormatters.percentRounded(ability.getAdditionalThornsDamagePercent()), "additionalManaPerHit", ability -> AbilityLabelFormatters.decimal(ability.getAdditionalManaPerHit()), "quillCount", ability -> AbilityLabelFormatters.integer(ability.getQuillCount())));
        ModAbilityLabelBindings.register(FireballAbility.class, Map.of("ability_power", ability -> AbilityLabelFormatters.percentRounded(ability.getPercentAbilityPowerDealt()), "adjustedRadius", ability -> AbilityLabelFormatters.decimal(ability.getRadius())));
        ModAbilityLabelBindings.register(BouncingFireballAbility.class, Map.of("ability_power", ability -> AbilityLabelFormatters.percentRounded(ability.getPercentAbilityPowerDealt()), "adjustedRadius", ability -> AbilityLabelFormatters.decimal(ability.getRadius()), "duration", ability -> AbilityLabelFormatters.seconds(ability.getDuration())));
        ModAbilityLabelBindings.register(FireballFireshotAbility.class, Map.of("ability_power", ability -> AbilityLabelFormatters.percentRounded(ability.getPercentAbilityPowerDealt())));
        ModAbilityLabelBindings.register(ArcaneAbility.class, Map.of("ability_power", ability -> AbilityLabelFormatters.percentRounded(ability.getPercentAbilityPowerDealt()), "distance", ability -> AbilityLabelFormatters.decimal(ability.getRange())));
        ModAbilityLabelBindings.register(ArcaneRailAbility.class, Map.of("ability_power_min", ability -> AbilityLabelFormatters.percentTwoDecimalPlaces(ability.getPercentAbilityPowerDealtMin()), "ability_power_max", ability -> AbilityLabelFormatters.percentTwoDecimalPlaces(ability.getPercentAbilityPowerDealtMax())));
        ModAbilityLabelBindings.register(StormArrowAbility.class, Map.of("ability_power_min", ability -> AbilityLabelFormatters.percentTwoDecimalPlaces(ability.getAbilityPowerPercentMin()), "ability_power_max", ability -> AbilityLabelFormatters.percentTwoDecimalPlaces(ability.getAbilityPowerPercentMax()), "adjustedRadius", ability -> AbilityLabelFormatters.decimal(ability.getUnmodifiedRadius()), "adjustedDuration", ability -> AbilityLabelFormatters.ticks(ability.getUnmodifiedDuration()), "stormInterval", ability -> AbilityLabelFormatters.ticks(ability.getIntervalTicks())));
        ModAbilityLabelBindings.register(StormArrowBlizzardAbility.class, Map.of("ability_power_min", ability -> AbilityLabelFormatters.percentTwoDecimalPlaces(ability.getAbilityPowerPercentMin()), "ability_power_max", ability -> AbilityLabelFormatters.percentTwoDecimalPlaces(ability.getAbilityPowerPercentMax()), "adjustedRadius", ability -> AbilityLabelFormatters.decimal(ability.getUnmodifiedRadius()), "adjustedDuration", ability -> AbilityLabelFormatters.ticks(ability.getUnmodifiedDuration()), "stormInterval", ability -> AbilityLabelFormatters.ticks(ability.getIntervalTicks()), "frostbiteChance", ability -> AbilityLabelFormatters.percentRounded(ability.getFrostbiteChance()), "slowDuration", ability -> AbilityLabelFormatters.ticks(ability.getUnmodifiedSlowDuration()), "frostbiteDuration", ability -> AbilityLabelFormatters.ticks(ability.getUnmodifiedFrostbiteDuration()), "amplifier", ability -> AbilityLabelFormatters.integer(ability.getAmplifier())));
        ModAbilityLabelBindings.register(BonkAbility.class, Map.of("attackDamagePerStack", ability -> AbilityLabelFormatters.percentRounded(ability.getAttackDamagePerStack()), "adjustedRadius", ability -> AbilityLabelFormatters.decimal(ability.getUnmodifiedRadius()), "adjustedDuration", ability -> AbilityLabelFormatters.ticks(ability.getUnmodifiedStackDuration()), "stacksUsedPerHit", ability -> AbilityLabelFormatters.integer(ability.getMaxStacksUsedPerHit()), "maxStacks", ability -> AbilityLabelFormatters.integer(ability.getMaxStacksTotal())));
        ModAbilityLabelBindings.register(BonkSpectralStrikeAbility.class, Map.of("abilityPowerPerStack", ability -> AbilityLabelFormatters.percentRounded(ability.getAbilityPowerPerStack()), "adjustedRadius", ability -> AbilityLabelFormatters.decimal(ability.getUnmodifiedRadius()), "adjustedDuration", ability -> AbilityLabelFormatters.ticks(ability.getUnmodifiedStackDuration()), "stacksUsedPerHit", ability -> AbilityLabelFormatters.integer(ability.getMaxStacksUsedPerHit()), "maxStacks", ability -> AbilityLabelFormatters.integer(ability.getMaxStacksTotal())));
        ModAbilityLabelBindings.register(BonkLuckyStrikeAbility.class, Map.of("luckyHitPerStack", ability -> AbilityLabelFormatters.percentRounded(ability.getLuckyHitChancePerStack()), "adjustedRadius", ability -> AbilityLabelFormatters.decimal(ability.getUnmodifiedRadius()), "adjustedDuration", ability -> AbilityLabelFormatters.ticks(ability.getUnmodifiedStackDuration()), "stacksUsedPerHit", ability -> AbilityLabelFormatters.integer(ability.getMaxStacksUsedPerHit()), "maxStacks", ability -> AbilityLabelFormatters.integer(ability.getMaxStacksTotal())));
        ModAbilityLabelBindings.register(IceBoltArrowAbility.class, Map.of("setDamage", ability -> AbilityLabelFormatters.decimal(ability.getDamagePerBolt()), "throwPower", ability -> AbilityLabelFormatters.decimal(ability.getThrowPower()), "adjustedDuration", ability -> AbilityLabelFormatters.ticks(ability.getDurationTicksUnmodified()), "amplifier", ability -> AbilityLabelFormatters.integer(ability.getAmplifier())));
        ModAbilityLabelBindings.register(IceBoltChunkAbility.class, Map.of("setDamage", ability -> AbilityLabelFormatters.decimal(ability.getDamagePerBolt()), "throwPower", ability -> AbilityLabelFormatters.decimal(ability.getThrowPower()), "adjustedRadius", ability -> AbilityLabelFormatters.decimal(ability.getUnmodifiedRadius()), "adjustedDuration", ability -> AbilityLabelFormatters.ticks(ability.getDurationTicksUnmodified()), "amplifier", ability -> AbilityLabelFormatters.integer(ability.getAmplifier()), "glacialChance", ability -> AbilityLabelFormatters.percentRounded(ability.getGlacialChance())));
        ModAbilityLabelBindings.register(ShieldBashRetributionAbility.class, Map.of("adjustedRadius", ability -> AbilityLabelFormatters.decimal(ability.getUnmodifiedDamageRadius()), "duration", ability -> AbilityLabelFormatters.percentTwoDecimalPlaces(ability.getChargeTime()), "thornsDamage", ability -> AbilityLabelFormatters.percentTwoDecimalPlaces(ability.getDamagePerStack())));
        ModAbilityLabelBindings.register(EarthquakeAbility.class, Map.of("adjustedRadius", ability -> AbilityLabelFormatters.decimal(ability.getUnmodifiedRadius()), "damage", ability -> AbilityLabelFormatters.percentRounded(ability.getPercentAttackDamageDealt()), "knockback", ability -> AbilityLabelFormatters.percentRounded(ability.getKnockbackStrengthMultiplier()), "delay", ability -> AbilityLabelFormatters.ticks(ability.getDelayTicks()), "blockDestruction", ability -> AbilityLabelFormatters.percentRounded(ability.getBlockDestructionChance()), "blockReplacement", ability -> AbilityLabelFormatters.percentRounded(ability.getBlockReplacementChance())));
        ModAbilityLabelBindings.register(LifeTapAbility.class, Map.of("adjustedRadius", ability -> AbilityLabelFormatters.decimal(ability.getUnmodifiedRadius()), "healthPercent", ability -> AbilityLabelFormatters.percentTwoDecimalPlaces(ability.getPercentHealthDrained()), "damagePerHealth", ability -> AbilityLabelFormatters.decimal(ability.getDamagePerHealth())));
        ModAbilityLabelBindings.register(ChainLightningAbility.class, Map.of("ability_power_min", ability -> AbilityLabelFormatters.percentTwoDecimalPlaces(ability.getPercentAbilityPowerDealtMin()), "ability_power_max", ability -> AbilityLabelFormatters.percentTwoDecimalPlaces(ability.getPercentAbilityPowerDealtMax()), "throwPower", ability -> AbilityLabelFormatters.decimal(ability.getThrowPower()), "distance", ability -> AbilityLabelFormatters.decimal(ability.getDistance()), "chainRange", ability -> AbilityLabelFormatters.decimal(ability.getChainRange())));
        ModAbilityLabelBindings.register(LightningOrbsAbility.class, Map.of("ability_power_min", ability -> AbilityLabelFormatters.percentTwoDecimalPlaces(ability.getPercentAbilityPowerDealtMin()), "ability_power_max", ability -> AbilityLabelFormatters.percentTwoDecimalPlaces(ability.getPercentAbilityPowerDealtMax()), "distance", ability -> AbilityLabelFormatters.decimal(ability.getDistance()), "adjustedDuration", ability -> AbilityLabelFormatters.ticks(ability.getUnmodifiedDurationTicks())));
        ModAbilityLabelBindings.register(EarthquakeLandmineAbility.class, Map.of("adjustedRadius", ability -> AbilityLabelFormatters.decimal(ability.getUnmodifiedRadius()), "damage", ability -> AbilityLabelFormatters.percentRounded(ability.getPercentAttackDamageDealt()), "knockback", ability -> AbilityLabelFormatters.percentRounded(ability.getKnockbackStrengthMultiplier()), "adjustedDuration", ability -> AbilityLabelFormatters.ticks(ability.getUnmodifiedDurationTicks()), "blockDestruction", ability -> AbilityLabelFormatters.percentRounded(ability.getBlockDestructionChance()), "blockReplacement", ability -> AbilityLabelFormatters.percentRounded(ability.getBlockReplacementChance())));
        ModAbilityLabelBindings.register(GrenadeAbility.class, Map.of("damage", ability -> AbilityLabelFormatters.percentRounded(ability.getPercentAttackDamageDealt()), "adjustedRadius", ability -> AbilityLabelFormatters.decimal(ability.getUnmodifiedRadius()), "duration", ability -> AbilityLabelFormatters.ticks(ability.getDuration()), "throwPower", ability -> AbilityLabelFormatters.decimal(ability.getThrowPower())));
        ModAbilityLabelBindings.register(ToxicGrenadeAbility.class, Map.of("ability_power", ability -> AbilityLabelFormatters.percentRounded(ability.getPercentAbilityPowerDealt()), "adjustedRadius", ability -> AbilityLabelFormatters.decimal(ability.getUnmodifiedRadius()), "adjustedDuration", ability -> AbilityLabelFormatters.ticks(ability.getPoisonTicksUnmodified()), "throwPower", ability -> AbilityLabelFormatters.decimal(ability.getThrowPower())));
    }

    public static <C extends Skill> void register(Class<C> ability) {
        ModAbilityLabelBindings.register(ability, Collections.emptyMap());
    }

    public static <C extends Skill> void register(Class<C> ability, Map<String, IAbilityLabelBinding<C>> bindings) {
        if (AbilityLabelBindingRegistry.containsKey(ability)) {
            throw new IllegalStateException("Ability label bindings already registered for ability class " + String.valueOf(ability));
        }
        if (LearnableSkill.class.isAssignableFrom(ability)) {
            AbilityLabelBindingRegistry.register(ability, "level", config -> String.valueOf(((LearnableSkill)config).getUnlockLevel()));
        }
        if (Ability.class.isAssignableFrom(ability)) {
            AbilityLabelBindingRegistry.register(ability, "cooldown", config -> (float)((Ability)config).getCooldownTicks() / 20.0f + "s");
        }
        if (IInstantManaAbility.class.isAssignableFrom(ability)) {
            AbilityLabelBindingRegistry.register(ability, "manaCost", config -> String.valueOf(Math.round(((IInstantManaAbility)((Object)config)).getManaCost())));
        } else if (IPerSecondManaAbility.class.isAssignableFrom(ability)) {
            AbilityLabelBindingRegistry.register(ability, "manaCost", config -> "%.1f".formatted(Float.valueOf(((IPerSecondManaAbility)((Object)config)).getManaCostPerSecond())));
        }
        for (Map.Entry<String, IAbilityLabelBinding<C>> entry : bindings.entrySet()) {
            AbilityLabelBindingRegistry.register(ability, entry.getKey(), entry.getValue());
        }
    }
}

