/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.init;

import iskallia.vault.VaultMod;
import iskallia.vault.antique.Antique;
import iskallia.vault.antique.condition.AntiqueCondition;
import iskallia.vault.antique.condition.AntiqueConditionAnd;
import iskallia.vault.antique.condition.AntiqueConditionChance;
import iskallia.vault.antique.condition.AntiqueConditionEntityGroup;
import iskallia.vault.antique.condition.AntiqueConditionKey;
import iskallia.vault.antique.condition.AntiqueConditionLevel;
import iskallia.vault.antique.condition.AntiqueConditionNegate;
import iskallia.vault.antique.condition.AntiqueConditionOr;
import iskallia.vault.antique.condition.AntiqueConditionPlayerHasItem;
import iskallia.vault.antique.condition.AntiqueConditionTag;
import iskallia.vault.antique.condition.AntiqueConditionType;
import iskallia.vault.antique.reward.AntiqueReward;
import iskallia.vault.antique.reward.AntiqueRewardCombined;
import iskallia.vault.antique.reward.AntiqueRewardItemList;
import iskallia.vault.antique.reward.AntiqueRewardSpecificGear;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModAntiques {
    static final List<Antique> ALL_ANTIQUES = new ArrayList<Antique>();
    public static final Antique SHIP_IN_A_BOTTLE = ModAntiques.register("ship_in_a_bottle", "Guybrush");
    public static final Antique SNOW_FOX = ModAntiques.register("snow_fox", "SilentFoxxy");
    public static final Antique THE_LOST_ONE = ModAntiques.register("the_lost_one", "The_Silver_Kid");
    public static final Antique SOUL_MIRROR = ModAntiques.register("soul_mirror", "Cosmovoli");
    public static final Antique ACQUIRED_TASTE = ModAntiques.register("acquired_taste", "AussieCrafter");
    public static final Antique NAZAR_BONCUGU = ModAntiques.register("nazar_boncugu", "mefallit");
    public static final Antique CREST_ORANGE_BRIGADE = ModAntiques.register("crest_orange_brigade", "IthKamakazi");
    public static final Antique HAGS_COOKING_POT = ModAntiques.register("hags_cooking_pot", "TJH54");
    public static final Antique GEM_KING = ModAntiques.register("gem_king", "King_Sauron");
    public static final Antique THE_UNICORN = ModAntiques.register("the_unicorn", "avian946");
    public static final Antique THE_LIFE_KEY = ModAntiques.register("the_life_key", "GreatLakesGirl");
    public static final Antique ARCANE_SABER = ModAntiques.register("arcane_saber", "ExodiaJedi");
    public static final Antique COMPRESSED_CUBE = ModAntiques.register("compressed_cube");
    public static final Antique THE_BLUE_JAY = ModAntiques.register("the_blue_jay", "Jaysp656");
    public static final Antique POCKET_PENGUIN = ModAntiques.register("pocket_penguin", "RMZing");
    public static final Antique BOUNTIFUL_HARVEST = ModAntiques.register("bountiful_harvest", "jyutta");
    public static final Antique PIRATES_LOCKPICK = ModAntiques.register("pirates_lockpick", "Nafin");
    public static final Antique LUCKY_CAT_MEDALLION = ModAntiques.register("lucky_cat_medallion", "MoonliteDelight");
    public static final Antique THE_SNOW_PAW = ModAntiques.register("the_snow_paw", "DannySnowPaw");
    public static final Antique LUCKY_BAMBOO = ModAntiques.register("lucky_bamboo");
    public static final Antique GLIMPSE_OF_THE_COSMOS = ModAntiques.register("glimpse_of_the_cosmos", "IzzyBizzy");
    public static final Antique FOUNTAIN_OF_KNOWLEDGE = ModAntiques.register("fountain_of_knowledge", "MuttPacket");
    public static final Antique INTERTWINED = ModAntiques.register("intertwined", "MissAndrea");
    public static final Antique THE_AMBASSADOR = ModAntiques.register("ambassador", "HoY_82");

    public static void registerAntiques(RegistryEvent.Register<Antique> event) {
        IForgeRegistry registry = event.getRegistry();
        ALL_ANTIQUES.forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
    }

    public static Antique register(String antiqueRegistryPath) {
        return ModAntiques.register(antiqueRegistryPath, null);
    }

    public static Antique register(String antiqueRegistryPath, @Nullable String author) {
        return ModAntiques.register(new Antique(VaultMod.id(antiqueRegistryPath), author));
    }

    public static <T extends Antique> T register(T antique) {
        ALL_ANTIQUES.add(antique);
        return antique;
    }

    public static class Rewards {
        public static final AntiqueReward.Provider ITEM_LIST = Rewards.simple("item_list", AntiqueRewardItemList::new);
        public static final AntiqueReward.Provider SPECIFIC_GEAR = Rewards.simple("gear_item_list", AntiqueRewardSpecificGear::new);
        public static final AntiqueReward.Provider COMBINED = Rewards.simple("combined", AntiqueRewardCombined::new);

        public static void registerAntiqueRewards(RegistryEvent.Register<AntiqueReward.Provider> event) {
            IForgeRegistry registry = event.getRegistry();
            registry.register((IForgeRegistryEntry)ITEM_LIST);
            registry.register((IForgeRegistryEntry)SPECIFIC_GEAR);
            registry.register((IForgeRegistryEntry)COMBINED);
        }

        private static AntiqueReward.Provider simple(String name, Supplier<AntiqueReward> newInst) {
            return AntiqueReward.Provider.make(VaultMod.id(name), newInst);
        }
    }

    public static class Conditions {
        public static final AntiqueCondition.Provider OR = Conditions.simple("or", AntiqueConditionOr::new);
        public static final AntiqueCondition.Provider AND = Conditions.simple("and", AntiqueConditionAnd::new);
        public static final AntiqueCondition.Provider NOT = Conditions.simple("not", AntiqueConditionNegate::new);
        public static final AntiqueCondition.Provider LEVEL = Conditions.simple("level", AntiqueConditionLevel::new);
        public static final AntiqueCondition.Provider TYPE = Conditions.simple("type", AntiqueConditionType::new);
        public static final AntiqueCondition.Provider TAG = Conditions.simple("tag", AntiqueConditionTag::new);
        public static final AntiqueCondition.Provider KEY = Conditions.simple("key", AntiqueConditionKey::new);
        public static final AntiqueCondition.Provider CHANCE = Conditions.simple("chance", AntiqueConditionChance::new);
        public static final AntiqueCondition.Provider ENTITY_GROUP = Conditions.simple("entity_group", AntiqueConditionEntityGroup::new);
        public static final AntiqueCondition.Provider PLAYER_HAS_ITEM = Conditions.simple("player_has_item", AntiqueConditionPlayerHasItem::new);

        public static void registerAntiqueConditions(RegistryEvent.Register<AntiqueCondition.Provider> event) {
            IForgeRegistry registry = event.getRegistry();
            registry.register((IForgeRegistryEntry)OR);
            registry.register((IForgeRegistryEntry)AND);
            registry.register((IForgeRegistryEntry)NOT);
            registry.register((IForgeRegistryEntry)LEVEL);
            registry.register((IForgeRegistryEntry)TYPE);
            registry.register((IForgeRegistryEntry)TAG);
            registry.register((IForgeRegistryEntry)KEY);
            registry.register((IForgeRegistryEntry)CHANCE);
            registry.register((IForgeRegistryEntry)ENTITY_GROUP);
            registry.register((IForgeRegistryEntry)PLAYER_HAS_ITEM);
        }

        private static AntiqueCondition.Provider simple(String name, Supplier<AntiqueCondition> newInst) {
            return AntiqueCondition.Provider.make(VaultMod.id(name), newInst);
        }
    }
}

