/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.init;

import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.mixin.MixinBooleanValue;
import iskallia.vault.mixin.MixinIntegerValue;
import iskallia.vault.network.message.ClientboundSyncMaxLevelMessage;
import iskallia.vault.network.message.ClientboundSyncVaultAllowWaypointsMessage;
import iskallia.vault.network.message.ClientboundSyncVaultLockerMessage;
import iskallia.vault.world.SpectatorMode;
import iskallia.vault.world.VaultCrystalMode;
import iskallia.vault.world.VaultCrystalRecipeScaling;
import iskallia.vault.world.VaultExperience;
import iskallia.vault.world.VaultLoot;
import iskallia.vault.world.VaultMode;
import iskallia.vault.world.VaultPartyExpSharing;
import iskallia.vault.world.data.QuestStatesData;
import java.util.function.BiConsumer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber
public class ModGameRules {
    public static GameRules.Key<GameRules.BooleanValue> FINAL_VAULT_ALLOW_PARTY;
    public static GameRules.Key<GameRules.BooleanValue> JOIN_REQUIRE_PARTY;
    public static GameRules.Key<GameRules.IntegerValue> HERALD_MIN_LEVEL;
    public static GameRules.Key<GameRules.IntegerValue> TEMPLATE_CACHE_SIZE;
    public static GameRules.Key<GameRules.BooleanValue> ALLOW_WAYPOINTS;
    public static GameRules.Key<GameRules.BooleanValue> NO_OP_DIFFICULTY;
    public static GameRules.Key<VaultMode.GameRuleValue> MODE;
    public static GameRules.Key<VaultLoot.GameRuleValue> LOOT;
    public static GameRules.Key<VaultExperience.GameRuleValue> EXPERIENCE;
    public static GameRules.Key<VaultCrystalMode.GameRuleValue> CRYSTAL_MODE;
    public static GameRules.Key<GameRules.BooleanValue> PRINT_SAVE_DATA_TIMING;
    public static GameRules.Key<GameRules.BooleanValue> BOOST_PENALTY;
    public static GameRules.Key<GameRules.BooleanValue> QUEST_EXPERT_MODE;
    public static GameRules.Key<GameRules.BooleanValue> NO_RESEARCH_TEAM_PENALTY;
    public static GameRules.Key<GameRules.BooleanValue> ALLOW_MENTOR_BREW;
    public static GameRules.Key<GameRules.BooleanValue> ALLOW_KNOWLEDGE_BREW;
    public static GameRules.Key<VaultCrystalRecipeScaling.GameRuleValue> CRYSTAL_RECIPE_SCALING;
    public static GameRules.Key<VaultPartyExpSharing.GameRuleValue> PARTY_EXP_SHARING;
    public static GameRules.Key<GameRules.BooleanValue> WEIGHTED_ARTIFACTS;
    public static GameRules.Key<GameRules.IntegerValue> VAULT_TIMER;
    public static GameRules.Key<GameRules.IntegerValue> LEVEL_LOCK;
    public static GameRules.Key<SpectatorMode.GameRuleValue> SPECTATOR_MODE;
    public static GameRules.Key<GameRules.BooleanValue> SPECTATOR_PARTY_ONLY;
    public static GameRules.Key<GameRules.BooleanValue> PARTY_MAP_SHARING;
    public static GameRules.Key<GameRules.BooleanValue> LOCKER;

    public static void initialize() {
        FINAL_VAULT_ALLOW_PARTY = ModGameRules.register("finalVaultAllowParty", GameRules.Category.PLAYER, ModGameRules.booleanRule(true));
        JOIN_REQUIRE_PARTY = ModGameRules.register("vaultJoinRequireParty", GameRules.Category.PLAYER, ModGameRules.booleanRule(true));
        HERALD_MIN_LEVEL = ModGameRules.register("vaultHeraldMinLevel", GameRules.Category.PLAYER, ModGameRules.integerRule(100));
        TEMPLATE_CACHE_SIZE = ModGameRules.register("vaultTemplateCacheSize", GameRules.Category.PLAYER, ModGameRules.integerRule(32));
        ALLOW_WAYPOINTS = ModGameRules.register("vaultAllowWaypoints", GameRules.Category.PLAYER, ModGameRules.booleanRule(false, (server, value) -> ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ClientboundSyncVaultAllowWaypointsMessage(value.m_46223_()))));
        NO_OP_DIFFICULTY = ModGameRules.register("vaultNoOpDifficulty", GameRules.Category.PLAYER, ModGameRules.booleanRule(true));
        MODE = ModGameRules.register("vaultMode", GameRules.Category.PLAYER, VaultMode.GameRuleValue.create(VaultMode.NORMAL));
        LOOT = ModGameRules.register("vaultLoot", GameRules.Category.PLAYER, VaultLoot.GameRuleValue.create(VaultLoot.NORMAL));
        EXPERIENCE = ModGameRules.register("vaultExperience", GameRules.Category.PLAYER, VaultExperience.GameRuleValue.create(VaultExperience.NORMAL));
        CRYSTAL_MODE = ModGameRules.register("vaultCrystalMode", GameRules.Category.PLAYER, VaultCrystalMode.GameRuleValue.create(VaultCrystalMode.NORMAL));
        PRINT_SAVE_DATA_TIMING = ModGameRules.register("vaultPrintSaveDataTiming", GameRules.Category.PLAYER, ModGameRules.booleanRule(false));
        BOOST_PENALTY = ModGameRules.register("vaultBoostPenalty", GameRules.Category.PLAYER, ModGameRules.booleanRule(false));
        QUEST_EXPERT_MODE = ModGameRules.register("questExpertMode", GameRules.Category.PLAYER, ModGameRules.booleanRule(false, (server, value) -> {
            if (value.m_46223_()) {
                QuestStatesData.get().setExpertMode(server.m_129783_());
            }
        }));
        NO_RESEARCH_TEAM_PENALTY = ModGameRules.register("vaultNoResearchTeamPenalty", GameRules.Category.PLAYER, ModGameRules.booleanRule(true));
        ALLOW_MENTOR_BREW = ModGameRules.register("vaultAllowMentoring", GameRules.Category.PLAYER, ModGameRules.booleanRule(true));
        ALLOW_KNOWLEDGE_BREW = ModGameRules.register("vaultAllowKnowledgeBrew", GameRules.Category.PLAYER, ModGameRules.booleanRule(true));
        CRYSTAL_RECIPE_SCALING = ModGameRules.register("vaultCrystalRecipeScaling", GameRules.Category.PLAYER, VaultCrystalRecipeScaling.GameRuleValue.create(VaultCrystalRecipeScaling.NORMAL));
        PARTY_EXP_SHARING = ModGameRules.register("vaultPartyExpSharing", GameRules.Category.PLAYER, VaultPartyExpSharing.GameRuleValue.create(VaultPartyExpSharing.DISABLED));
        VAULT_TIMER = ModGameRules.register("vaultTimer", GameRules.Category.PLAYER, ModGameRules.integerRule(25));
        LEVEL_LOCK = ModGameRules.register("vaultLevelLock", GameRules.Category.PLAYER, ModGameRules.integerRule(ModConfigs.LEVELS_META.getMaxLevel(), (server, value) -> ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ClientboundSyncMaxLevelMessage(value.m_46288_()))));
        WEIGHTED_ARTIFACTS = ModGameRules.register("vaultWeightedArtifacts", GameRules.Category.PLAYER, ModGameRules.booleanRule(true));
        SPECTATOR_MODE = ModGameRules.register("vaultSpectatorMode", GameRules.Category.PLAYER, SpectatorMode.GameRuleValue.create(SpectatorMode.PLAYER));
        SPECTATOR_PARTY_ONLY = ModGameRules.register("vaultSpectatePartyOnly", GameRules.Category.PLAYER, ModGameRules.booleanRule(false));
        PARTY_MAP_SHARING = ModGameRules.register("vaultPartyMapSharing", GameRules.Category.PLAYER, ModGameRules.booleanRule(false));
        LOCKER = ModGameRules.register("vaultLocker", GameRules.Category.PLAYER, ModGameRules.booleanRule(true, (server, value) -> ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ClientboundSyncVaultLockerMessage(value.m_46223_()))));
    }

    public static <T extends GameRules.Value<T>> GameRules.Key<T> register(String name, GameRules.Category category, GameRules.Type<T> type) {
        return GameRules.m_46189_((String)name, (GameRules.Category)category, type);
    }

    public static GameRules.Type<GameRules.BooleanValue> booleanRule(boolean defaultValue) {
        return MixinBooleanValue.create(defaultValue, (minecraftServer, booleanValue) -> {});
    }

    public static GameRules.Type<GameRules.BooleanValue> booleanRule(boolean defaultValue, BiConsumer<MinecraftServer, GameRules.BooleanValue> changeListener) {
        return MixinBooleanValue.create(defaultValue, changeListener);
    }

    public static GameRules.Type<GameRules.IntegerValue> integerRule(int defaultValue) {
        return MixinIntegerValue.create(defaultValue, (minecraftServer, integerValue) -> {});
    }

    public static GameRules.Type<GameRules.IntegerValue> integerRule(int defaultValue, BiConsumer<MinecraftServer, GameRules.IntegerValue> changeListener) {
        return MixinIntegerValue.create(defaultValue, changeListener);
    }

    @SubscribeEvent
    public static void syncGameRules(OnDatapackSyncEvent event) {
        ServerPlayer player = event.getPlayer();
        if (player == null) {
            event.getPlayerList().m_11314_().forEach(serverPlayer -> {
                ModNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ClientboundSyncVaultAllowWaypointsMessage(serverPlayer.m_183503_().m_46469_().m_46207_(ALLOW_WAYPOINTS)));
                ModNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ClientboundSyncVaultLockerMessage(serverPlayer.m_183503_().m_46469_().m_46207_(LOCKER)));
            });
            return;
        }
        ModNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientboundSyncVaultAllowWaypointsMessage(player.m_183503_().m_46469_().m_46207_(ALLOW_WAYPOINTS)));
        ModNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientboundSyncVaultLockerMessage(player.m_183503_().m_46469_().m_46207_(LOCKER)));
    }

    @SubscribeEvent
    public static void syncGameRulesOnDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ModNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ClientboundSyncVaultAllowWaypointsMessage(serverPlayer.m_183503_().m_46469_().m_46207_(ALLOW_WAYPOINTS)));
        ModNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ClientboundSyncVaultLockerMessage(serverPlayer.m_183503_().m_46469_().m_46207_(LOCKER)));
    }
}

