/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.init;

import com.google.gson.JsonArray;
import com.mojang.datafixers.util.Pair;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.reader.DecimalModifierReader;
import iskallia.vault.gear.reader.FlagModifierReader;
import iskallia.vault.gear.reader.IdentifierValueModifierReader;
import iskallia.vault.gear.reader.IncreasedPercentageReader;
import iskallia.vault.gear.reader.IntegerModifierReader;
import iskallia.vault.gear.reader.StringConstantModifierReader;
import iskallia.vault.gear.reader.StringValueModifierReader;
import iskallia.vault.gear.reader.VaultGearModifierReader;
import iskallia.vault.util.Throuple;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.function.TriFunction;

public class ModGearAttributeReaders {
    public static IntegerModifierReader addedIntReader(String modifierName, int rgbColor) {
        return new IntegerModifierReader(modifierName, rgbColor);
    }

    public static <T extends Number> IncreasedPercentageReader<T> increasedReader(String modifierName, int rgbColor) {
        return new IncreasedPercentageReader(modifierName, rgbColor);
    }

    public static <T extends Number> DecimalModifierReader<T> percentageReader(String modifierName, int rgbColor) {
        return new DecimalModifierReader.Percentage(modifierName, rgbColor);
    }

    public static <T extends Number> DecimalModifierReader<T> addedDecimalReader(String modifierName, int rgbColor) {
        return new DecimalModifierReader.Added(modifierName, rgbColor);
    }

    public static <T extends Float> DecimalModifierReader<T> addedRoundedDecimalReader(String modifierName, int rgbColor) {
        return new DecimalModifierReader.Round(modifierName, rgbColor);
    }

    public static <T extends Float> DecimalModifierReader<T> addedRoundedDecimalReader(String modifierName, int rgbColor, float multiplier) {
        return new DecimalModifierReader.Round(modifierName, rgbColor, multiplier);
    }

    public static StringConstantModifierReader stringReader(String modifierName, int rgbColor, String format) {
        return new StringConstantModifierReader(modifierName, rgbColor, format);
    }

    public static StringValueModifierReader stringReader(Function<String, String> formatter, int rgbColor) {
        return new StringValueModifierReader(rgbColor, formatter);
    }

    public static IdentifierValueModifierReader identifierReader(Function<ResourceLocation, String> formatter, int rgbColor) {
        return new IdentifierValueModifierReader(rgbColor, formatter);
    }

    public static FlagModifierReader booleanReader(String modifierName, int rgbColor) {
        return new FlagModifierReader(modifierName, rgbColor);
    }

    public static FlagModifierReader booleanReader(String modifierName, int rgbColor, String moreInfo) {
        return new FlagModifierReader(modifierName, rgbColor, moreInfo);
    }

    public static <F, S> VaultGearModifierReader<Pair<F, S>> pairReader(String modifierName, int rgbColor, final BiFunction<F, S, MutableComponent> display) {
        return new VaultGearModifierReader<Pair<F, S>>(modifierName, rgbColor){

            @Override
            @Nullable
            public MutableComponent getDisplay(VaultGearAttributeInstance<Pair<F, S>> instance, VaultGearModifier.AffixType type) {
                MutableComponent value = this.getValueDisplay(instance.getValue());
                if (value == null) {
                    return null;
                }
                return new TextComponent(type.getAffixPrefix(true)).m_7220_((Component)value).m_6270_(this.getColoredTextStyle());
            }

            @Override
            @Nullable
            public MutableComponent getValueDisplay(Pair<F, S> value) {
                return (MutableComponent)display.apply(value.getFirst(), value.getSecond());
            }

            @Override
            protected void serializeTextElements(JsonArray out, VaultGearAttributeInstance<Pair<F, S>> instance, VaultGearModifier.AffixType type) {
                MutableComponent val = this.getValueDisplay(instance.getValue());
                if (val != null) {
                    out.add(type.getAffixPrefix(true));
                    out.add(val.getString());
                }
            }
        };
    }

    public static <A, B, C> VaultGearModifierReader<Throuple<A, B, C>> throupleReader(String modifierName, int rgbColor, final TriFunction<A, B, C, MutableComponent> display) {
        return new VaultGearModifierReader<Throuple<A, B, C>>(modifierName, rgbColor){

            @Override
            @Nullable
            public MutableComponent getDisplay(VaultGearAttributeInstance<Throuple<A, B, C>> instance, VaultGearModifier.AffixType type) {
                MutableComponent value = this.getValueDisplay(instance.getValue());
                if (value == null) {
                    return null;
                }
                return new TextComponent(type.getAffixPrefix(true)).m_7220_((Component)value).m_6270_(this.getColoredTextStyle());
            }

            @Override
            @Nullable
            public MutableComponent getValueDisplay(Throuple<A, B, C> value) {
                return (MutableComponent)display.apply(value.getFirst(), value.getSecond(), value.getThird());
            }

            @Override
            protected void serializeTextElements(JsonArray out, VaultGearAttributeInstance<Throuple<A, B, C>> instance, VaultGearModifier.AffixType type) {
                MutableComponent val = this.getValueDisplay(instance.getValue());
                if (val != null) {
                    out.add(type.getAffixPrefix(true));
                    out.add(val.getString());
                }
            }
        };
    }

    public static <T> VaultGearModifierReader<T> none() {
        return new VaultGearModifierReader<T>("", 0){

            @Override
            @Nullable
            public MutableComponent getDisplay(VaultGearAttributeInstance<T> instance, VaultGearModifier.AffixType type) {
                return null;
            }

            @Override
            @Nullable
            public MutableComponent getValueDisplay(T value) {
                return null;
            }

            @Override
            protected void serializeTextElements(JsonArray out, VaultGearAttributeInstance<T> instance, VaultGearModifier.AffixType type) {
            }
        };
    }
}

