/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.init;

import iskallia.vault.VaultMod;
import iskallia.vault.client.render.InventoryHudRenderer;
import iskallia.vault.client.render.healthbar.HealthbarDisplayOption;
import iskallia.vault.client.render.hunter.HunterOutlineMode;
import iskallia.vault.client.render.hunter.HunterOutlineThickness;
import iskallia.vault.client.render.hunter.HunterParticleDensityOption;
import iskallia.vault.options.VaultOption;
import iskallia.vault.options.VaultOptionsRegistry;
import iskallia.vault.skill.ability.effect.spi.HunterAbility;
import iskallia.vault.util.ColorBlindMode;
import iskallia.vault.util.CooldownGuiOption;

public class ModOptions {
    private static int optionsVersion = 1;
    public static final VaultOption<CooldownGuiOption> COOLDOWN_GUI = VaultOptionsRegistry.registerEnum(VaultMod.id("cooldown_gui"), CooldownGuiOption.OFF);
    public static final VaultOption<Boolean> VANILLA_POTION_DAMAGE_EFFECTS = VaultOptionsRegistry.registerBoolean(VaultMod.id("do_vanilla_potion_damage_effects"), false);
    public static final VaultOption<Boolean> ABILITY_SCROLLING_ENABLED = VaultOptionsRegistry.registerBoolean(VaultMod.id("ability_scrolling"), true);
    public static final VaultOption<Boolean> SHOW_TREASURE_DOOR_NAMES = VaultOptionsRegistry.registerBoolean(VaultMod.id("treasure_door_names"), false);
    public static final VaultOption<Boolean> HIGHLIGHT_RARITY = VaultOptionsRegistry.registerBoolean(VaultMod.id("highlight_rarity"), true);
    public static final VaultOption<Boolean> SHOW_POINT_MESSAGES = VaultOptionsRegistry.registerBoolean(VaultMod.id("show_point_messages"), true);
    public static final VaultOption<Boolean> SHOW_RARITY_NAMES = VaultOptionsRegistry.registerBoolean(VaultMod.id("show_rarity_names"), false);
    public static final VaultOption<Boolean> ABILITY_QUICKBINDING_ENABLED = VaultOptionsRegistry.registerBoolean(VaultMod.id("ability_quickbinding_enabled"), false);
    public static final VaultOption<Boolean> HUD_ONLY_TAB = VaultOptionsRegistry.registerBoolean(VaultMod.id("hud_on_tab"), false);
    public static final VaultOption<InventoryHudRenderer.InventoryHudDisplayMode> INVENTORY_HUD_MODE = VaultOptionsRegistry.registerEnum(VaultMod.id("inv_hud_mode"), InventoryHudRenderer.InventoryHudDisplayMode.LOW);
    public static final VaultOption<InventoryHudRenderer.InventoryHudDisplayMode> INVENTORY_USES_HUD_MODE = VaultOptionsRegistry.registerEnum(VaultMod.id("inv_hud_uses_mode"), InventoryHudRenderer.InventoryHudDisplayMode.LOW);
    public static final VaultOption<HealthbarDisplayOption> HEALTHBAR_ENABLED = VaultOptionsRegistry.registerEnum(VaultMod.id("healthbar_enabled"), HealthbarDisplayOption.ENABLED);
    public static final VaultOption<Boolean> TOTEM_PARTICLES = VaultOptionsRegistry.registerBoolean(VaultMod.id("totem_particles"), true);
    public static final VaultOption<Boolean> HUNTER_PARTICLES = VaultOptionsRegistry.registerBoolean(VaultMod.id("hunter_particles"), false);
    public static final VaultOption<HunterOutlineMode> HUNTER_OUTLINE_MODE = VaultOptionsRegistry.registerEnum(VaultMod.id("hunter_outline_mode"), HunterOutlineMode.DETAILED);
    public static final VaultOption<HunterOutlineThickness> HUNTER_OUTLINE_THICKNESS = VaultOptionsRegistry.registerEnum(VaultMod.id("hunter_outline_thickness"), HunterOutlineThickness.NORMAL);
    public static final VaultOption<HunterParticleDensityOption> HUNTER_PARTICLE_DENSITY = VaultOptionsRegistry.registerEnum(VaultMod.id("hunter_particle_density"), HunterParticleDensityOption.NORMAL);
    public static final VaultOption<Integer> HUNTER_WOODEN_COLOR = VaultOptionsRegistry.registerInteger(VaultMod.id("hunter_wooden_color"), 14912768);
    public static final VaultOption<Integer> HUNTER_GILDED_COLOR = VaultOptionsRegistry.registerInteger(VaultMod.id("hunter_gilded_color"), 0xFFFF00);
    public static final VaultOption<Integer> HUNTER_LIVING_COLOR = VaultOptionsRegistry.registerInteger(VaultMod.id("hunter_living_color"), 65280);
    public static final VaultOption<Integer> HUNTER_ORNATE_COLOR = VaultOptionsRegistry.registerInteger(VaultMod.id("hunter_ornate_color"), 0xEE0000);
    public static final VaultOption<Integer> HUNTER_COINS_COLOR = VaultOptionsRegistry.registerInteger(VaultMod.id("hunter_coins_color"), 13464103);
    public static final VaultOption<Integer> HUNTER_HARDENED_COLOR = VaultOptionsRegistry.registerInteger(VaultMod.id("hunter_hardened_color"), 0xFF0000);
    public static final VaultOption<Integer> HUNTER_FLESH_COLOR = VaultOptionsRegistry.registerInteger(VaultMod.id("hunter_flesh_color"), 0xFF00FF);
    public static final VaultOption<Integer> HUNTER_ENIGMA_COLOR = VaultOptionsRegistry.registerInteger(VaultMod.id("hunter_enigma_color"), 255);
    public static final VaultOption<Integer> HUNTER_OBJECTIVES_COLOR = VaultOptionsRegistry.registerInteger(VaultMod.id("hunter_objectives_color"), 2468608);
    public static final VaultOption<Integer> HUNTER_GOD_ALTARS_COLOR = VaultOptionsRegistry.registerInteger(VaultMod.id("hunter_god_altars_color"), 2468608);
    public static final VaultOption<Integer> HUNTER_DUNGEONS_COLOR = VaultOptionsRegistry.registerInteger(VaultMod.id("hunter_dungeons_color"), 6836358);
    public static final VaultOption<Integer> HUNTER_VENDOORS_COLOR = VaultOptionsRegistry.registerInteger(VaultMod.id("hunter_vendoors_color"), 16472397);
    public static final VaultOption<Integer> HUNTER_TREASURE_DOORS_COLOR = VaultOptionsRegistry.registerInteger(VaultMod.id("hunter_treasure_doors_color"), 16771584);
    public static final VaultOption<Integer> HUNTER_PYLONS_COLOR = VaultOptionsRegistry.registerInteger(VaultMod.id("hunter_pylons_color"), 8501759);
    public static final VaultOption<ColorBlindMode> COLOR_BLIND_MODE = VaultOptionsRegistry.registerEnum(VaultMod.id("color_blind_mode"), ColorBlindMode.NONE);

    public static int getOptionsVersion() {
        return optionsVersion;
    }

    public static void init() {
        VaultOptionsRegistry.loadOptions();
    }

    public static VaultOption<Integer> getHunterColorOption(HunterAbility.Target target) {
        if (target == null) {
            return HUNTER_WOODEN_COLOR;
        }
        return switch (target) {
            default -> throw new IncompatibleClassChangeError();
            case HunterAbility.Target.WOODEN -> HUNTER_WOODEN_COLOR;
            case HunterAbility.Target.GILDED -> HUNTER_GILDED_COLOR;
            case HunterAbility.Target.LIVING -> HUNTER_LIVING_COLOR;
            case HunterAbility.Target.ORNATE -> HUNTER_ORNATE_COLOR;
            case HunterAbility.Target.COINS -> HUNTER_COINS_COLOR;
            case HunterAbility.Target.HARDENED -> HUNTER_HARDENED_COLOR;
            case HunterAbility.Target.FLESH -> HUNTER_FLESH_COLOR;
            case HunterAbility.Target.ENIGMA -> HUNTER_ENIGMA_COLOR;
            case HunterAbility.Target.OBJECTIVES -> HUNTER_OBJECTIVES_COLOR;
            case HunterAbility.Target.GOD_ALTARS -> HUNTER_GOD_ALTARS_COLOR;
            case HunterAbility.Target.DUNGEONS -> HUNTER_DUNGEONS_COLOR;
            case HunterAbility.Target.VENDOORS -> HUNTER_VENDOORS_COLOR;
            case HunterAbility.Target.TREASURE_DOORS -> HUNTER_TREASURE_DOORS_COLOR;
            case HunterAbility.Target.PYLONS -> HUNTER_PYLONS_COLOR;
        };
    }

    public static int getHunterColor(HunterAbility.Target target, int def) {
        VaultOption<Integer> option = ModOptions.getHunterColorOption(target);
        if (option == null) {
            return def;
        }
        Integer color = option.getValue();
        if (color == null) {
            return def;
        }
        return color;
    }
}

