/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.init;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import iskallia.vault.VaultMod;
import iskallia.vault.client.shader.BlurPositionTexShader;
import iskallia.vault.client.shader.ClipPositionTexShader;
import iskallia.vault.client.shader.ColorizePositionTexShader;
import iskallia.vault.client.shader.GrayscalePositionTexShader;
import iskallia.vault.client.shader.ShaderChain;
import iskallia.vault.client.shader.glsl.NativeGrayscaleShader;
import java.io.IOException;
import java.util.function.Consumer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterShadersEvent;

@OnlyIn(value=Dist.CLIENT)
public class ModShaders {
    private static BlurPositionTexShader blurPositionTexShader;
    private static ClipPositionTexShader clipPositionTexShader;
    private static GrayscalePositionTexShader grayscalePositionTexShader;
    private static ColorizePositionTexShader colorizePositionTexShader;
    private static NativeGrayscaleShader nativeGrayscaleShader;
    private static ShaderChain grayscaleShaderChain;

    public static BlurPositionTexShader getBlurPositionTexShader() {
        return blurPositionTexShader;
    }

    public static ClipPositionTexShader getClipPositionTexShader() {
        return clipPositionTexShader;
    }

    public static GrayscalePositionTexShader getGrayscalePositionTexShader() {
        return grayscalePositionTexShader;
    }

    public static ColorizePositionTexShader getColorizePositionTexShader() {
        return colorizePositionTexShader;
    }

    public static NativeGrayscaleShader getNativeGrayscaleShader() {
        return nativeGrayscaleShader;
    }

    public static ShaderChain getGrayscaleShaderChain() {
        return grayscaleShaderChain;
    }

    public static void register(RegisterShadersEvent event) {
        ModShaders.registerShader(event, VaultMod.id("blur"), DefaultVertexFormat.f_85814_, shaderInstance -> {
            blurPositionTexShader = new BlurPositionTexShader((ShaderInstance)shaderInstance);
        });
        ModShaders.registerShader(event, VaultMod.id("position_tex_clip"), DefaultVertexFormat.f_85817_, shaderInstance -> {
            clipPositionTexShader = new ClipPositionTexShader((ShaderInstance)shaderInstance);
        });
        ModShaders.registerShader(event, VaultMod.id("position_tex_grayscale"), DefaultVertexFormat.f_85817_, shaderInstance -> {
            grayscalePositionTexShader = new GrayscalePositionTexShader((ShaderInstance)shaderInstance);
        });
        ModShaders.registerShader(event, VaultMod.id("position_tex_colorize"), DefaultVertexFormat.f_85817_, shaderInstance -> {
            colorizePositionTexShader = new ColorizePositionTexShader((ShaderInstance)shaderInstance);
        });
        if (nativeGrayscaleShader != null) {
            nativeGrayscaleShader.destroy();
        }
        nativeGrayscaleShader = new NativeGrayscaleShader((ResourceProvider)event.getResourceManager()).withGrayscale(0.9f).withBrightness(0.7f);
        if (grayscaleShaderChain != null) {
            grayscaleShaderChain.destroy();
        }
        grayscaleShaderChain = ShaderChain.builder().addShader(nativeGrayscaleShader).build();
    }

    private static void registerShader(RegisterShadersEvent event, ResourceLocation resourceLocation, VertexFormat vertexFormat, Consumer<ShaderInstance> onLoaded) {
        try {
            event.registerShader(new ShaderInstance((ResourceProvider)event.getResourceManager(), resourceLocation, vertexFormat), onLoaded);
        }
        catch (IOException e) {
            VaultMod.LOGGER.error("Error loading shader %s".formatted(resourceLocation), (Throwable)e);
        }
    }
}

