/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.init;

import iskallia.vault.VaultMod;
import iskallia.vault.client.atlas.ITextureAtlas;
import iskallia.vault.client.atlas.ResourceTextureAtlasHolder;
import iskallia.vault.client.gui.overlay.AbilitiesOverlay;
import iskallia.vault.client.gui.screen.player.legacy.widget.AbilityNodeTextures;
import iskallia.vault.client.gui.screen.player.legacy.widget.ArchetypeNodeTextures;
import iskallia.vault.config.AbilitiesGUIConfig;
import iskallia.vault.config.ArchetypeGUIConfig;
import iskallia.vault.config.EntityGroupDefinitionsConfig;
import iskallia.vault.config.entry.ResearchGroupStyle;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.quest.base.Quest;
import iskallia.vault.util.function.Memo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModTextureAtlases {
    private static final Map<ResourceLocation, Supplier<ITextureAtlas>> REGISTRY = new HashMap<ResourceLocation, Supplier<ITextureAtlas>>();
    public static final Supplier<ITextureAtlas> MODIFIERS = ModTextureAtlases.register(VaultMod.id("textures/atlas/modifiers.png"), VaultMod.id("textures/gui/modifiers"), () -> VaultModifierRegistry.getAll().map(VaultModifier::getIcon).flatMap(Optional::stream).toList());
    public static final Supplier<ITextureAtlas> ABILITIES = ModTextureAtlases.register(VaultMod.id("textures/atlas/abilities.png"), VaultMod.id("textures/gui/abilities"), () -> Stream.concat(ModConfigs.ABILITIES_GUI.getStyles().values().stream().map(AbilitiesGUIConfig.AbilityStyle::getIcons).flatMap(Collection::stream), AbilityNodeTextures.stream()).collect(Collectors.toCollection(() -> new ArrayList<ResourceLocation>(AbilitiesOverlay.GUI_ELEMENTS))));
    public static final Supplier<ITextureAtlas> ARCHETYPES = ModTextureAtlases.register(VaultMod.id("textures/atlas/archetypes.png"), VaultMod.id("textures/gui/archetypes"), () -> Stream.concat(ModConfigs.ARCHETYPES_GUI.getStyles().values().stream().map(ArchetypeGUIConfig.IconStyle::getIcon), ArchetypeNodeTextures.stream()).collect(Collectors.toList()));
    public static final Supplier<ITextureAtlas> RESEARCHES = ModTextureAtlases.register(VaultMod.id("textures/atlas/researches.png"), VaultMod.id("textures/gui/researches"), () -> ModConfigs.RESEARCHES_GUI.getStyles().values().stream().flatMap(style -> Stream.of(style.icon, style.inactiveIcon)).toList());
    public static final Supplier<ITextureAtlas> RESEARCH_GROUPS = ModTextureAtlases.register(VaultMod.id("textures/atlas/research_groups.png"), VaultMod.id("textures/gui/research_groups"), () -> ModConfigs.RESEARCH_GROUP_STYLES.getStyles().values().stream().map(ResearchGroupStyle::getIcon).toList());
    public static final Supplier<ITextureAtlas> SKILLS = ModTextureAtlases.register(VaultMod.id("textures/atlas/skills.png"), VaultMod.id("textures/gui/skills"), () -> ModConfigs.TALENTS_GUI.getStyles().values().stream().flatMap(style -> Stream.of(style.icon, style.inactiveIcon)).toList());
    public static final Supplier<ITextureAtlas> PRESTIGE = ModTextureAtlases.register(VaultMod.id("textures/atlas/prestige_powers.png"), VaultMod.id("textures/gui/prestige"), () -> ModConfigs.PRESTIGE_POWERS_GUI.getStyles().values().stream().flatMap(style -> Stream.of(style.icon, style.inactiveIcon)).toList());
    public static final Supplier<ITextureAtlas> SCREEN = ModTextureAtlases.register(VaultMod.id("textures/atlas/screen.png"), VaultMod.id("textures/gui/screen"), null);
    public static final Supplier<ITextureAtlas> SLOT = ModTextureAtlases.register(VaultMod.id("textures/atlas/slot.png"), VaultMod.id("textures/gui/slot"), null);
    public static final Supplier<ITextureAtlas> SCAVENGER = ModTextureAtlases.register(VaultMod.id("textures/atlas/scavenger.png"), VaultMod.id("textures/gui/scavenger"), null);
    public static final Supplier<ITextureAtlas> MOB_HEADS = ModTextureAtlases.register(VaultMod.id("textures/atlas/mob_heads.png"), VaultMod.id("textures/gui/mob_heads"), null);
    public static final Supplier<ITextureAtlas> QUESTS = ModTextureAtlases.register(VaultMod.id("textures/atlas/quests.png"), VaultMod.id("textures/gui/quests"), () -> {
        ArrayList<ResourceLocation> icons = new ArrayList<ResourceLocation>(ModConfigs.QUESTS.getQuests().stream().map(Quest::getIcon).toList());
        ModConfigs.SKY_QUESTS.getQuests().forEach(quest -> {
            if (!icons.contains(quest.getIcon())) {
                icons.add(quest.getIcon());
            }
        });
        icons.add(VaultMod.id("gui/quests/check"));
        return icons;
    });
    public static final Supplier<ITextureAtlas> ACHIEVEMENTS = ModTextureAtlases.register(VaultMod.id("textures/atlas/achievements.png"), VaultMod.id("textures/gui/achievements"), null);
    public static final Supplier<ITextureAtlas> TITLE = ModTextureAtlases.register(VaultMod.id("textures/atlas/title.png"), VaultMod.id("textures/gui/title"), null);
    public static final Supplier<ITextureAtlas> MOB_GROUPS = ModTextureAtlases.register(VaultMod.id("textures/atlas/mob_groups.png"), VaultMod.id("textures/gui/mob_groups"), () -> ModConfigs.ENTITY_GROUP_DEFINITIONS.getGroups().stream().map(EntityGroupDefinitionsConfig.EntityGroupDefinition::getIcon).toList());
    public static final Supplier<ITextureAtlas> VAULT_MAP = ModTextureAtlases.register(VaultMod.id("textures/atlas/vault_map.png"), VaultMod.id("textures/gui/map"), () -> ModConfigs.VAULT_MAP_ICONS.getIcons());
    public static final Supplier<ITextureAtlas> INVENTORY_HUD = ModTextureAtlases.register(VaultMod.id("textures/atlas/inventory_hud.png"), VaultMod.id("textures/gui/inventory_hud"), null);

    @SubscribeEvent
    public static void on(RegisterClientReloadListenersEvent event) {
        REGISTRY.values().stream().map(Supplier::get).forEach(arg_0 -> ((RegisterClientReloadListenersEvent)event).registerReloadListener(arg_0));
    }

    private static Supplier<ITextureAtlas> register(ResourceLocation id, ResourceLocation resourceLocation, @Nullable Supplier<List<ResourceLocation>> validationSupplier) {
        if (REGISTRY.containsKey(id)) {
            throw new IllegalStateException("Duplicate atlas resource location registered: " + String.valueOf(id));
        }
        Supplier<ITextureAtlas> supplier = Memo.of(() -> {
            TextureManager textureManager = Minecraft.m_91087_().f_90987_;
            ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
            return new ResourceTextureAtlasHolder(textureManager, resourceManager, id, resourceLocation, validationSupplier);
        });
        REGISTRY.put(id, supplier);
        return supplier;
    }
}

