/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.integration;

import iskallia.vault.client.gui.overlay.VaultMapOverlay;
import iskallia.vault.client.render.IVaultOptions;
import iskallia.vault.core.vault.ClientVaults;
import iskallia.vault.init.ModGameRules;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ScreenOpenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import xaero.common.gui.GuiAddWaypoint;
import xaero.common.gui.GuiWaypoints;
import xaero.common.settings.ModOptions;
import xaero.common.settings.ModSettings;
import xaero.minimap.XaeroMinimap;

@OnlyIn(value=Dist.CLIENT)
public class IntegrationMinimap {
    @SubscribeEvent
    public static void onWaypointScreen(ScreenOpenEvent event) {
        Screen screen;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (ClientVaults.getActive().isPresent() && !player.m_183503_().m_46469_().m_46207_(ModGameRules.ALLOW_WAYPOINTS) && ((screen = event.getScreen()) instanceof GuiWaypoints || screen instanceof GuiAddWaypoint)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (!ModList.get().isLoaded("xaerominimap")) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        ModList.get().getModObjectById("xaerominimap").ifPresent(mod -> {
            if (mod instanceof XaeroMinimap) {
                XaeroMinimap minimap = (XaeroMinimap)mod;
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player == null) {
                    return;
                }
                ModSettings settings = minimap.getSettings();
                IVaultOptions vaultOptions = (IVaultOptions)Minecraft.m_91087_().f_91066_;
                if (ClientVaults.getActive().isPresent()) {
                    int defaultSize;
                    double size;
                    int zoom;
                    if (((Boolean)settings.getOptionValue(ModOptions.MINIMAP)).booleanValue() && !vaultOptions.getMapVisibilityOption().equals((Object)VaultMapOverlay.MapVisibilityOption.XAEROS)) {
                        try {
                            settings.setOptionValue(ModOptions.MINIMAP, (Object)false);
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                    }
                    if (!((Boolean)settings.getOptionValue(ModOptions.MINIMAP)).booleanValue() && vaultOptions.getMapVisibilityOption().equals((Object)VaultMapOverlay.MapVisibilityOption.XAEROS)) {
                        settings.setOptionValue(ModOptions.MINIMAP, (Object)true);
                    }
                    if ((zoom = ((Integer)settings.getOptionValue(ModOptions.ZOOM)).intValue()) < 2) {
                        try {
                            settings.setOptionValue(ModOptions.ZOOM, (Object)2);
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                    }
                    if (((Boolean)settings.getOptionValue(ModOptions.COORDS)).booleanValue()) {
                        settings.setOptionValue(ModOptions.COORDS, (Object)false);
                    }
                    if ((size = settings.getOptionDoubleValue(ModOptions.SIZE)) > (double)(defaultSize = IntegrationMinimap.getDefaultMinimapSize(settings))) {
                        settings.setOptionDoubleValue(ModOptions.SIZE, 0.0);
                    }
                } else {
                    if (!((Boolean)settings.getOptionValue(ModOptions.COORDS)).booleanValue()) {
                        settings.setOptionValue(ModOptions.COORDS, (Object)true);
                    }
                    if (!((Boolean)settings.getOptionValue(ModOptions.MINIMAP)).booleanValue()) {
                        settings.setOptionValue(ModOptions.MINIMAP, (Object)true);
                    }
                }
            }
        });
    }

    public static Optional<ModSettings> getMinimapSettings() {
        return ModList.get().getModObjectById("xaerominimap").filter(mod -> mod instanceof XaeroMinimap).map(mod -> (XaeroMinimap)mod).map(XaeroMinimap::getSettings);
    }

    public static int getDefaultMinimapSize(ModSettings settings) {
        int height = Minecraft.m_91087_().m_91268_().m_85442_();
        int width = Minecraft.m_91087_().m_91268_().m_85441_();
        int settingsSize = Mth.m_14143_((float)((float)Math.min(height, width) / settings.getMinimapScale()));
        return Math.min(Math.max((int)(ModOptions.SIZE.getValueMin() + ModOptions.SIZE.getValueStep()), 2 * settingsSize * 130 / 1080), (int)ModOptions.SIZE.getValueMax());
    }
}

