/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.integration;

import iskallia.vault.util.InventoryUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackStorage;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;

public class IntegrationSB {
    private static final String VH_SNAPSHOT_TAG = "VHSnapshot";

    private IntegrationSB() {
    }

    public static void addSnapshotDataIfBackpack(ItemStack stack) {
        if (stack.m_41720_() instanceof BackpackItem) {
            stack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(backpackWrapper -> backpackWrapper.getContentsUuid().ifPresent(backpackUuid -> stack.m_41783_().m_128365_(VH_SNAPSHOT_TAG, (Tag)BackpackStorage.get().getOrCreateBackpackContents(backpackUuid).m_6426_())));
        }
    }

    public static void restoreSnapshotIfBackpack(ItemStack stack) {
        stack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(backpackWrapper -> {
            backpackWrapper.getContentsUuid().ifPresent(backpackUuid -> {
                if (stack.m_41783_() != null && stack.m_41783_().m_128441_(VH_SNAPSHOT_TAG)) {
                    CompoundTag tag = stack.m_41783_().m_128469_(VH_SNAPSHOT_TAG);
                    BackpackStorage storage = BackpackStorage.get();
                    if (tag.m_128456_()) {
                        storage.removeBackpackContents(backpackUuid);
                    } else {
                        storage.setBackpackContents(backpackUuid, tag);
                    }
                    stack.m_41783_().m_128473_(VH_SNAPSHOT_TAG);
                }
            });
            backpackWrapper.onContentsNbtUpdated();
        });
    }

    public static List<InventoryUtil.ItemAccess> getBackpackItemAccess(InventoryUtil.ItemAccess backpackAccess) {
        if (!(backpackAccess.getItem() instanceof BackpackItem)) {
            return Collections.emptyList();
        }
        return backpackAccess.getStack().getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(wrapper -> {
            ArrayList<InventoryUtil.ItemAccess> accesses = new ArrayList<InventoryUtil.ItemAccess>();
            InventoryHandler invHandler = wrapper.getInventoryHandler();
            for (int slot = 0; slot < invHandler.getSlots(); ++slot) {
                ItemStack slotStack = invHandler.getStackInSlot(slot);
                if (slotStack.m_41619_()) continue;
                int finalSlot = slot;
                accesses.add(backpackAccess.chain(slotStack, (backpackCt, newStack) -> IntegrationSB.setBackpackItem(backpackCt, newStack, finalSlot)));
            }
            return accesses;
        }).orElse(Collections.emptyList());
    }

    public static boolean setBackpackItem(ItemStack container, ItemStack toInsert, int slotId) {
        return container.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(wrapper -> {
            InventoryHandler invHandler = wrapper.getInventoryHandler();
            if (slotId >= invHandler.getSlots()) {
                return false;
            }
            invHandler.setStackInSlot(slotId, toInsert);
            return true;
        }).orElse(false);
    }

    public static void forEachBackpackItem(ItemStack stack, Consumer<ItemStack> consumer) {
        stack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(wrapper -> {
            InventoryHandler invHandler = wrapper.getInventoryHandler();
            for (int slot = 0; slot < invHandler.getSlots(); ++slot) {
                ItemStack slotStack = invHandler.getStackInSlot(slot);
                if (slotStack.m_41619_()) continue;
                consumer.accept(slotStack);
                invHandler.setStackInSlot(slot, slotStack);
            }
            wrapper.onContentsNbtUpdated();
        });
    }
}

