/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.integration.curios;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import iskallia.vault.client.particles.CharmParticle;
import iskallia.vault.client.particles.EnderAnchorParticle;
import iskallia.vault.core.vault.influence.VaultGod;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModParticles;
import iskallia.vault.item.gear.VaultCharmItem;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class CuriosCharmCompat
implements ICurioRenderer {
    Map<UUID, ParticleData> charmList = new HashMap<UUID, ParticleData>();
    ParticleEngine pe;
    Random random;
    Camera camera;
    private static final double RADIUS = 1.0;

    public CuriosCharmCompat() {
        this.pe = Minecraft.m_91087_().f_91061_;
        this.random = new Random();
        this.camera = Minecraft.m_91087_().f_91063_.m_109153_();
    }

    public static void register() {
        CuriosRendererRegistry.register((Item)ModItems.VAULT_GOD_CHARM, CuriosCharmCompat::new);
    }

    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        matrixStack.m_85836_();
        Vec3 pos = slotContext.entity().m_20182_();
        LivingEntity entity = slotContext.entity();
        if (!this.charmList.containsKey(slotContext.entity().m_142081_())) {
            Vec3 target = new Vec3(pos.f_82479_, pos.f_82480_, pos.f_82481_);
            Vec3 vec = new Vec3((double)(-entity.m_20205_() / 4.0f * 3.0f), 0.0, 0.0).m_82524_(-((float)Math.toRadians(entity.f_20883_)) - (float)Math.toRadians(20.0));
            Vec3 particlePos = new Vec3(entity.m_20182_().f_82479_ + vec.f_82479_, entity.m_20182_().f_82480_ + (double)entity.m_20206_() + (double)entity.m_20206_() * 0.15, entity.m_20182_().f_82481_ + vec.f_82481_);
            this.charmList.put(slotContext.entity().m_142081_(), new ParticleData(entity.f_19797_, target, particlePos, entity));
        } else {
            double[] offset = CuriosCharmCompat.generateRandomSmoothPath((float)slotContext.entity().f_19797_ + partialTicks, 25.0f);
            ParticleData data = this.charmList.get(slotContext.entity().m_142081_());
            if (data.lastTick != entity.f_19797_) {
                Vec3 vec3 = new Vec3((double)(-entity.m_20205_() / 4.0f * 3.0f), 0.0, 0.0).m_82524_(-((float)Math.toRadians(entity.f_20883_)) - (float)Math.toRadians(20.0));
                Vec3 target = new Vec3(pos.f_82479_, pos.f_82480_ + (double)entity.m_20206_() + (double)entity.m_20206_() * 0.15, pos.f_82481_).m_82549_(vec3).m_82520_(offset[0] / 7.0, CuriosCharmCompat.generateRandomSmoothPath(((float)slotContext.entity().f_19797_ + partialTicks) / 2.0f, 30.0f)[0] / 10.0, offset[1] / 7.0);
                Vec3 vec2 = new Vec3(target.f_82479_ - data.particlePos.f_82479_, target.f_82480_ - data.particlePos.f_82480_, target.f_82481_ - data.particlePos.f_82481_).m_82490_(0.25);
                data.particlePos = new Vec3(data.particlePos.f_82479_ + vec2.f_82479_, data.particlePos.f_82480_ + vec2.f_82480_, data.particlePos.f_82481_ + vec2.f_82481_);
                String particleLoc = VaultCharmItem.getParticleLoc(stack);
                if (data.particle == null || !data.particle.m_107276_() || data.particle.getCustomTexture() != null && !data.particle.getCustomTexture().equals(particleLoc)) {
                    Vec3 particlePos;
                    Vec3 vec = new Vec3((double)(-entity.m_20205_() / 4.0f * 3.0f), 0.0, 0.0).m_82524_(-((float)Math.toRadians(entity.f_20883_)) - (float)Math.toRadians(20.0));
                    data.particlePos = particlePos = new Vec3(entity.m_20182_().f_82479_ + vec.f_82479_, entity.m_20182_().f_82480_ + (double)entity.m_20206_() + (double)entity.m_20206_() * 0.15, entity.m_20182_().f_82481_ + vec.f_82481_);
                    Particle particle = this.pe.m_107370_((ParticleOptions)ModParticles.CHARM.get(), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.0, 0.0, 0.0);
                    if (particle instanceof CharmParticle) {
                        CharmParticle charmParticle = (CharmParticle)particle;
                        particle.m_107257_(500);
                        charmParticle.setLastAgeRendered(charmParticle.getAge());
                        charmParticle.setCustomTexture(particleLoc);
                        data.particle = charmParticle;
                    }
                } else {
                    Vec3 particlePos = data.particlePos;
                    data.particle.m_107264_(particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_);
                    data.particle.setLastAgeRendered(data.particle.getAge());
                    Quaternion quaternion = this.camera.m_90591_();
                    if (!(stack.m_41720_() instanceof VaultCharmItem)) {
                        return;
                    }
                    VaultGearData data1 = VaultGearData.read(stack);
                    Optional<VaultGod> vaultGod = VaultCharmItem.getGod(stack);
                    if (vaultGod.isEmpty()) {
                        return;
                    }
                    VaultGearRarity rarity = data1.getRarity();
                    if (rarity == VaultGearRarity.COMMON) {
                        this.spawnParticles(this.pe, this.camera, particlePos, 1, 3, vaultGod.get().getColor());
                    }
                    if (rarity == VaultGearRarity.RARE) {
                        this.spawnParticles(this.pe, this.camera, particlePos, 2, 4, vaultGod.get().getColor());
                    }
                    if (rarity == VaultGearRarity.EPIC) {
                        this.spawnParticles(this.pe, this.camera, particlePos, 3, 5, vaultGod.get().getColor());
                    }
                    if (rarity == VaultGearRarity.OMEGA) {
                        this.spawnParticles(this.pe, this.camera, particlePos, 3, 6, vaultGod.get().getColor());
                    }
                }
                data.lastTick = entity.f_19797_;
            }
        }
        matrixStack.m_85849_();
    }

    private void spawnParticles(ParticleEngine pe, Camera camera, Vec3 particlePos, int count, int lifetime, int color) {
        for (int i = 0; i < count; ++i) {
            if (i == 1) continue;
            Vec3 vector3f1 = camera.m_90583_().m_82546_(particlePos).m_82541_().m_82542_((double)-0.2f, (double)-0.2f, (double)-0.2f);
            Particle particle = pe.m_107370_((ParticleOptions)ModParticles.ENDER_ANCHOR.get(), particlePos.f_82479_ + vector3f1.m_7096_(), particlePos.f_82480_ + vector3f1.m_7098_(), particlePos.f_82481_ + vector3f1.m_7094_(), (double)(-0.05f + this.random.nextFloat() * 0.1f), (double)(-0.05f + this.random.nextFloat() * 0.1f), (double)(-0.05f + this.random.nextFloat() * 0.1f));
            if (!(particle instanceof EnderAnchorParticle)) continue;
            EnderAnchorParticle enderParticle = (EnderAnchorParticle)particle;
            enderParticle.m_6569_(0.75f);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            enderParticle.m_107253_(r, g, b);
            enderParticle.m_107257_(6);
        }
    }

    public static double[] generateRandomSmoothPath(double T, float speed) {
        double angle = Math.PI * 2 * (T / (double)speed);
        double x = 1.0 * Math.cos(angle);
        double y = 1.0 * Math.sin(angle);
        return new double[]{x, y};
    }

    public static class ParticleData {
        int lastTick;
        Vec3 targetPos;
        Vec3 particlePos;
        CharmParticle particle;
        LivingEntity owner;

        public ParticleData(int lastTick, Vec3 targetPos, Vec3 particlePos, LivingEntity owner) {
            this.lastTick = lastTick;
            this.targetPos = targetPos;
            this.particlePos = particlePos;
            this.owner = owner;
        }
    }
}

