/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.integration.jei;

import iskallia.vault.VaultMod;
import iskallia.vault.client.gui.screen.CompanionHomeScreen;
import iskallia.vault.client.gui.screen.TommyTradeScreen;
import iskallia.vault.client.gui.screen.block.PersonalVaultCatalystScreen;
import iskallia.vault.client.gui.screen.block.PersonalVaultCraftingScreen;
import iskallia.vault.client.gui.screen.block.PersonalVaultScreen;
import iskallia.vault.client.gui.screen.block.SkillAltarScreen;
import iskallia.vault.client.gui.screen.player.AbstractSkillTabElementContainerScreen;
import iskallia.vault.client.gui.screen.void_stone.VoidCrucibleScreen;
import iskallia.vault.config.OmegaSoulShardConfig;
import iskallia.vault.config.SoulShardConfig;
import iskallia.vault.config.altar.entry.AltarIngredientEntry;
import iskallia.vault.config.entry.ItemStackEntry;
import iskallia.vault.config.entry.LevelEntryMap;
import iskallia.vault.config.entry.vending.ProductEntry;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.integration.jei.AnvilRecipesJEI;
import iskallia.vault.integration.jei.RemoveJEIContainerHandler;
import iskallia.vault.integration.jei.VaultRecyclerRecipeJEI;
import iskallia.vault.integration.jei.VaultRecyclerRecipeJEICategory;
import iskallia.vault.integration.jei.VoidCrucibleGhostIngredientHandler;
import iskallia.vault.integration.jei.lootbox.WeightedListJEI;
import iskallia.vault.integration.jei.lootbox.WeightedListJEICategory;
import iskallia.vault.integration.jei.lootinfo.LootInfoFactory;
import iskallia.vault.integration.jei.lootinfo.LootInfoGroupDefinition;
import iskallia.vault.integration.jei.lootinfo.LootInfoGroupDefinitionRegistry;
import iskallia.vault.integration.jei.lootinfo.LootInfoRecipeCategory;
import iskallia.vault.integration.jei.materialbox.MaterialBoxJEI;
import iskallia.vault.integration.jei.materialbox.MaterialBoxJEICategory;
import iskallia.vault.item.crystal.recipe.AnvilRecipes;
import iskallia.vault.item.tool.Pulverizing;
import iskallia.vault.item.tool.Smelting;
import iskallia.vault.item.tool.ToolType;
import iskallia.vault.util.SidedHelper;
import iskallia.vault.util.data.WeightedList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class IntegrationJEI
implements IModPlugin {
    private static final RecipeType<WeightedListJEI> MYSTERY_EGG_TYPE = RecipeType.create((String)"the_vault", (String)"mystery_egg", WeightedListJEI.class);
    private static final RecipeType<WeightedListJEI> MYSTERY_HOSTILE_EGG_TYPE = RecipeType.create((String)"the_vault", (String)"mystery_hostile_egg", WeightedListJEI.class);
    private static final RecipeType<WeightedListJEI> MOD_BOX_TYPE = RecipeType.create((String)"the_vault", (String)"mod_box", WeightedListJEI.class);
    private static final RecipeType<WeightedListJEI> BLACK_MARKET_TYPE = RecipeType.create((String)"the_vault", (String)"black_market", WeightedListJEI.class);
    private static final RecipeType<WeightedListJEI> OMEGA_BLACK_MARKET_TYPE = RecipeType.create((String)"the_vault", (String)"omega_black_market", WeightedListJEI.class);
    private static final RecipeType<WeightedListJEI> BOUNTY_REWARD_TYPE = RecipeType.create((String)"the_vault", (String)"bounty_reward", WeightedListJEI.class);
    private static final RecipeType<WeightedListJEI> VAULT_ALTAR_INGREDIENT_TYPE = RecipeType.create((String)"the_vault", (String)"vault_altar_ingredients", WeightedListJEI.class);

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.useNbtForSubtypes(new Item[]{ModItems.RESPEC_FLASK, ModItems.FACETED_FOCUS, ModItems.TRINKET, ModItems.ETCHING, ModItems.GOD_BLESSING, ModItems.AUGMENT, ModBlocks.ASHIUM_ORE.m_5456_(), ModBlocks.ALEXANDRITE_ORE.m_5456_(), ModBlocks.BENITOITE_ORE.m_5456_(), ModBlocks.BLACK_OPAL_ORE.m_5456_(), ModBlocks.BOMIGNITE_ORE.m_5456_(), ModBlocks.ECHO_ORE.m_5456_(), ModBlocks.GORGINITE_ORE.m_5456_(), ModBlocks.ISKALLIUM_ORE.m_5456_(), ModBlocks.LARIMAR_ORE.m_5456_(), ModBlocks.PAINITE_ORE.m_5456_(), ModBlocks.PETZANITE_ORE.m_5456_(), ModBlocks.PUFFIUM_ORE.m_5456_(), ModBlocks.SPARKLETINE_ORE.m_5456_(), ModBlocks.TUBIUM_ORE.m_5456_(), ModBlocks.UPALINE_ORE.m_5456_(), ModBlocks.WUTODIE_ORE.m_5456_(), ModBlocks.XENIUM_ORE.m_5456_(), ModBlocks.PLACEHOLDER.m_5456_(), ModBlocks.HERALD_TROPHY_BLOCK_ITEM, ModBlocks.SOUL_PLAQUE_BLOCK_ITEM, ModBlocks.GOD_ALTAR.m_5456_(), ModItems.TITLE_SCROLL, ModItems.ANTIQUE, ModItems.CARD_DECK, ModBlocks.MARKER_BLOCK.m_5456_()});
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ModItems.BOTTLE, (stack, context) -> stack.m_41784_().m_128461_("type") + "_" + stack.m_41784_().m_128461_("recharge"));
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ModItems.JEWEL, (stack, context) -> {
            VaultGearData data = VaultGearData.read(stack);
            HashSet<String> modifiers = new HashSet<String>();
            for (VaultGearModifier<?> modifier : data.getAllModifierAffixes()) {
                modifiers.add(modifier.getAttribute().getRegistryName().toString());
            }
            ArrayList sorted = new ArrayList(modifiers);
            Collections.sort(sorted);
            return String.join((CharSequence)".", sorted);
        });
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ModItems.TOOL, (stack, context) -> {
            ToolType type = ToolType.of(stack);
            return type == null ? "" : type.getId();
        });
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("ispawner", "spawn_egg"));
        if (item != null) {
            registration.useNbtForSubtypes(new Item[]{item});
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.VAULT_RECYCLER), new RecipeType[]{VaultRecyclerRecipeJEICategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.MATERIAL_BOX), new RecipeType[]{MaterialBoxJEICategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.MYSTERY_EGG), new RecipeType[]{MYSTERY_EGG_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.MYSTERY_HOSTILE_EGG), new RecipeType[]{MYSTERY_HOSTILE_EGG_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.MOD_BOX), new RecipeType[]{MOD_BOX_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.BLACK_MARKET), new RecipeType[]{BLACK_MARKET_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.BLACK_MARKET), new RecipeType[]{OMEGA_BLACK_MARKET_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.BOUNTY_BLOCK), new RecipeType[]{BOUNTY_REWARD_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.VAULT_ALTAR), new RecipeType[]{VAULT_ALTAR_INGREDIENT_TYPE});
        for (LootInfoGroupDefinition definition : LootInfoGroupDefinitionRegistry.get().values()) {
            if (definition.itemStack().m_41619_() || definition.recipeType() == null) continue;
            registration.addRecipeCatalyst(definition.itemStack(), new RecipeType[]{definition.recipeType()});
        }
        Pulverizing.register(registration);
        Smelting.register(registration);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new VaultRecyclerRecipeJEICategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new MaterialBoxJEICategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new WeightedListJEICategory(guiHelper, MYSTERY_EGG_TYPE, new ItemStack((ItemLike)ModItems.MYSTERY_EGG), (Component)new TextComponent("Mystery Egg"))});
        registration.addRecipeCategories(new IRecipeCategory[]{new WeightedListJEICategory(guiHelper, MYSTERY_HOSTILE_EGG_TYPE, new ItemStack((ItemLike)ModItems.MYSTERY_HOSTILE_EGG), (Component)new TextComponent("Hostile Mystery Egg"))});
        registration.addRecipeCategories(new IRecipeCategory[]{new WeightedListJEICategory(guiHelper, MOD_BOX_TYPE, new ItemStack((ItemLike)ModItems.MOD_BOX), (Component)new TextComponent("Mod Box"))});
        registration.addRecipeCategories(new IRecipeCategory[]{new WeightedListJEICategory(guiHelper, BLACK_MARKET_TYPE, new ItemStack((ItemLike)ModBlocks.BLACK_MARKET), (Component)new TextComponent("Black Market"))});
        registration.addRecipeCategories(new IRecipeCategory[]{new WeightedListJEICategory(guiHelper, OMEGA_BLACK_MARKET_TYPE, new ItemStack((ItemLike)ModBlocks.BLACK_MARKET), (Component)new TextComponent("Omega Black Market"))});
        registration.addRecipeCategories(new IRecipeCategory[]{new WeightedListJEICategory(guiHelper, BOUNTY_REWARD_TYPE, new ItemStack((ItemLike)ModItems.BOUNTY_PEARL), (Component)new TextComponent("Bounty Rewards"))});
        registration.addRecipeCategories(new IRecipeCategory[]{new WeightedListJEICategory(guiHelper, VAULT_ALTAR_INGREDIENT_TYPE, new ItemStack((ItemLike)ModBlocks.VAULT_ALTAR), (Component)new TextComponent("Vault Altar"))});
        for (LootInfoGroupDefinition definition : LootInfoGroupDefinitionRegistry.get().values()) {
            registration.addRecipeCategories(new IRecipeCategory[]{new LootInfoRecipeCategory(guiHelper, definition.recipeType(), definition.itemStack(), definition.titleComponent())});
        }
        Pulverizing.register(registration);
        Smelting.register(registration);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        AnvilRecipes.registerJEI(registration);
        RecipeManager rm = Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_7465_();
        List<VaultRecyclerRecipeJEI> recipes = VaultRecyclerRecipeJEI.getRecipeList();
        registration.addRecipes(VaultRecyclerRecipeJEICategory.RECIPE_TYPE, recipes);
        int playerLevel = Minecraft.m_91087_().f_91074_ != null ? SidedHelper.getVaultLevel((Player)Minecraft.m_91087_().f_91074_) : 0;
        registration.addRecipes(MaterialBoxJEICategory.RECIPE_TYPE, MaterialBoxJEI.createRecipes(playerLevel));
        registration.addRecipes(MYSTERY_EGG_TYPE, WeightedListJEI.fromWeightedList(ModConfigs.MYSTERY_EGG.POOL, p -> p.generateItemStack()));
        registration.addRecipes(MYSTERY_HOSTILE_EGG_TYPE, WeightedListJEI.fromWeightedList(ModConfigs.MYSTERY_HOSTILE_EGG.POOL, p -> p.generateItemStack()));
        WeightedList modBoxPool = new WeightedList();
        ModConfigs.MOD_BOX.POOL.values().forEach(list -> list.forEach(e -> modBoxPool.add((ProductEntry)e.value, e.weight)));
        registration.addRecipes(MOD_BOX_TYPE, WeightedListJEI.fromWeightedList(modBoxPool, p -> p.generateItemStack()));
        WeightedList bmPool = new WeightedList();
        ModConfigs.SOUL_SHARD.getTrades().forEach(t -> t.getShardTrades().forEach(e -> bmPool.add((SoulShardConfig.ShardTrade)e.value, e.weight)));
        WeightedList omegaPool = new WeightedList();
        ModConfigs.OMEGA_SOUL_SHARD.getTrades().forEach(t -> t.getShardTrades().forEach(e -> omegaPool.add((OmegaSoulShardConfig.ShardTrade)e.value, e.weight)));
        registration.addRecipes(BLACK_MARKET_TYPE, WeightedListJEI.fromWeightedList(bmPool, st -> st.getItem()));
        registration.addRecipes(OMEGA_BLACK_MARKET_TYPE, WeightedListJEI.fromWeightedList(omegaPool, st -> st.getItem()));
        WeightedList bountyPool = new WeightedList();
        ModConfigs.REWARD_CONFIG.getPOOLS().values().forEach(map -> map.getForLevel(playerLevel).ifPresent(entry -> entry.getItemPool().getPool().forEach(e -> bountyPool.add((ItemStackEntry)e.value, e.weight))));
        registration.addRecipes(BOUNTY_REWARD_TYPE, WeightedListJEI.fromWeightedList(bountyPool, ise -> ise.getMatchingStack()));
        WeightedList altarPool = new WeightedList();
        try {
            LevelEntryMap<Map<String, WeightedList<AltarIngredientEntry>>> levels = ModConfigs.VAULT_ALTAR_INGREDIENTS.getLEVELS();
            Map map2 = levels.getForLevel(playerLevel).orElse(Collections.emptyMap());
            map2.values().forEach(list -> list.forEach(e -> altarPool.add((AltarIngredientEntry)e.value, e.weight)));
        }
        catch (Exception e) {
            VaultMod.LOGGER.error("Failed reading altar ingredient config", (Throwable)e);
        }
        registration.addRecipes(VAULT_ALTAR_INGREDIENT_TYPE, WeightedListJEI.fromWeightedList(altarPool, ing -> ing.getItems().isEmpty() ? ItemStack.f_41583_ : ing.getItems().get(0)));
        LootInfoGroupDefinitionRegistry.get().forEach((resourceLocation, definition) -> registration.addRecipes(definition.recipeType(), LootInfoFactory.create(resourceLocation)));
        IVanillaRecipeFactory vanillaRecipeFactory = registration.getVanillaRecipeFactory();
        registration.addRecipes(RecipeTypes.ANVIL, AnvilRecipesJEI.getAnvilRecipes(vanillaRecipeFactory));
        Pulverizing.register(registration);
        Smelting.register(registration);
        IIngredientManager ingredientManager = registration.getIngredientManager();
        List<ItemStack> itemsToHide = Stream.of(ModBlocks.ALTAR_CHEST_ITEM_PLACEABLE, ModBlocks.ENIGMA_CHEST_ITEM_PLACEABLE, ModBlocks.FLESH_CHEST_ITEM_PLACEABLE, ModBlocks.GILDED_CHEST_ITEM_PLACEABLE, ModBlocks.HARDENED_CHEST_ITEM_PLACEABLE, ModBlocks.LIVING_CHEST_ITEM_PLACEABLE, ModBlocks.ORNATE_CHEST_ITEM_PLACEABLE, ModBlocks.TREASURE_CHEST_ITEM_PLACEABLE, ModBlocks.WOODEN_CHEST_ITEM_PLACEABLE).map(ItemStack::new).toList();
        ingredientManager.removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, itemsToHide);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGenericGuiContainerHandler(AbstractSkillTabElementContainerScreen.class, new RemoveJEIContainerHandler());
        registration.addGenericGuiContainerHandler(SkillAltarScreen.Default.class, new IGuiContainerHandler<AbstractContainerScreen<?>>(){

            public List<Rect2i> getGuiExtraAreas(AbstractContainerScreen<?> containerScreen) {
                return List.of(new Rect2i(containerScreen.getGuiLeft() + containerScreen.getXSize(), containerScreen.getGuiTop() + 7, 18, 62));
            }
        });
        registration.addGenericGuiContainerHandler(SkillAltarScreen.Import.class, new IGuiContainerHandler<AbstractContainerScreen<?>>(){

            public List<Rect2i> getGuiExtraAreas(AbstractContainerScreen<?> containerScreen) {
                return List.of(new Rect2i(containerScreen.getGuiLeft() + containerScreen.getXSize(), containerScreen.getGuiTop() + 44, 18, 18));
            }
        });
        registration.addGhostIngredientHandler(VoidCrucibleScreen.Blacklist.class, (IGhostIngredientHandler)new VoidCrucibleGhostIngredientHandler());
        registration.addGenericGuiContainerHandler(PersonalVaultScreen.class, new RemoveJEIContainerHandler());
        registration.addGenericGuiContainerHandler(PersonalVaultCatalystScreen.class, new RemoveJEIContainerHandler());
        registration.addGenericGuiContainerHandler(PersonalVaultCraftingScreen.class, new RemoveJEIContainerHandler());
        registration.addGenericGuiContainerHandler(CompanionHomeScreen.class, new RemoveJEIContainerHandler());
        registration.addGenericGuiContainerHandler(TommyTradeScreen.class, new RemoveJEIContainerHandler());
    }

    @Nonnull
    public ResourceLocation getPluginUid() {
        return VaultMod.id("jei_integration");
    }
}

