/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.integration.jei.lootbox;

import iskallia.vault.config.entry.LevelEntryMap;
import iskallia.vault.util.data.WeightedList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.world.item.ItemStack;

public record WeightedListJEI(List<Entry> entries) {
    public static <T> List<WeightedListJEI> fromWeightedList(WeightedList<T> weightedList, Function<T, ItemStack> mapper) {
        int totalWeight = weightedList.getTotalWeight();
        ArrayList<Entry> allEntries = new ArrayList<Entry>();
        for (WeightedList.Entry entry : weightedList) {
            ItemStack stack = mapper.apply(entry.value);
            if (stack.m_41619_()) continue;
            float chance = totalWeight == 0 ? 0.0f : (float)entry.weight / (float)totalWeight;
            allEntries.add(new Entry(stack, chance));
        }
        int pageSize = 54;
        ArrayList<WeightedListJEI> arrayList = new ArrayList<WeightedListJEI>();
        for (int i = 0; i < allEntries.size(); i += pageSize) {
            arrayList.add(new WeightedListJEI(allEntries.subList(i, Math.min(i + pageSize, allEntries.size()))));
        }
        return arrayList;
    }

    public static <T> List<WeightedListJEI> fromLevelEntryMap(LevelEntryMap<WeightedList<T>> levelEntries, int level, Function<T, ItemStack> mapper) {
        WeightedList list = levelEntries.getForLevel(level).orElse(new WeightedList());
        return WeightedListJEI.fromWeightedList(list, mapper);
    }

    public record Entry(ItemStack stack, float chance) {
    }
}

