/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.integration.jei.lootbox;

import iskallia.vault.VaultMod;
import iskallia.vault.integration.jei.lootbox.WeightedListJEI;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class WeightedListJEICategory
implements IRecipeCategory<WeightedListJEI> {
    private static final ResourceLocation TEXTURE = VaultMod.id("textures/gui/jei/loot_info.png");
    private final RecipeType<WeightedListJEI> recipeType;
    private final Component title;
    private final IDrawable background;
    private final IDrawable icon;

    public WeightedListJEICategory(IGuiHelper guiHelper, RecipeType<WeightedListJEI> recipeType, ItemStack iconStack, Component title) {
        this.recipeType = recipeType;
        this.title = title;
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 162, 108);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)iconStack);
    }

    @Nonnull
    public Component getTitle() {
        return this.title;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    @Nonnull
    public RecipeType<WeightedListJEI> getRecipeType() {
        return this.recipeType;
    }

    @Nonnull
    public ResourceLocation getUid() {
        return this.getRecipeType().getUid();
    }

    @Nonnull
    public Class<? extends WeightedListJEI> getRecipeClass() {
        return this.getRecipeType().getRecipeClass();
    }

    @ParametersAreNonnullByDefault
    public void setRecipe(IRecipeLayoutBuilder builder, WeightedListJEI recipe, IFocusGroup focuses) {
        List<WeightedListJEI.Entry> list = recipe.entries();
        for (int i = 0; i < list.size(); ++i) {
            WeightedListJEI.Entry entry = list.get(i);
            int x = 1 + 18 * (i % 9);
            int y = 1 + 18 * (i / 9);
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, x, y).addItemStack(entry.stack())).addTooltipCallback((view, tooltip) -> tooltip.add(new TextComponent(String.format("%.2f%%", Float.valueOf(entry.chance() * 100.0f)))));
        }
    }
}

