/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.integration.jei.lootinfo;

import iskallia.vault.config.LootInfoConfig;
import iskallia.vault.core.world.loot.LootTableInfo;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.integration.jei.lootinfo.LootInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public final class LootInfoFactory {
    @Nonnull
    public static List<LootInfo> create(ResourceLocation lootInfoGroupKey) {
        Set<ResourceLocation> lootTableKeys = LootInfoFactory.getLootTableKeysForLootInfoGroup(lootInfoGroupKey);
        List<ItemStack> itemStackList = LootInfoFactory.getItemsInLootTableKeys(lootTableKeys);
        return LootInfoFactory.getPaginatedLootInfo(itemStackList, 54);
    }

    @Nonnull
    private static List<LootInfo> getPaginatedLootInfo(List<ItemStack> itemStackList, int itemCountPerPage) {
        if (itemStackList.isEmpty()) {
            return Collections.emptyList();
        }
        int pages = (itemStackList.size() - 1) / itemCountPerPage + 1;
        ArrayList<LootInfo> result = new ArrayList<LootInfo>(pages);
        for (int i = 0; i < pages; ++i) {
            int fromIndex = i * itemCountPerPage;
            int toIndex = Math.min((i + 1) * itemCountPerPage, itemStackList.size());
            result.add(new LootInfo(itemStackList.subList(fromIndex, toIndex)));
        }
        return result;
    }

    @Nonnull
    private static List<ItemStack> getItemsInLootTableKeys(Set<ResourceLocation> lootTableKeys) {
        return lootTableKeys.stream().map(LootTableInfo::getItemsForLootTableKey).flatMap(Collection::stream).distinct().map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getValue(arg_0)).filter(Objects::nonNull).filter(item -> item != Items.f_41852_).map(ItemStack::new).toList();
    }

    @Nonnull
    private static Set<ResourceLocation> getLootTableKeysForLootInfoGroup(ResourceLocation lootInfoGroupKey) {
        LootInfoConfig.LootInfo lootInfo = ModConfigs.LOOT_INFO_CONFIG.getLootInfoMap().get(lootInfoGroupKey);
        return lootInfo != null ? lootInfo.getLootTableKeys() : Collections.emptySet();
    }

    private LootInfoFactory() {
    }
}

