/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.integration.jei.lootinfo;

import iskallia.vault.VaultMod;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.integration.jei.lootinfo.LootInfo;
import iskallia.vault.integration.jei.lootinfo.LootInfoGroupDefinition;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public final class LootInfoGroupDefinitionRegistry {
    private static final Map<ResourceLocation, LootInfoGroupDefinition> MAP = new LinkedHashMap<ResourceLocation, LootInfoGroupDefinition>();
    private static final Map<ResourceLocation, LootInfoGroupDefinition> UNMODIFIABLE_MAP = Collections.unmodifiableMap(MAP);

    private static void register(String path, Supplier<ItemStack> catalystItemStackSupplier) {
        MAP.put(VaultMod.id(path), new LootInfoGroupDefinition(catalystItemStackSupplier, LootInfoGroupDefinitionRegistry.recipeType(path), () -> new TranslatableComponent("jei.the_vault." + path + "_loot")));
    }

    private static RecipeType<LootInfo> recipeType(String path) {
        return RecipeType.create((String)"the_vault", (String)path, LootInfo.class);
    }

    public static Map<ResourceLocation, LootInfoGroupDefinition> get() {
        return UNMODIFIABLE_MAP;
    }

    private LootInfoGroupDefinitionRegistry() {
    }

    static {
        LootInfoGroupDefinitionRegistry.register("wooden_chest_raw", () -> new ItemStack((ItemLike)ModBlocks.WOODEN_CHEST));
        LootInfoGroupDefinitionRegistry.register("living_chest_raw", () -> new ItemStack((ItemLike)ModBlocks.LIVING_CHEST));
        LootInfoGroupDefinitionRegistry.register("gilded_chest_raw", () -> new ItemStack((ItemLike)ModBlocks.GILDED_CHEST));
        LootInfoGroupDefinitionRegistry.register("ornate_chest_raw", () -> new ItemStack((ItemLike)ModBlocks.ORNATE_CHEST));
        LootInfoGroupDefinitionRegistry.register("wooden_chest", () -> new ItemStack((ItemLike)ModBlocks.WOODEN_CHEST));
        LootInfoGroupDefinitionRegistry.register("living_chest", () -> new ItemStack((ItemLike)ModBlocks.LIVING_CHEST));
        LootInfoGroupDefinitionRegistry.register("gilded_chest", () -> new ItemStack((ItemLike)ModBlocks.GILDED_CHEST));
        LootInfoGroupDefinitionRegistry.register("ornate_chest", () -> new ItemStack((ItemLike)ModBlocks.ORNATE_CHEST));
        LootInfoGroupDefinitionRegistry.register("hardened_chest", () -> new ItemStack((ItemLike)ModBlocks.HARDENED_CHEST));
        LootInfoGroupDefinitionRegistry.register("flesh_chest", () -> new ItemStack((ItemLike)ModBlocks.FLESH_CHEST));
        LootInfoGroupDefinitionRegistry.register("enigma_chest", () -> new ItemStack((ItemLike)ModBlocks.ENIGMA_CHEST));
        LootInfoGroupDefinitionRegistry.register("coin_pile", () -> new ItemStack((ItemLike)ModBlocks.COIN_PILE));
        LootInfoGroupDefinitionRegistry.register("cube_block", () -> new ItemStack((ItemLike)ModBlocks.CUBE_BLOCK));
        LootInfoGroupDefinitionRegistry.register("treasure_sand", () -> new ItemStack((ItemLike)ModBlocks.TREASURE_SAND));
        LootInfoGroupDefinitionRegistry.register("treasure_chest", () -> new ItemStack((ItemLike)ModBlocks.TREASURE_CHEST));
        LootInfoGroupDefinitionRegistry.register("completion_crate_mono", () -> new ItemStack((ItemLike)ModBlocks.VAULT_CRATE_MONOLITH));
        LootInfoGroupDefinitionRegistry.register("completion_crate_kill", () -> new ItemStack((ItemLike)ModBlocks.VAULT_CRATE));
        LootInfoGroupDefinitionRegistry.register("completion_crate_elixir", () -> new ItemStack((ItemLike)ModBlocks.VAULT_CRATE_ELIXIR));
        LootInfoGroupDefinitionRegistry.register("completion_crate_scavenger", () -> new ItemStack((ItemLike)ModBlocks.VAULT_CRATE_SCAVENGER));
        LootInfoGroupDefinitionRegistry.register("completion_crate_paradox", () -> new ItemStack((ItemLike)ModBlocks.VAULT_CRATE_PARADOX));
        LootInfoGroupDefinitionRegistry.register("altar_chest", () -> new ItemStack((ItemLike)ModBlocks.ALTAR_CHEST));
        LootInfoGroupDefinitionRegistry.register("living_strongbox", () -> new ItemStack((ItemLike)ModBlocks.LIVING_STRONGBOX));
        LootInfoGroupDefinitionRegistry.register("gilded_strongbox", () -> new ItemStack((ItemLike)ModBlocks.GILDED_STRONGBOX));
        LootInfoGroupDefinitionRegistry.register("ornate_strongbox", () -> new ItemStack((ItemLike)ModBlocks.ORNATE_STRONGBOX));
        LootInfoGroupDefinitionRegistry.register("wooden_barrel", () -> new ItemStack((ItemLike)ModBlocks.WOODEN_BARREL));
        LootInfoGroupDefinitionRegistry.register("living_barrel", () -> new ItemStack((ItemLike)ModBlocks.LIVING_BARREL));
        LootInfoGroupDefinitionRegistry.register("gilded_barrel", () -> new ItemStack((ItemLike)ModBlocks.GILDED_BARREL));
        LootInfoGroupDefinitionRegistry.register("ornate_barrel", () -> new ItemStack((ItemLike)ModBlocks.ORNATE_BARREL));
    }
}

