/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.integration.jei.materialbox;

import iskallia.vault.config.MaterialBoxConfig;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.util.data.WeightedList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public record MaterialBoxJEI(List<Entry> entries) {
    public static List<MaterialBoxJEI> createRecipes(int playerLevel) {
        MaterialBoxConfig config = ModConfigs.MATERIAL_BOX;
        MaterialBoxConfig.Level levelCfg = config.LEVELS.getForLevel(playerLevel).orElse(null);
        WeightedList groups = levelCfg != null ? levelCfg.pool : new WeightedList();
        int totalWeight = groups.getTotalWeight();
        ArrayList<Entry> allEntries = new ArrayList<Entry>();
        for (WeightedList.Entry entry : groups) {
            MaterialBoxConfig.Group group = (MaterialBoxConfig.Group)entry.value;
            int weight = entry.weight;
            if (group.entries.isEmpty()) continue;
            float chance = (float)weight / (float)totalWeight;
            ItemStack stack = group.entries.get(0).generateItemStack();
            allEntries.add(new Entry(stack, chance));
        }
        int pageSize = 54;
        ArrayList<MaterialBoxJEI> arrayList = new ArrayList<MaterialBoxJEI>();
        for (int i = 0; i < allEntries.size(); i += pageSize) {
            arrayList.add(new MaterialBoxJEI(allEntries.subList(i, Math.min(i + pageSize, allEntries.size()))));
        }
        return arrayList;
    }

    public record Entry(ItemStack stack, float chance) {
    }
}

