/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.integration.jei.materialbox;

import iskallia.vault.VaultMod;
import iskallia.vault.init.ModItems;
import iskallia.vault.integration.jei.materialbox.MaterialBoxJEI;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class MaterialBoxJEICategory
implements IRecipeCategory<MaterialBoxJEI> {
    public static final RecipeType<MaterialBoxJEI> RECIPE_TYPE = RecipeType.create((String)"the_vault", (String)"material_box", MaterialBoxJEI.class);
    private static final ResourceLocation TEXTURE = VaultMod.id("textures/gui/jei/loot_info.png");
    private final IDrawable background;
    private final IDrawable icon;

    public MaterialBoxJEICategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 162, 108);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModItems.MATERIAL_BOX));
    }

    @Nonnull
    public Component getTitle() {
        return new TextComponent("Material Box");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    @Nonnull
    public RecipeType<MaterialBoxJEI> getRecipeType() {
        return RECIPE_TYPE;
    }

    @Nonnull
    public ResourceLocation getUid() {
        return this.getRecipeType().getUid();
    }

    @Nonnull
    public Class<? extends MaterialBoxJEI> getRecipeClass() {
        return this.getRecipeType().getRecipeClass();
    }

    @ParametersAreNonnullByDefault
    public void setRecipe(IRecipeLayoutBuilder builder, MaterialBoxJEI recipe, IFocusGroup focuses) {
        List<MaterialBoxJEI.Entry> list = recipe.entries();
        for (int i = 0; i < list.size(); ++i) {
            MaterialBoxJEI.Entry entry = list.get(i);
            int x = 1 + 18 * (i % 9);
            int y = 1 + 18 * (i / 9);
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, x, y).addItemStack(entry.stack())).addTooltipCallback((view, tooltip) -> tooltip.add(new TextComponent(String.format("%.2f%%", Float.valueOf(entry.chance() * 100.0f)))));
        }
    }
}

