/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.integration.mixin;

import iskallia.vault.init.ModConfigs;
import iskallia.vault.mixin.AccessorAbstractContainerMenu;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.common.inventory.CosmeticCurioSlot;
import top.theillusivec4.curios.common.inventory.CurioSlot;
import top.theillusivec4.curios.common.inventory.container.CuriosContainer;

@Mixin(value={CuriosContainer.class}, remap=false)
public abstract class MixinCuriosContainer
extends InventoryMenu {
    @Shadow(remap=false)
    private boolean cosmeticColumn;

    private MixinCuriosContainer(Inventory playerInventory, boolean isLocalWorld, Player player) {
        super(playerInventory, isLocalWorld, player);
    }

    @Overwrite
    public void scrollToIndex(int scrollIndex) {
        CuriosContainer self = (CuriosContainer)this;
        self.curiosHandler.ifPresent(curios -> {
            this.cosmeticColumn = false;
            Map curioMap = curios.getCurios();
            int maxSlotsPerColumn = ModConfigs.CURIOS_GUI.getMaxSlotsPerColumn();
            int maxVisiblePerColumn = Math.min(maxSlotsPerColumn, 8);
            int maxColumnSize = this.calculateMaxColumnSize(curioMap, maxSlotsPerColumn);
            int maxScrollIndex = Math.max(0, maxColumnSize - maxVisiblePerColumn);
            int startingRow = Math.max(0, Math.min(scrollIndex, maxScrollIndex));
            self.f_38839_.subList(46, self.f_38839_.size()).clear();
            self.f_38841_.subList(46, self.f_38841_.size()).clear();
            ((AccessorAbstractContainerMenu)self).getRemoteSlots().subList(46, ((AccessorAbstractContainerMenu)self).getRemoteSlots().size()).clear();
            int column = 0;
            int rowInColumn = 0;
            for (String identifier : curioMap.keySet()) {
                ICurioStacksHandler stacksHandler = (ICurioStacksHandler)curioMap.get(identifier);
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                if (!stacksHandler.isVisible()) continue;
                for (int slotInType = 0; slotInType < stackHandler.getSlots(); ++slotInType) {
                    if (rowInColumn >= maxSlotsPerColumn) {
                        ++column;
                        rowInColumn = 0;
                    }
                    int xPosition = -18 - column * 20;
                    int yPosition = 12 + (rowInColumn - startingRow) * 18;
                    boolean inVisibleRange = rowInColumn >= startingRow && rowInColumn < startingRow + maxVisiblePerColumn;
                    int actualY = inVisibleRange ? yPosition : -1000;
                    ((AccessorAbstractContainerMenu)self).invokeAddSlot((Slot)new CurioSlot(self.player, stackHandler, slotInType, identifier, xPosition, actualY, stacksHandler.getRenders()));
                    if (stacksHandler.hasCosmetic()) {
                        int xCosmetic = -37 - column * 20;
                        IDynamicStackHandler cosmeticHandler = stacksHandler.getCosmeticStacks();
                        ((AccessorAbstractContainerMenu)self).invokeAddSlot((Slot)new CosmeticCurioSlot(self.player, cosmeticHandler, slotInType, identifier, xCosmetic, actualY));
                    }
                    ++rowInColumn;
                }
            }
            this.updateLastScrollIndex(self, startingRow);
            self.m_38946_();
        });
    }

    @Overwrite
    public boolean canScroll() {
        CuriosContainer self = (CuriosContainer)this;
        int maxSlotsPerColumn = ModConfigs.CURIOS_GUI.getMaxSlotsPerColumn();
        int visiblePerColumn = Math.min(maxSlotsPerColumn, 8);
        return self.curiosHandler.map(curios -> {
            int maxColumnSize = this.calculateMaxColumnSize(curios.getCurios(), maxSlotsPerColumn);
            return maxColumnSize > visiblePerColumn;
        }).orElse(false);
    }

    @Overwrite
    public void scrollTo(float scrollPosition) {
        CuriosContainer self = (CuriosContainer)this;
        self.curiosHandler.ifPresent(curios -> {
            int maxSlotsPerColumn = ModConfigs.CURIOS_GUI.getMaxSlotsPerColumn();
            int visiblePerColumn = Math.min(maxSlotsPerColumn, 8);
            int maxColumnSize = this.calculateMaxColumnSize(curios.getCurios(), maxSlotsPerColumn);
            int maxScrollRange = Math.max(0, maxColumnSize - visiblePerColumn);
            int newScrollIndex = (int)((double)(scrollPosition * (float)maxScrollRange) + 0.5);
            if ((newScrollIndex = Math.max(0, Math.min(newScrollIndex, maxScrollRange))) != this.getLastScrollIndex(self)) {
                this.scrollToIndex(newScrollIndex);
                try {
                    Field isLocalWorldField = CuriosContainer.class.getDeclaredField("isLocalWorld");
                    isLocalWorldField.setAccessible(true);
                    boolean isLocalWorld = isLocalWorldField.getBoolean(self);
                    if (isLocalWorld) {
                        Class<?> networkHandlerClass = Class.forName("top.theillusivec4.curios.common.network.NetworkHandler");
                        Object networkInstance = networkHandlerClass.getField("INSTANCE").get(null);
                        Class<?> cPacketScrollClass = Class.forName("top.theillusivec4.curios.common.network.client.CPacketScroll");
                        Object packet = cPacketScrollClass.getConstructor(Integer.TYPE, Integer.TYPE).newInstance(self.f_38840_, newScrollIndex);
                        Class<?> packetDistributorClass = Class.forName("net.minecraftforge.network.PacketDistributor");
                        Object serverDistributor = packetDistributorClass.getMethod("SERVER", new Class[0]).invoke(null, new Object[0]);
                        Object distributorTarget = serverDistributor.getClass().getMethod("noArg", new Class[0]).invoke(serverDistributor, new Object[0]);
                        networkInstance.getClass().getMethod("send", Object.class, Object.class).invoke(networkInstance, distributorTarget, packet);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private void updateLastScrollIndex(CuriosContainer container, int index) {
        try {
            Field lastScrollIndexField = CuriosContainer.class.getDeclaredField("lastScrollIndex");
            lastScrollIndexField.setAccessible(true);
            lastScrollIndexField.setInt(container, index);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int getLastScrollIndex(CuriosContainer container) {
        try {
            Field lastScrollIndexField = CuriosContainer.class.getDeclaredField("lastScrollIndex");
            lastScrollIndexField.setAccessible(true);
            return lastScrollIndexField.getInt(container);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private int calculateMaxColumnSize(Map<String, ICurioStacksHandler> curioMap, int maxSlotsPerColumn) {
        int currentColumnSize = 0;
        int maxColumnSize = 0;
        for (ICurioStacksHandler handler : curioMap.values()) {
            if (!handler.isVisible()) continue;
            IDynamicStackHandler stacks = handler.getStacks();
            for (int i = 0; i < stacks.getSlots(); ++i) {
                if (currentColumnSize >= maxSlotsPerColumn) {
                    maxColumnSize = Math.max(maxColumnSize, currentColumnSize);
                    currentColumnSize = 0;
                }
                ++currentColumnSize;
            }
        }
        return Math.max(maxColumnSize, currentColumnSize);
    }
}

