/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.integration.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.init.ModConfigs;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.client.gui.CuriosScreen;
import top.theillusivec4.curios.common.inventory.CosmeticCurioSlot;
import top.theillusivec4.curios.common.inventory.container.CuriosContainer;

@Mixin(value={CuriosScreen.class}, remap=false)
public abstract class MixinCuriosScreen
extends AbstractContainerScreen<CuriosContainer> {
    @Shadow
    @Final
    static ResourceLocation CURIO_INVENTORY;
    @Shadow
    @Final
    private static ResourceLocation CREATIVE_INVENTORY_TABS;
    @Shadow
    public boolean hasScrollBar;
    @Shadow
    private static float currentScroll;

    public MixinCuriosScreen(CuriosContainer menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    @Overwrite
    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)f_97725_);
            int screenLeft = this.f_97735_;
            int screenTop = this.f_97736_;
            this.m_93228_(poseStack, screenLeft, screenTop, 0, 0, this.f_97726_, this.f_97727_);
            InventoryScreen.m_98850_((int)(screenLeft + 51), (int)(screenTop + 75), (int)30, (float)((float)(screenLeft + 51) - (float)mouseX), (float)((float)(screenTop + 75 - 50) - (float)mouseY), (LivingEntity)this.f_96541_.f_91074_);
            CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)this.f_96541_.f_91074_).ifPresent(handler -> {
                int totalSlots = handler.getVisibleSlots();
                if (totalSlots > 0) {
                    int maxSlotsPerColumn = ModConfigs.CURIOS_GUI.getMaxSlotsPerColumn();
                    int maxVisiblePerColumn = Math.min(maxSlotsPerColumn, 8);
                    int visibleRows = Math.min(maxVisiblePerColumn, Math.min(totalSlots, maxSlotsPerColumn));
                    int neededColumns = (int)Math.ceil((double)totalSlots / (double)maxSlotsPerColumn);
                    int maxDisplayableColumns = 4;
                    int displayColumns = Math.min(maxDisplayableColumns, neededColumns);
                    int uniformColumnHeight = 7 + visibleRows * 18;
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderSystem.m_157456_((int)0, (ResourceLocation)CURIO_INVENTORY);
                    for (int columnIndex = 0; columnIndex < displayColumns; ++columnIndex) {
                        int textureXOffset = 0;
                        int panelWidth = 27;
                        int columnXOffset = -26 - columnIndex * 20;
                        if (((CuriosContainer)this.f_97732_).hasCosmeticColumn()) {
                            textureXOffset = 92;
                            panelWidth = 46;
                            columnXOffset -= 19;
                        }
                        this.m_93228_(poseStack, screenLeft + columnXOffset, screenTop + 4, textureXOffset, 0, panelWidth, uniformColumnHeight);
                        this.m_93228_(poseStack, screenLeft + columnXOffset, screenTop + 4 + uniformColumnHeight, textureXOffset, 151, panelWidth, 7);
                    }
                    if (((CuriosContainer)this.f_97732_).canScroll()) {
                        int scrollBarX = screenLeft - 26 - (displayColumns - 1) * 20 - 16;
                        if (((CuriosContainer)this.f_97732_).hasCosmeticColumn()) {
                            scrollBarX -= 19;
                        }
                        this.m_93228_(poseStack, scrollBarX, screenTop + 4, 27, 0, 23, 158);
                        RenderSystem.m_157456_((int)0, (ResourceLocation)CREATIVE_INVENTORY_TABS);
                        this.m_93228_(poseStack, scrollBarX + 8, screenTop + 12 + (int)(127.0f * currentScroll), 232, 0, 12, 15);
                    }
                    for (Slot slot : ((CuriosContainer)this.f_97732_).f_38839_) {
                        if (!(slot instanceof CosmeticCurioSlot)) continue;
                        int slotX = this.f_97735_ + slot.f_40220_ - 1;
                        int slotY = this.f_97736_ + slot.f_40221_ - 1;
                        RenderSystem.m_157456_((int)0, (ResourceLocation)CURIO_INVENTORY);
                        this.m_93228_(poseStack, slotX, slotY, 138, 0, 18, 18);
                    }
                }
            });
        }
    }

    @Overwrite
    private boolean inScrollBar(double mouseX, double mouseY) {
        if (!this.hasScrollBar) {
            return false;
        }
        int maxSlotsPerColumn = ModConfigs.CURIOS_GUI.getMaxSlotsPerColumn();
        int totalSlots = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)this.f_96541_.f_91074_).map(handler -> handler.getVisibleSlots()).orElse(0);
        int neededColumns = (int)Math.ceil((double)totalSlots / (double)maxSlotsPerColumn);
        int maxDisplayableColumns = 4;
        int displayColumns = Math.min(maxDisplayableColumns, neededColumns);
        int screenLeft = this.f_97735_;
        int screenTop = this.f_97736_;
        int scrollBarLeft = screenLeft - 34 - (displayColumns - 1) * 20;
        int scrollBarTop = screenTop + 12;
        int scrollBarRight = scrollBarLeft + 14;
        int scrollBarBottom = scrollBarTop + 139;
        if (((CuriosContainer)this.f_97732_).hasCosmeticColumn()) {
            scrollBarRight -= 19;
            scrollBarLeft -= 19;
        }
        return mouseX >= (double)scrollBarLeft && mouseY >= (double)scrollBarTop && mouseX < (double)scrollBarRight && mouseY < (double)scrollBarBottom;
    }

    @Overwrite
    private boolean needsScrollBars() {
        return ((CuriosContainer)this.f_97732_).canScroll();
    }

    @Inject(method={"init", "m_7856_"}, at={@At(value="FIELD", target="Ltop/theillusivec4/curios/client/gui/CuriosScreen;hasScrollBar:Z", shift=At.Shift.AFTER)})
    private void fixScrollBarDetection(CallbackInfo ci) {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            this.hasScrollBar = ((CuriosContainer)this.f_97732_).canScroll();
        }
    }
}

