/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.client.ClientAbilityData;
import iskallia.vault.client.render.AbilityScrollItemRenderer;
import iskallia.vault.config.AbilitiesGUIConfig;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.core.DataInitializationItem;
import iskallia.vault.item.render.core.IManualModelLoading;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.base.SpecializedSkill;
import iskallia.vault.skill.base.TieredSkill;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.world.data.PlayerAbilitiesData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.IItemRenderProperties;
import org.jetbrains.annotations.Nullable;

public class AbilityScrollItem
extends Item
implements DataInitializationItem,
IManualModelLoading {
    private static final String ABILITY = "Ability";

    public AbilityScrollItem(ResourceLocation id) {
        super(new Item.Properties().m_41491_(ModItems.VAULT_MOD_GROUP).m_41497_(Rarity.EPIC));
        this.setRegistryName(id);
    }

    public static Optional<Skill> getAbilityFromStack(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(ABILITY)) {
            String abilityId = stack.m_41783_().m_128461_(ABILITY);
            return ModConfigs.ABILITIES.getAbilityById(abilityId);
        }
        return Optional.empty();
    }

    @Override
    public void initialize(ItemStack stack, RandomSource rand) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(ABILITY)) {
            return;
        }
        String id = ModConfigs.SKILL_SCROLLS.getRandomAbility(rand);
        if (id != null) {
            stack.m_41784_().m_128359_(ABILITY, id);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CompoundTag tag = stack.m_41783_();
            if (tag != null && tag.m_128441_(ABILITY)) {
                String abilityId = tag.m_128461_(ABILITY);
                AbilityTree abilityTree = PlayerAbilitiesData.get(serverPlayer.m_183503_()).getAbilities((Player)serverPlayer);
                abilityTree.getForId(abilityId).ifPresent(skill -> {
                    if (skill instanceof LearnableSkill) {
                        SpecializedSkill specialized;
                        LearnableSkill patt4678$temp;
                        LearnableSkill learnable = (LearnableSkill)skill;
                        SkillContext context = SkillContext.of(serverPlayer);
                        if (learnable instanceof TieredSkill) {
                            boolean nextTierExists;
                            TieredSkill tiered = (TieredSkill)learnable;
                            boolean bl = nextTierExists = tiered.getUnmodifiedTier() + 1 <= tiered.getTiers().size();
                            if (!nextTierExists) {
                                serverPlayer.m_5661_((Component)new TextComponent("Cannot level this ability up further.").m_130940_(ChatFormatting.RED), true);
                            }
                            if (nextTierExists && tiered.canLearn(context, true) && !ModConfigs.SKILL_GATES.getGates().isLocked(abilityId, abilityTree)) {
                                level.m_6263_(null, serverPlayer.m_20185_(), serverPlayer.m_20186_(), serverPlayer.m_20189_(), SoundEvents.f_12275_, serverPlayer.m_5720_(), 0.6f, 1.0f);
                                tiered.learn(context, true);
                                PlayerVaultStatsData.get(serverPlayer.m_183503_()).getVaultStats((Player)serverPlayer).setSkillPoints(context.getLearnPoints());
                                abilityTree.sync(context);
                                stack.m_41774_(1);
                            }
                        } else if (learnable instanceof SpecializedSkill && (patt4678$temp = (specialized = (SpecializedSkill)learnable).getSpecialization()) instanceof TieredSkill) {
                            boolean nextTierExists;
                            TieredSkill tiered = (TieredSkill)patt4678$temp;
                            boolean bl = nextTierExists = tiered.getUnmodifiedTier() + 1 <= tiered.getTiers().size();
                            if (!nextTierExists) {
                                serverPlayer.m_5661_((Component)new TextComponent("Cannot level this ability up further.").m_130940_(ChatFormatting.RED), true);
                            }
                            if (nextTierExists && tiered.canLearn(context, true) && !ModConfigs.SKILL_GATES.getGates().isLocked(abilityId, abilityTree)) {
                                level.m_6263_(null, serverPlayer.m_20185_(), serverPlayer.m_20186_(), serverPlayer.m_20189_(), SoundEvents.f_12275_, serverPlayer.m_5720_(), 0.6f, 1.0f);
                                tiered.learn(context, true);
                                PlayerVaultStatsData.get(serverPlayer.m_183503_()).getVaultStats((Player)serverPlayer).setSkillPoints(context.getLearnPoints());
                                abilityTree.sync(context);
                                stack.m_41774_(1);
                            }
                        } else if (learnable.canLearn(context) && !ModConfigs.SKILL_GATES.getGates().isLocked(abilityId, abilityTree)) {
                            level.m_6263_(null, serverPlayer.m_20185_(), serverPlayer.m_20186_(), serverPlayer.m_20189_(), SoundEvents.f_12275_, serverPlayer.m_5720_(), 0.6f, 1.0f);
                            learnable.learn(context);
                            PlayerVaultStatsData.get(serverPlayer.m_183503_()).getVaultStats((Player)serverPlayer).setSkillPoints(context.getLearnPoints());
                            abilityTree.sync(context);
                            stack.m_41774_(1);
                        }
                    }
                });
            }
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        if (pStack.m_41782_() && pStack.m_41783_().m_128441_(ABILITY)) {
            String abilityId = pStack.m_41783_().m_128461_(ABILITY);
            Optional<Skill> abilityTree = ModConfigs.ABILITIES.getAbilityById(abilityId);
            abilityTree.ifPresent(skill -> {
                Skill ability;
                pTooltipComponents.add(TextComponent.f_131282_);
                pTooltipComponents.add((Component)new TextComponent("Ability: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(skill.getName()).m_130940_(ChatFormatting.WHITE)));
                pTooltipComponents.add((Component)new TextComponent("Consume to learn or level up this ability.").m_130940_(ChatFormatting.YELLOW));
                pTooltipComponents.add(TextComponent.f_131282_);
                SkillContext context = SkillContext.ofClient();
                AbilityTree learnt = ClientAbilityData.getTree();
                if (learnt.getForId(abilityId).isPresent() && (ability = learnt.getForId(abilityId).get()) instanceof SpecializedSkill) {
                    SpecializedSkill a = (SpecializedSkill)ability;
                    if (a.getSpecialization().canLearn(context) && !ModConfigs.SKILL_GATES.getGates().isLocked(abilityId, learnt)) {
                        pTooltipComponents.add((Component)new TextComponent("You can learn this ability!").m_130940_(ChatFormatting.GREEN));
                    } else {
                        pTooltipComponents.add((Component)new TextComponent("You cannot learn this ability.").m_130940_(ChatFormatting.RED));
                    }
                }
            });
        }
    }

    public Component m_7626_(ItemStack pStack) {
        return (Component)AbilityScrollItem.getAbilityFromStack(pStack).map(skill -> {
            String abilityName = skill.getName();
            return new TextComponent(abilityName).m_130940_(ChatFormatting.GOLD);
        }).orElse(super.m_7626_(pStack).m_6881_());
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return AbilityScrollItemRenderer.INSTANCE;
            }
        });
    }

    @Override
    public void loadModels(Consumer<ModelResourceLocation> consumer) {
        consumer.accept(new ModelResourceLocation("the_vault:ability_scroll_back#inventory"));
        AbilitiesGUIConfig config = (AbilitiesGUIConfig)new AbilitiesGUIConfig().readConfig();
        ModConfigs.CONFIGS.remove(config);
        config.getIcons().forEach(icon -> {
            String[] split = icon.toString().split("/");
            String last = split[split.length - 1];
            consumer.accept(new ModelResourceLocation("the_vault:skills/" + last + "#inventory"));
        });
    }
}

