/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.antique.Antique;
import iskallia.vault.antique.AntiqueRegistry;
import iskallia.vault.config.AntiquesConfig;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.dynamodel.DynamicModel;
import iskallia.vault.dynamodel.DynamicModelItem;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModSounds;
import iskallia.vault.util.TextComponentUtils;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class AntiqueItem
extends Item
implements DynamicModelItem {
    private static final RandomSource rewardRandom = JavaRandom.ofNanoTime();

    public AntiqueItem(ResourceLocation id) {
        super(new Item.Properties().m_41491_(ModItems.VAULT_MOD_GROUP));
        this.setRegistryName(id);
    }

    public Rarity m_41460_(ItemStack pStack) {
        return Rarity.RARE;
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        if (this.m_41389_(tab)) {
            AntiqueRegistry.sorted().forEach(antique -> items.add((Object)AntiqueItem.createStack(antique)));
        }
    }

    public Component m_7626_(ItemStack pStack) {
        return Optional.ofNullable(AntiqueItem.getAntique(pStack)).map(Antique::getConfig).map(cfg -> cfg.getInfo().getName()).map(TextComponent::new).map(cmp -> cmp).orElseGet(() -> super.m_7626_(pStack));
    }

    public int getItemStackLimit(ItemStack stack) {
        return Optional.ofNullable(AntiqueItem.getAntique(stack)).map(Antique::getConfig).map(AntiquesConfig.Entry::getInfo).map(AntiquesConfig.Info::getRequiredCount).orElse(super.getItemStackLimit(stack));
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag advanced) {
        Antique antique = AntiqueItem.getAntique(stack);
        Optional.ofNullable(antique).map(Antique::getConfig).map(AntiquesConfig.Entry::getInfo).filter(info -> info.getRewardDescription() != null && info.getSubtext() != null).ifPresent(info -> {
            tooltip.add(TextComponent.f_131282_);
            tooltip.add((Component)new TextComponent(info.getRewardDescription()).m_130940_(ChatFormatting.GOLD));
            tooltip.add(TextComponent.f_131282_);
            Arrays.stream(info.getSubtext().split("\n")).map(TextComponent::new).map(cmp -> TextComponentUtils.applyStyle((Component)cmp, Style.f_131099_.m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(true)))).forEach(tooltip::add);
            String author = antique.getAuthorName() != null ? antique.getAuthorName() : "Unknown";
            tooltip.add((Component)new TextComponent("By: " + author).m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
        });
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        AntiquesConfig.Entry cfg;
        ItemStack stack = player.m_21120_(hand);
        Antique antique = AntiqueItem.getAntique(stack);
        if (antique != null && (cfg = antique.getConfig()) != null) {
            int requiredCount = cfg.getInfo().getRequiredCount();
            if (stack.m_41613_() >= requiredCount && level instanceof ServerLevel) {
                ServerLevel sLevel = (ServerLevel)level;
                if (player instanceof ServerPlayer) {
                    ServerPlayer sPlayer = (ServerPlayer)player;
                    int playerLevel = PlayerVaultStatsData.get(sLevel).getVaultStats((Player)sPlayer).getVaultLevel();
                    int attempts = 200;
                    while (attempts-- > 0) {
                        List<ItemStack> out = cfg.getReward().generateReward(rewardRandom, sPlayer, playerLevel);
                        out.removeIf(ItemStack::m_41619_);
                        if (out.isEmpty()) continue;
                        stack.m_41774_(requiredCount);
                        Vec3 pos = player.m_20182_();
                        level.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, ModSounds.BOOSTER_PACK_SUCCESS_SFX, SoundSource.PLAYERS, 1.0f, 1.0f);
                        out.forEach(reward -> {
                            int stackCount = reward.m_41613_();
                            while (stackCount > 0) {
                                ItemStack split = reward.m_41777_();
                                split.m_41764_(Math.min(stackCount, reward.m_41741_()));
                                reward.m_41764_(stackCount - split.m_41613_());
                                player.m_7197_(split, false, true);
                                stackCount = reward.m_41613_();
                            }
                        });
                        return InteractionResultHolder.m_19090_((Object)stack);
                    }
                    return InteractionResultHolder.m_19100_((Object)stack);
                }
            }
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public static ItemStack createStack(Antique antique) {
        return AntiqueItem.createStack(antique, 1);
    }

    public static ItemStack createStack(Antique antique, int count) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.ANTIQUE, count);
        AntiqueItem.setAntique(stack, antique);
        return stack;
    }

    @Nullable
    public static Antique getAntique(ItemStack stack) {
        if (!stack.m_41782_() || !stack.m_150930_((Item)ModItems.ANTIQUE)) {
            return null;
        }
        CompoundTag tag = stack.m_41784_();
        ResourceLocation key = ResourceLocation.m_135820_((String)tag.m_128461_("antique"));
        if (key == null) {
            return null;
        }
        return (Antique)AntiqueRegistry.getRegistry().getValue(key);
    }

    public static void setAntique(ItemStack stack, @Nullable Antique antique) {
        CompoundTag tag = stack.m_41784_();
        if (antique == null) {
            tag.m_128473_("antique");
        } else {
            tag.m_128359_("antique", antique.getRegistryName().toString());
        }
    }

    public static String buildAntiqueCountText(@Nullable String text, ItemStack stack) {
        int requiredCount = Optional.ofNullable(AntiqueItem.getAntique(stack)).map(Antique::getConfig).map(AntiquesConfig.Entry::getInfo).map(AntiquesConfig.Info::getRequiredCount).orElse(1);
        if (text == null || ((String)text).isEmpty()) {
            text = stack.m_41613_() >= requiredCount ? ChatFormatting.GOLD.toString() + stack.m_41613_() + "/" + requiredCount : stack.m_41613_() + "/" + requiredCount;
        } else {
            String colorlessText = ChatFormatting.m_126649_((String)text);
            try {
                int parsedCount = Integer.parseInt(colorlessText);
                text = parsedCount >= requiredCount ? String.valueOf(ChatFormatting.GOLD) + colorlessText + "/" + requiredCount : (String)text + "/" + requiredCount;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return text;
    }

    @Override
    public Optional<ResourceLocation> getDynamicModelId(ItemStack itemStack) {
        return Optional.ofNullable(AntiqueItem.getAntique(itemStack)).map(ModDynamicModels.Antiques::getModel).map(DynamicModel::getId);
    }
}

