/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.antique.Antique;
import iskallia.vault.antique.AntiqueRegistry;
import iskallia.vault.antique.condition.AntiqueCondition;
import iskallia.vault.config.AntiquesConfig;
import iskallia.vault.container.inventory.AntiqueCollectorBookContainer;
import iskallia.vault.container.oversized.OverSizedInventory;
import iskallia.vault.container.provider.AntiqueCollectorBookProvider;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.AntiqueItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public class AntiqueStampCollectorBook
extends Item {
    public AntiqueStampCollectorBook(ResourceLocation id) {
        super(new Item.Properties().m_41491_(ModItems.VAULT_MOD_GROUP).m_41487_(1));
        this.setRegistryName(id);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack inHand = player.m_21120_(hand);
        if (player instanceof ServerPlayer) {
            ServerPlayer sPlayer = (ServerPlayer)player;
            int slot = hand == InteractionHand.MAIN_HAND ? sPlayer.m_150109_().f_35977_ : 40;
            AntiqueStampCollectorBook.openBook(sPlayer, slot, inHand);
            return InteractionResultHolder.m_19090_((Object)inHand);
        }
        return InteractionResultHolder.m_19098_((Object)inHand);
    }

    public static void openBook(ServerPlayer player, int bookSlot, ItemStack bookStack) {
        AntiqueCollectorBookProvider provider = new AntiqueCollectorBookProvider(player, bookSlot, bookStack);
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)provider, provider.extraDataWriter());
    }

    public static boolean interceptPlayerInventoryItemAddition(Inventory playerInventory, ItemStack toAdd) {
        if (!toAdd.m_150930_((Item)ModItems.ANTIQUE)) {
            return false;
        }
        Antique antique = AntiqueItem.getAntique(toAdd);
        if (antique == null) {
            return false;
        }
        Player player = playerInventory.f_35978_;
        if (player.f_36096_ instanceof AntiqueCollectorBookContainer) {
            return false;
        }
        ItemStack antiqueBook = ItemStack.f_41583_;
        for (int slot = 0; slot < playerInventory.m_6643_(); ++slot) {
            ItemStack invStack = playerInventory.m_8020_(slot);
            if (!invStack.m_150930_((Item)ModItems.ANTIQUE_COLLECTOR_BOOK)) continue;
            antiqueBook = invStack;
            break;
        }
        if (antiqueBook.m_41619_()) {
            return false;
        }
        StoredAntiques antiques = AntiqueStampCollectorBook.getStoredAntiques(antiqueBook);
        StoredAntiqueInfo info = antiques.getInfo(antique);
        int count = info.getCount();
        int result = Math.min(count + toAdd.m_41613_(), 2147483582);
        int added = result - count;
        info.setCount(result);
        toAdd.m_41764_(toAdd.m_41613_() - added);
        AntiqueStampCollectorBook.setStoredAntiques(antiqueBook, antiques);
        return true;
    }

    public static Container getAntiqueContainer(ItemStack bookStack, Predicate<Player> stillValidCheck) {
        return AntiqueStampCollectorBook.getAntiqueContainer(AntiqueStampCollectorBook.getStoredAntiques(bookStack), stillValidCheck);
    }

    public static Container getAntiqueContainer(StoredAntiques storedAntiques, Predicate<Player> stillValidCheck) {
        OverSizedInventory container = new OverSizedInventory(AntiqueRegistry.getRegistry().getValues().size(), stacks -> {}, stillValidCheck);
        List<Antique> sortedAntiques = AntiqueRegistry.sorted().toList();
        for (int slot = 0; slot < sortedAntiques.size(); ++slot) {
            Antique antique = sortedAntiques.get(slot);
            int count = storedAntiques.getInfo(antique).getCount();
            if (count <= 0) continue;
            container.m_6836_(slot, AntiqueItem.createStack(antique, count));
        }
        return container;
    }

    public static void setStoredAntiques(ItemStack stack, StoredAntiques antiques) {
        CompoundTag tag = stack.m_41784_();
        antiques.updateProgressCounts();
        tag.m_128365_("storedAntiques", (Tag)antiques.serialize());
    }

    public static StoredAntiques getStoredAntiques(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return new StoredAntiques();
        }
        StoredAntiques antiques = new StoredAntiques();
        if (tag.m_128441_("storedAntiques")) {
            antiques.load(tag.m_128469_("storedAntiques"));
        }
        if (tag.m_128441_("Antiques")) {
            antiques.loadLegacy(tag.m_128469_("Antiques"));
            antiques.updateProgressCounts();
            tag.m_128473_("Antiques");
            AntiqueStampCollectorBook.setStoredAntiques(stack, antiques);
        }
        return antiques;
    }

    public static class StoredAntiques {
        private final Map<ResourceLocation, StoredAntiqueInfo> antiques = new HashMap<ResourceLocation, StoredAntiqueInfo>();

        @Nonnull
        public StoredAntiqueInfo getInfo(Antique antique) {
            return this.getInfo(antique.getRegistryName());
        }

        @Nonnull
        private StoredAntiqueInfo getInfo(ResourceLocation key) {
            return this.antiques.computeIfAbsent(key, k -> new StoredAntiqueInfo());
        }

        public void load(CompoundTag tag) {
            tag.m_128431_().forEach(key -> {
                ResourceLocation regKey = ResourceLocation.m_135820_((String)key);
                if (regKey != null) {
                    CompoundTag infoTag = tag.m_128469_(key);
                    int count = infoTag.m_128451_("count");
                    int progressRevealCount = infoTag.m_128451_("progressRevealCount");
                    boolean hasDiscoveredAntique = infoTag.m_128471_("hasDiscoveredAntique");
                    this.antiques.put(regKey, new StoredAntiqueInfo(count, progressRevealCount, hasDiscoveredAntique));
                }
            });
        }

        public void load(FriendlyByteBuf buf) {
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                ResourceLocation key = buf.m_130281_();
                int count = buf.readInt();
                int progressRevealCount = buf.readInt();
                boolean hasDiscoveredAntique = buf.readBoolean();
                this.antiques.put(key, new StoredAntiqueInfo(count, progressRevealCount, hasDiscoveredAntique));
            }
        }

        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            this.antiques.forEach((key, value) -> {
                CompoundTag infoTag = new CompoundTag();
                infoTag.m_128405_("count", value.count);
                infoTag.m_128405_("progressRevealCount", value.progressRevealCount);
                infoTag.m_128379_("hasDiscoveredAntique", value.hasDiscoveredAntique);
                tag.m_128365_(key.toString(), (Tag)infoTag);
            });
            return tag;
        }

        public void write(FriendlyByteBuf buf) {
            buf.writeInt(this.antiques.size());
            this.antiques.forEach((key, value) -> {
                buf.m_130085_(key);
                buf.writeInt(value.count);
                buf.writeInt(value.progressRevealCount);
                buf.writeBoolean(value.hasDiscoveredAntique);
            });
        }

        public void loadLegacy(CompoundTag tag) {
            tag.m_128431_().forEach(key -> {
                ResourceLocation regKey = ResourceLocation.m_135820_((String)key);
                if (regKey != null) {
                    int count = tag.m_128451_(key);
                    this.getInfo(regKey).addCount(count);
                }
            });
        }

        public void updateProgressCounts() {
            this.antiques.forEach((key, info) -> {
                AntiquesConfig.Entry cfg;
                Antique antique = (Antique)AntiqueRegistry.getRegistry().getValue(key);
                if (antique != null && (cfg = antique.getConfig()) != null) {
                    AntiqueCondition condition = cfg.getCondition();
                    int conditionRevealCount = condition.collectConditionDisplay().size();
                    int neededRevealCount = Math.max(cfg.getInfo().getRequiredCount(), conditionRevealCount);
                    float donePercent = (float)info.count / (float)neededRevealCount;
                    int processCount = Mth.m_14143_((float)(donePercent * (float)conditionRevealCount));
                    info.progressRevealCount = Math.max(info.progressRevealCount, processCount);
                }
            });
        }
    }

    public static class StoredAntiqueInfo {
        private int count;
        private int progressRevealCount;
        private boolean hasDiscoveredAntique;

        private StoredAntiqueInfo() {
            this(0, 0, false);
        }

        private StoredAntiqueInfo(int count, int progressRevealCount, boolean hasDiscoveredAntique) {
            this.count = count;
            this.progressRevealCount = progressRevealCount;
            this.hasDiscoveredAntique = hasDiscoveredAntique;
            this.updateDiscovery();
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
            this.updateDiscovery();
        }

        public void addCount(int count) {
            this.count += count;
            this.updateDiscovery();
        }

        private void updateDiscovery() {
            this.hasDiscoveredAntique |= this.count > 0;
        }

        public boolean hasDiscoveredAntique() {
            return this.hasDiscoveredAntique;
        }

        public int getProgressRevealCount() {
            return this.progressRevealCount;
        }
    }
}

