/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.config.entry.DescriptionData;
import iskallia.vault.core.data.key.ThemeKey;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.core.DataTransferItem;
import iskallia.vault.item.core.VaultLevelItem;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class AugmentItem
extends Item
implements VaultLevelItem,
DataTransferItem {
    public AugmentItem(CreativeModeTab group, ResourceLocation id) {
        super(new Item.Properties().m_41491_(group));
        this.setRegistryName(id);
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level world, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag advanced) {
        super.m_7373_(stack, world, tooltip, advanced);
        AugmentItem.getTheme(stack).ifPresent(key -> ModConfigs.THEME_AUGMENT_LORE.getAugmentLore(key.getId()).ifPresentOrElse(lore -> {
            tooltip.add((Component)new TextComponent("Theme: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(lore.displayName + " | " + key.getName()).m_130940_(ChatFormatting.WHITE)));
            for (DescriptionData data : lore.description) {
                tooltip.add((Component)data.getComponent());
            }
        }, () -> tooltip.add((Component)new TextComponent("Theme: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(key.getName()).m_130940_(ChatFormatting.WHITE)))));
    }

    public void m_6787_(CreativeModeTab category, NonNullList<ItemStack> items) {
        if (!this.m_41389_(category)) {
            return;
        }
        for (ThemeKey key : VaultRegistry.THEME.getKeys()) {
            ItemStack stack = new ItemStack((ItemLike)ModItems.AUGMENT);
            stack.m_41784_().m_128359_("theme", key.getId().toString());
            items.add((Object)stack);
        }
    }

    public static int getColor(ItemStack stack) {
        return AugmentItem.getTheme(stack).map(ThemeKey::getColor).orElse(0xFFFFFF);
    }

    public static Optional<ThemeKey> getTheme(ItemStack stack) {
        if (stack.m_41783_() == null) {
            return Optional.empty();
        }
        CompoundTag nbt = stack.m_41784_();
        if (!nbt.m_128425_("theme", 8)) {
            return Optional.empty();
        }
        ResourceLocation theme = new ResourceLocation(nbt.m_128461_("theme"));
        return Optional.ofNullable(VaultRegistry.THEME.getKey(theme));
    }

    public static ItemStack create(ResourceLocation theme) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.AUGMENT);
        stack.m_41784_().m_128359_("theme", theme.toString());
        return stack;
    }

    @Override
    public void initializeVaultLoot(int vaultLevel, ItemStack stack, @Nullable BlockPos pos, @Nullable Vault vault) {
        Optional.ofNullable(vault).flatMap(v -> v.getOptional(Vault.WORLD)).map(world -> world.get(WorldManager.THEME)).ifPresent(theme -> stack.m_41784_().m_128359_("pool", theme.toString()));
    }

    @Override
    public ItemStack convertStack(ItemStack stack, RandomSource random) {
        if (stack.m_41783_() == null) {
            return stack;
        }
        CompoundTag nbt = stack.m_41784_();
        if (!nbt.m_128425_("pool", 8)) {
            return stack;
        }
        ResourceLocation pool = new ResourceLocation(nbt.m_128461_("pool"));
        return ModConfigs.AUGMENT.generate(pool, random).orElse(stack);
    }
}

