/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.VaultMod;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.BasicItem;
import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicScavengerItem
extends BasicItem {
    private static final HashMap<Item, Integer> NAME_COLOR_CACHE = new HashMap();
    private static final Component SCAVENGER_ITEM_HINT = new TranslatableComponent("tooltip.the_vault.scavenger_item").m_130940_(ChatFormatting.GOLD);

    public BasicScavengerItem(String id) {
        super(VaultMod.id("scavenger_" + id), new Item.Properties().m_41491_(ModItems.SCAVENGER_GROUP));
        this.withTooltip(Collections.singletonList(SCAVENGER_ITEM_HINT));
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (stack.m_41782_() && stack.m_41784_().m_128441_("rotten")) {
            tooltip.add(Mth.m_14045_((int)tooltip.size(), (int)0, (int)(tooltip.size() - 2)), (Component)new TextComponent("Rotten items can not be used in the vault").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
        }
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        if (ModConfigs.SCAVENGER == null) {
            return super.m_7626_(stack);
        }
        MutableComponent name = super.m_7626_(stack).m_6881_();
        if (NAME_COLOR_CACHE.isEmpty()) {
            NAME_COLOR_CACHE.putAll(ModConfigs.SCAVENGER.getNameColors());
        }
        int color = NAME_COLOR_CACHE.computeIfAbsent(stack.m_41720_(), item -> Color.DARK_GRAY.getRGB());
        if (stack.m_41782_() && stack.m_41784_().m_128441_("rotten")) {
            return new TextComponent("Rotten ").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)"#00680A"))).m_7220_((Component)name.m_130948_(Style.f_131099_.m_178520_(color)));
        }
        return name.m_130948_(Style.f_131099_.m_178520_(color));
    }

    public static void setVaultIdentifier(ItemStack stack, UUID identifier) {
        if (!(stack.m_41720_() instanceof BasicScavengerItem)) {
            return;
        }
        stack.m_41784_().m_128362_("vault_id", identifier);
    }

    @javax.annotation.Nullable
    public static UUID getVaultIdentifier(ItemStack stack) {
        if (!(stack.m_41720_() instanceof BasicScavengerItem)) {
            return null;
        }
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128403_("vault_id")) {
            return null;
        }
        return stack.m_41784_().m_128342_("vault_id");
    }
}

