/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.core.vault.objective.RoyaleObjective;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.BasicItem;
import iskallia.vault.item.core.VaultLevelItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class BoostModificationStoneItem
extends BasicItem
implements VaultLevelItem {
    public static final String BOOSTER_TAG = "LootBoost";

    public BoostModificationStoneItem(ResourceLocation id) {
        super(id, new Item.Properties().m_41487_(1).m_41491_(ModItems.VAULT_MOD_GROUP));
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        int boost = BoostModificationStoneItem.getLootBoost(stack);
        if (boost > 0) {
            tooltip.add((Component)new TextComponent("Applying this to a Royale crystal in an anvil will multiply the rewards by ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(String.valueOf(boost)).m_130940_(ChatFormatting.GOLD)));
            tooltip.add((Component)new TextComponent("You can increase this multiplier by completing that Royale vault and picking the crown again").m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)new TranslatableComponent("item.vault.boost_modification_stone.tooltip.empty"));
        }
    }

    public static void setLootBoost(ItemStack stack, int boost) {
        stack.m_41784_().m_128405_(BOOSTER_TAG, boost);
    }

    public static int getLootBoost(ItemStack stack) {
        return stack.m_41784_().m_128451_(BOOSTER_TAG);
    }

    @Override
    public void initializeVaultLoot(int vaultLevel, ItemStack stack, @Nullable BlockPos pos, @Nullable Vault vault) {
        if (vault == null) {
            return;
        }
        if (!VaultUtils.isRoyaleVault(vault)) {
            return;
        }
        RoyaleObjective objective = vault.get(Vault.OBJECTIVES).getAll(RoyaleObjective.class).get(0);
        objective.ifPresent(RoyaleObjective.LOOT_MULTIPLIER, multiplier -> {
            int boost = BoostModificationStoneItem.getLootBoost(stack);
            BoostModificationStoneItem.setLootBoost(stack, multiplier + boost + 1);
        });
    }
}

