/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.VaultMod;
import iskallia.vault.config.card.BoosterPackConfig;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSounds;
import iskallia.vault.item.CardItem;
import iskallia.vault.item.render.BoosterPackItemRenderer;
import iskallia.vault.item.render.core.IManualModelLoading;
import iskallia.vault.network.message.OpenClientScreenMessage;
import iskallia.vault.util.ServerScheduler;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.network.NetworkDirection;

public class BoosterPackItem
extends Item
implements IManualModelLoading {
    public BoosterPackItem(ResourceLocation id, Item.Properties properties) {
        super(properties);
        this.setRegistryName(id);
    }

    public static String getId(ItemStack stack) {
        if (stack.m_41783_() == null || !stack.m_41783_().m_128441_("id")) {
            return null;
        }
        return stack.m_41783_().m_128461_("id");
    }

    public static void setId(ItemStack stack, String pool) {
        stack.m_41784_().m_128359_("id", pool);
    }

    public static List<ItemStack> getOutcomes(ItemStack stack) {
        if (stack.m_41783_() == null || !stack.m_41783_().m_128441_("outcomes")) {
            return null;
        }
        ListTag list = stack.m_41783_().m_128437_("outcomes", 10);
        ArrayList<ItemStack> outcomes = new ArrayList<ItemStack>();
        for (int i = 0; i < list.size(); ++i) {
            Adapters.ITEM_STACK.readNbt((Tag)list.m_128728_(i)).ifPresent(outcomes::add);
        }
        return outcomes;
    }

    public static void setOutcomes(ItemStack stack, List<ItemStack> outcomes) {
        ListTag list = new ListTag();
        for (ItemStack outcome : outcomes) {
            Adapters.ITEM_STACK.writeNbt(outcome).ifPresent(arg_0 -> list.add(arg_0));
        }
        stack.m_41784_().m_128365_("outcomes", (Tag)list);
    }

    public Component m_7626_(ItemStack stack) {
        return Optional.ofNullable(BoosterPackItem.getId(stack)).flatMap(s -> ModConfigs.BOOSTER_PACK.getName((String)s)).orElseGet(() -> super.m_7626_(stack));
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
        if (BoosterPackItem.getId(stack) == null) {
            BoosterPackItem.setId(stack, VaultMod.sId("default"));
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (hand == InteractionHand.MAIN_HAND && !world.m_5776_()) {
            if (BoosterPackItem.getId(stack) == null) {
                BoosterPackItem.setId(stack, VaultMod.sId("default"));
            }
            if (BoosterPackItem.getOutcomes(stack) == null) {
                JavaRandom random = JavaRandom.ofNanoTime();
                String id = BoosterPackItem.getId(stack);
                BoosterPackItem.setOutcomes(stack, ModConfigs.BOOSTER_PACK.getOutcomes(id, random).stream().map(CardItem::create).peek(item -> item.m_41666_(player.f_19853_, (Entity)player, 0, false)).toList());
                player.f_19853_.m_5594_(null, player.m_142538_(), ModSounds.BOOSTER_PACK_OPEN, player.m_5720_(), 0.8f, 0.8f + player.m_183503_().m_5822_().nextFloat(0.4f));
            }
            ServerScheduler.INSTANCE.schedule(1, () -> ModNetwork.CHANNEL.sendTo((Object)new OpenClientScreenMessage(OpenClientScreenMessage.Type.BOOSTER_PACK), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT));
        }
        return super.m_7203_(world, player, hand);
    }

    public void m_6787_(@Nonnull CreativeModeTab category, @Nonnull NonNullList<ItemStack> items) {
        if (category != ModItems.GEAR_GROUP) {
            return;
        }
        ArrayList boosterPacks = new ArrayList();
        ModConfigs.BOOSTER_PACK.getValues().keySet().forEach(id -> {
            ItemStack stack = new ItemStack((ItemLike)this);
            BoosterPackItem.setId(stack, id);
            boosterPacks.add(stack);
        });
        items.addAll(boosterPacks);
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return BoosterPackItemRenderer.INSTANCE;
            }
        });
    }

    @Override
    public void loadModels(Consumer<ModelResourceLocation> consumer) {
        BoosterPackConfig config = (BoosterPackConfig)new BoosterPackConfig().readConfig();
        ModConfigs.CONFIGS.remove(config);
        for (BoosterPackConfig.BoosterPackModel model : config.getModels()) {
            consumer.accept(new ModelResourceLocation(model.getUnopened()));
            consumer.accept(new ModelResourceLocation(model.getOpened()));
        }
    }
}

