/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.core.vault.Vault;
import iskallia.vault.entity.boss.BossRuneModifiers;
import iskallia.vault.entity.boss.trait.ModifierType;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.BasicItem;
import iskallia.vault.item.render.BossRuneItemRenderer;
import iskallia.vault.item.render.core.IManualModelLoading;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.IItemRenderProperties;
import org.jetbrains.annotations.Nullable;

public class BossRuneItem
extends BasicItem
implements IManualModelLoading {
    private static final String MODIFIER_TAG = "RuneModifiers";
    private static final DecimalFormat PERCENT_FORMAT = new DecimalFormat("#.##");

    public BossRuneItem(ResourceLocation id) {
        super(id, new Item.Properties().m_41491_(ModItems.VAULT_MOD_GROUP).m_41487_(1));
    }

    public Component m_7626_(ItemStack pStack) {
        return super.m_7626_(pStack).m_6881_().m_130940_(ChatFormatting.GOLD);
    }

    public static String getModifier(ItemStack stack) {
        CompoundTag tag;
        if (stack.m_41782_() && (tag = stack.m_41783_()) != null) {
            return tag.m_128461_("Modifier");
        }
        return "";
    }

    public static String getSuffixModifier(ItemStack stack) {
        CompoundTag tag;
        if (stack.m_41782_() && (tag = stack.m_41783_()) != null) {
            return tag.m_128461_("SuffixModifier");
        }
        return "";
    }

    public static List<ItemStack> getItems(ItemStack original) {
        ListTag itemsNbt = original.m_41784_().m_128437_("Items", 10);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (Tag itemNbt : itemsNbt) {
            items.add(ItemStack.m_41712_((CompoundTag)((CompoundTag)itemNbt)));
        }
        return items;
    }

    public static BossRuneModifiers getRuneModifiers(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(MODIFIER_TAG, 10)) {
            return BossRuneModifiers.fromNbt(tag.m_128469_(MODIFIER_TAG));
        }
        return new BossRuneModifiers();
    }

    public static void setRuneModifiers(ItemStack stack, BossRuneModifiers modifiers) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128365_(MODIFIER_TAG, (Tag)modifiers.toNbt());
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        BossRuneModifiers runeModifiers;
        CompoundTag tag;
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (stack.m_41782_() && (tag = stack.m_41783_()) != null) {
            if (tag.m_128441_("Modifier")) {
                tooltip.add((Component)new TextComponent("+ ").m_7220_((Component)BossRuneItem.getModifierName(tag.m_128461_("Modifier")).m_130940_(ChatFormatting.RED)).m_130946_(" to the boss").m_130940_(ChatFormatting.GRAY));
            }
            if (tag.m_128441_("SuffixModifier")) {
                if (Screen.m_96638_()) {
                    tooltip.add(TextComponent.f_131282_);
                    tooltip.add((Component)new TextComponent("Suffix Modifier: ").m_130940_(ChatFormatting.GRAY));
                }
                tooltip.add((Component)new TextComponent("+ ").m_7220_((Component)BossRuneItem.getModifierName(tag.m_128461_("SuffixModifier")).m_130940_(ChatFormatting.RED)).m_130946_(" to the boss").m_130940_(ChatFormatting.GRAY));
            }
            if (tag.m_128441_("Items")) {
                if (Screen.m_96638_()) {
                    tooltip.add(TextComponent.f_131282_);
                    tooltip.add((Component)new TextComponent("Completion Crate Items: ").m_130940_(ChatFormatting.GRAY));
                }
                ListTag items = tag.m_128437_("Items", 10);
                for (Tag itemTag : items) {
                    ItemStack itemStack = ItemStack.m_41712_((CompoundTag)((CompoundTag)itemTag));
                    tooltip.add((Component)new TextComponent("+ ").m_7220_(itemStack.m_41786_()).m_130946_(" to the completion crate").m_130940_(ChatFormatting.GRAY));
                }
            }
        }
        if (!(runeModifiers = BossRuneItem.getRuneModifiers(stack)).isEmpty()) {
            tooltip.add((Component)BossRuneItem.createModifierTooltip(ModifierType.HEALTH, runeModifiers.getHealthPercent()));
            tooltip.add((Component)BossRuneItem.createModifierTooltip(ModifierType.DAMAGE, runeModifiers.getDamagePercent()));
            tooltip.add((Component)BossRuneItem.createModifierTooltip(ModifierType.ABILITY_HASTE, runeModifiers.getAbilityHaste()));
        }
    }

    public static MutableComponent getModifierName(String modifierId) {
        return new TranslatableComponent("the_vault.boss_rune_effect." + modifierId);
    }

    public static MutableComponent getModifierName(ModifierType modifierType) {
        return BossRuneItem.getModifierName(modifierType.getId());
    }

    public static MutableComponent createModifierTooltip(ModifierType modifierType, double amount) {
        MutableComponent text = new TextComponent("+ ").m_130940_(ChatFormatting.GRAY);
        if (modifierType == ModifierType.ABILITY_HASTE) {
            int stacks = (int)Math.round(Math.max(0.0, amount));
            text.m_7220_((Component)new TextComponent(String.valueOf(stacks)).m_130940_(ChatFormatting.GRAY)).m_130946_(" ");
        } else {
            double value = Math.max(0.0, amount) * 100.0;
            text.m_7220_((Component)new TextComponent(PERCENT_FORMAT.format(value)).m_130940_(ChatFormatting.GRAY)).m_130946_("% ");
        }
        text.m_7220_((Component)BossRuneItem.getModifierName(modifierType).m_130940_(ChatFormatting.RED));
        text.m_7220_((Component)new TextComponent(" to the boss").m_130940_(ChatFormatting.GRAY));
        return text;
    }

    public static void setModifier(ItemStack stack, String randomModifier) {
        stack.m_41784_().m_128359_("Modifier", randomModifier);
    }

    public static void setSuffixModifier(ItemStack stack, String randomModifier) {
        stack.m_41784_().m_128359_("SuffixModifier", randomModifier);
    }

    public static void setItems(ItemStack stack, List<ItemStack> randomLootItems) {
        ListTag items = new ListTag();
        randomLootItems.forEach(itemStack -> items.add((Object)itemStack.m_41739_(new CompoundTag())));
        stack.m_41784_().m_128365_("Items", (Tag)items);
    }

    public static void setVault(ItemStack stack, Vault vault) {
        stack.m_41784_().m_128359_("VaultId", vault.get(Vault.ID).toString());
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return BossRuneItemRenderer.INSTANCE;
            }
        });
    }

    @Override
    public void loadModels(Consumer<ModelResourceLocation> consumer) {
        consumer.accept(new ModelResourceLocation("the_vault:boss_rune/empty#inventory"));
    }
}

