/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import iskallia.vault.client.util.ClientScheduler;
import iskallia.vault.config.card.CardDeckConfig;
import iskallia.vault.container.inventory.CardDeckContainer;
import iskallia.vault.container.inventory.CardDeckContainerMenu;
import iskallia.vault.core.card.CardDeck;
import iskallia.vault.core.card.modifier.deck.DummyDeckModifier;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.gear.VaultGearHelper;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.CardDeckGearData;
import iskallia.vault.gear.item.CuriosGearItem;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.core.DataInitializationItem;
import iskallia.vault.item.render.CardDeckItemRenderer;
import iskallia.vault.item.render.core.IManualModelLoading;
import iskallia.vault.world.data.ServerVaults;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.network.NetworkHooks;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class CardDeckItem
extends Item
implements CuriosGearItem,
ICurioItem,
IManualModelLoading,
DataInitializationItem {
    public static final String SLOT = "deck";

    public CardDeckItem(ResourceLocation id, Item.Properties properties) {
        super(properties);
        this.setRegistryName(id);
    }

    @Override
    public void initialize(ItemStack stack, RandomSource rand) {
        CardDeckItem.getCardDeck(stack).ifPresent(deck -> {
            if (!deck.isModifiersPopulated()) {
                CardDeckItem.populateModifiers(stack, deck, rand);
            }
        });
    }

    @Override
    public boolean isIntendedSlot(ItemStack stack, String slot) {
        return SLOT.equals(slot);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext context, UUID uuid, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = context.entity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_36335_().m_41519_(stack.m_41720_())) {
            return ImmutableMultimap.of();
        }
        return SLOT.equals(context.identifier()) ? VaultGearHelper.getModifiers(AttributeGearData.read(stack)) : ImmutableMultimap.of();
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (ServerVaults.get(player.f_19853_).isPresent()) {
                return false;
            }
        }
        if (!SLOT.equals(slotContext.identifier())) {
            return false;
        }
        if (CuriosApi.getSlotHelper() != null && !CuriosApi.getSlotHelper().getSlotType(SLOT).map(ISlotType::isVisible).orElse(false).booleanValue()) {
            return false;
        }
        return super.canEquip(slotContext, stack);
    }

    public boolean canUnequip(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (ServerVaults.get(player.f_19853_).isPresent()) {
                return false;
            }
        }
        return super.canUnequip(slotContext, stack);
    }

    public Component m_7626_(ItemStack pStack) {
        if (!ModConfigs.isInitialized()) {
            return super.m_7626_(pStack);
        }
        return ModConfigs.CARD_DECK.getName(CardDeckItem.getId(pStack)).map(TextComponent::new).map(cmp -> cmp).orElseGet(() -> super.m_7626_(pStack));
    }

    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag nbt = super.getShareTag(stack);
        if (nbt == null) {
            return null;
        }
        nbt = nbt.m_6426_();
        nbt.m_128473_("inventory");
        return nbt;
    }

    public static String getId(ItemStack stack) {
        if (stack.m_41783_() == null || !stack.m_41783_().m_128441_("id")) {
            return null;
        }
        return stack.m_41783_().m_128461_("id");
    }

    public static void setId(ItemStack stack, String pool) {
        stack.m_41784_().m_128359_("id", pool);
    }

    public static Optional<CardDeck> getCardDeck(ItemStack stack) {
        if (stack.m_41783_() == null || !stack.m_41783_().m_128441_("data")) {
            return Optional.empty();
        }
        CardDeck deck = new CardDeck();
        deck.readNbt(stack.m_41783_().m_128469_("data"));
        return Optional.of(deck);
    }

    public static String getModifiersRoll(ItemStack stack) {
        if (stack.m_41783_() == null || !stack.m_41783_().m_128441_("deckModifierPool")) {
            return null;
        }
        return stack.m_41783_().m_128461_("deckModifierPool");
    }

    public static void setModifiersRoll(ItemStack stack, String pool) {
        stack.m_41784_().m_128359_("deckModifierPool", pool);
    }

    public static void setCardDeck(ItemStack stack, CardDeck deck) {
        deck.writeNbt().ifPresent(tag -> stack.m_41784_().m_128365_("data", (Tag)tag));
        CardDeckGearData data = (CardDeckGearData)CardDeckGearData.read(stack);
        data.refresh(deck);
        data.write(stack);
    }

    public static boolean hasCardDeck(ItemStack stack) {
        return stack.m_41783_() != null && stack.m_41783_().m_128441_("data");
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        CardDeckItem.getCardDeck(stack).ifPresent(deck -> deck.addText(tooltip, tooltip.size(), flag, ClientScheduler.INSTANCE.getTick()));
    }

    public boolean canSync(SlotContext slotContext, ItemStack stack) {
        return false;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
        if (world.m_5776_()) {
            return;
        }
        JavaRandom random = JavaRandom.ofNanoTime();
        String deckId = CardDeckItem.getId(stack);
        if (deckId == null || !ModConfigs.CARD_DECK.has(deckId) && !CardDeckItem.hasCardDeck(stack)) {
            CardDeckItem.setId(stack, ModConfigs.CARD_DECK.getFirst());
        }
        if (!CardDeckItem.hasCardDeck(stack)) {
            ModConfigs.CARD_DECK.generate(CardDeckItem.getId(stack), random).ifPresent(deck -> {
                if (!deck.isModifiersPopulated()) {
                    CardDeckItem.populateModifiers(stack, deck, random);
                }
            });
        }
    }

    private static void populateModifiers(ItemStack stack, CardDeck deck, RandomSource random) {
        String deckModifierPool = CardDeckItem.getModifiersRoll(stack);
        if (deckModifierPool == null) {
            deckModifierPool = "@default";
        }
        if (ModConfigs.DECK_MODIFIERS.getModifierChance() > random.nextFloat()) {
            deck.setModifiersPopulated(true);
            int modifiers = ModConfigs.DECK_MODIFIERS.getModifierCount(deckModifierPool, random).orElse(0);
            for (int i = 0; i < modifiers; ++i) {
                ModConfigs.DECK_MODIFIERS.getRandom(deckModifierPool, random).ifPresent(deck::addModifier);
            }
        } else {
            deck.setModifiersPopulated(true);
        }
        CardDeckItem.setCardDeck(stack, deck);
    }

    public void m_6787_(CreativeModeTab category, NonNullList<ItemStack> items) {
        if (!this.m_41389_(category)) {
            return;
        }
        if (ModConfigs.isInitialized()) {
            ModConfigs.CARD_DECK.getIds().forEach(id -> {
                ItemStack stack = new ItemStack((ItemLike)this);
                CardDeckItem.setId(stack, id);
                items.add((Object)stack);
            });
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        final ItemStack stack = player.m_21120_(hand);
        if (hand == InteractionHand.MAIN_HAND && !world.m_5776_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            final int slot = serverPlayer.m_150109_().f_35977_;
            NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return new TextComponent("Card Deck");
                }

                public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
                    return new CardDeckContainerMenu(windowId, inventory, slot, false, new CardDeckContainer(stack));
                }
            }, buf -> {
                buf.m_130055_(stack);
                buf.writeInt(slot);
                buf.writeBoolean(false);
            });
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.m_41720_() != newStack.m_41720_();
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return CardDeckItemRenderer.INSTANCE;
            }
        });
    }

    @Override
    public void loadModels(Consumer<ModelResourceLocation> consumer) {
        CardDeckConfig config = (CardDeckConfig)new CardDeckConfig().readConfig();
        ModConfigs.CONFIGS.remove(config);
        for (String model : config.getModels()) {
            consumer.accept(new ModelResourceLocation(model));
        }
    }

    public boolean m_5812_(ItemStack stack) {
        if (!Objects.requireNonNullElse(CardDeckItem.getModifiersRoll(stack), "").isEmpty()) {
            return true;
        }
        if (CardDeckItem.hasCardDeck(stack)) {
            return CardDeckItem.getCardDeck(stack).map(cardDeck -> !cardDeck.getModifiers().stream().filter(modifier -> !(modifier instanceof DummyDeckModifier)).toList().isEmpty()).orElse(false);
        }
        return super.m_5812_(stack);
    }
}

