/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.client.util.ClientScheduler;
import iskallia.vault.config.card.CardModifiersConfig;
import iskallia.vault.core.card.Card;
import iskallia.vault.core.card.CardEntry;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.CardItemRenderer;
import iskallia.vault.item.render.core.IManualModelLoading;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.IItemRenderProperties;
import org.jetbrains.annotations.Nullable;

public class CardItem
extends Item
implements IManualModelLoading {
    public CardItem(ResourceLocation id, Item.Properties properties) {
        super(properties);
        this.setRegistryName(id);
    }

    public static Card getCard(ItemStack stack) {
        Card card = new Card();
        if (stack.m_41783_() == null) {
            return card;
        }
        card.readNbt(stack.m_41783_().m_128469_("data"));
        return card;
    }

    public static Card setCard(ItemStack stack, Card card) {
        card.writeNbt().ifPresent(tag -> stack.m_41784_().m_128365_("data", (Tag)tag));
        return card;
    }

    public static Card modifyCard(ItemStack stack, UnaryOperator<Card> action) {
        return CardItem.setCard(stack, (Card)action.apply(CardItem.getCard(stack)));
    }

    public static ItemStack create(Card card) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.CARD);
        CardItem.setCard(stack, card);
        return stack;
    }

    public Component m_7626_(ItemStack stack) {
        return Optional.ofNullable(CardItem.getCard(stack).getFirstName()).orElseGet(() -> super.m_7626_(stack));
    }

    public boolean m_5812_(ItemStack stack) {
        return super.m_5812_(stack) || CardItem.getCard(stack).hasGroup("Foil");
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        Card card = CardItem.getCard(stack);
        card.addText(tooltip, tooltip.size(), flag, ClientScheduler.INSTANCE.getTick());
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
        CardItem.modifyCard(stack, card -> {
            card.onInventoryTick(world, entity, slot, selected);
            return card;
        });
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return CardItemRenderer.INSTANCE;
            }
        });
    }

    @Override
    public void loadModels(Consumer<ModelResourceLocation> consumer) {
        for (CardEntry.Color color : CardEntry.Color.values()) {
            for (int tier = 1; tier <= 5; ++tier) {
                consumer.accept(new ModelResourceLocation("the_vault:card/%s_%d#inventory".formatted(color.name().toLowerCase(), tier)));
                consumer.accept(new ModelResourceLocation("the_vault:card/%s_temporal_%d#inventory".formatted(color.name().toLowerCase(), tier)));
                consumer.accept(new ModelResourceLocation("the_vault:card/%s_evolution_%d#inventory".formatted(color.name().toLowerCase(), tier)));
            }
            consumer.accept(new ModelResourceLocation("the_vault:card/%s_arcane#inventory".formatted(color.name().toLowerCase())));
            consumer.accept(new ModelResourceLocation("the_vault:card/%s_resource#inventory".formatted(color.name().toLowerCase())));
        }
        CardEntry.Color[] colors = CardEntry.Color.values();
        for (int i = 0; i < 16; ++i) {
            StringBuilder prefix = new StringBuilder();
            ArrayList<CardEntry.Color> matching = new ArrayList<CardEntry.Color>();
            if ((i & 1) == 1) {
                matching.add(colors[0]);
            }
            if ((i & 2) == 2) {
                matching.add(colors[1]);
            }
            if ((i & 4) == 4) {
                matching.add(colors[2]);
            }
            if ((i & 8) == 8) {
                matching.add(colors[3]);
            }
            for (CardEntry.Color color : matching) {
                prefix.append(color.name().toLowerCase()).append("_");
            }
            consumer.accept(new ModelResourceLocation("the_vault:card/%swild#inventory".formatted(prefix)));
        }
        CardModifiersConfig config = (CardModifiersConfig)new CardModifiersConfig().readConfig();
        ModConfigs.CONFIGS.remove(config);
        for (CardEntry.Config entry : config.getEntries()) {
            if (entry.model == null) continue;
            consumer.accept(new ModelResourceLocation(entry.model));
        }
    }
}

