/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.core.card.Card;
import iskallia.vault.core.card.CardEntry;
import iskallia.vault.item.CardItem;
import iskallia.vault.item.render.core.SpecialItemRenderer;
import java.util.Set;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class CardItemRenderer
extends SpecialItemRenderer {
    public static final CardItemRenderer INSTANCE = new CardItemRenderer();

    public void m_108829_(@NotNull ItemStack stack, @NotNull ItemTransforms.TransformType transformType, @NotNull PoseStack matrices, @NotNull MultiBufferSource buffer, int light, int overlay) {
        Card card = CardItem.getCard(stack);
        CardEntry.Color color = card.getFirstColor();
        Set<CardEntry.Color> colors = card.getColors();
        if (color != null) {
            if (card.hasGroup("Wild")) {
                StringBuilder prefix = new StringBuilder();
                for (CardEntry.Color value : CardEntry.Color.values()) {
                    if (!colors.contains((Object)value)) continue;
                    prefix.append(value.name().toLowerCase()).append("_");
                }
                ModelResourceLocation base = new ModelResourceLocation("the_vault:card/%swild#inventory".formatted(prefix));
                this.renderModel(base, 0xFFFFFF, stack, transformType, matrices, buffer, light, overlay, null);
            } else if (card.hasGroup("Arcane")) {
                base = new ModelResourceLocation("the_vault:card/%s_arcane#inventory".formatted(color.name().toLowerCase()));
                this.renderModel(base, 0xFFFFFF, stack, transformType, matrices, buffer, light, overlay, null);
            } else if (card.hasGroup("Temporal")) {
                base = new ModelResourceLocation("the_vault:card/%s_temporal_%d#inventory".formatted(color.name().toLowerCase(), card.getTier()));
                this.renderModel(base, 0xFFFFFF, stack, transformType, matrices, buffer, light, overlay, null);
            } else if (card.hasGroup("Resource")) {
                base = new ModelResourceLocation("the_vault:card/%s_resource#inventory".formatted(color.name().toLowerCase()));
                this.renderModel(base, 0xFFFFFF, stack, transformType, matrices, buffer, light, overlay, null);
            } else if (card.hasGroup("Evolution")) {
                base = new ModelResourceLocation("the_vault:card/%s_evolution_%d#inventory".formatted(color.name().toLowerCase(), card.getTier()));
                this.renderModel(base, 0xFFFFFF, stack, transformType, matrices, buffer, light, overlay, null);
            } else {
                base = new ModelResourceLocation("the_vault:card/%s_%d#inventory".formatted(color.name().toLowerCase(), card.getTier()));
                this.renderModel(base, 0xFFFFFF, stack, transformType, matrices, buffer, light, overlay, null);
            }
        }
        matrices.m_85836_();
        if (card.getFirstModel() != null) {
            ModelResourceLocation icon = new ModelResourceLocation(card.getFirstModel());
            this.renderModel(icon, 0xFFFFFF, stack, transformType, matrices, buffer, light, overlay, null, () -> {
                matrices.m_85841_(0.5f, 0.5f, 1.0f);
                CardItemRenderer.translate(matrices, card);
            });
        }
        matrices.m_85849_();
    }

    public static void translate(PoseStack matrices, Card card) {
        if (card.hasGroup("Wild")) {
            matrices.m_85837_(0.5, (double)0.53f, (double)0.02f);
        } else if (card.hasGroup("Arcane")) {
            matrices.m_85837_(0.5, (double)0.53f, (double)0.02f);
        } else if (card.hasGroup("Temporal")) {
            matrices.m_85837_(0.5, (double)0.53f, (double)0.02f);
        } else if (card.hasGroup("Resource")) {
            matrices.m_85837_(0.5, 0.5, (double)0.02f);
        } else if (card.hasGroup("Evolution")) {
            matrices.m_85837_(0.5, 0.75, (double)0.02f);
        } else {
            matrices.m_85837_(0.5, 0.75, (double)0.02f);
        }
    }
}

