/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.core.vault.ClientVaults;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.entity.boss.BossProtectionCatalystEntity;
import iskallia.vault.entity.boss.CatalystInhibitorEntity;
import iskallia.vault.init.ModItems;
import iskallia.vault.world.data.ServerVaults;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CatalystInhibitorItem
extends Item {
    private final BossProtectionCatalystEntity.CatalystType catalystType;

    public CatalystInhibitorItem(ResourceLocation registryName, BossProtectionCatalystEntity.CatalystType catalystType) {
        super(new Item.Properties().m_41491_(ModItems.VAULT_MOD_GROUP));
        this.catalystType = catalystType;
        this.setRegistryName(registryName);
    }

    public BossProtectionCatalystEntity.CatalystType getCatalystType() {
        return this.catalystType;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.isInvalid(player, this.getVaultId(stack))) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12473_, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.m_5822_().nextFloat() * 0.4f + 0.8f));
        if (!level.f_46443_) {
            CatalystInhibitorEntity inhibitor = new CatalystInhibitorEntity(level, player, stack);
            inhibitor.m_37446_(stack);
            inhibitor.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f, 1.0f);
            level.m_7967_((Entity)inhibitor);
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null) {
            return super.m_7626_(stack);
        }
        TranslatableComponent name = new TranslatableComponent(stack.m_41720_().m_5524_());
        if (stack.m_41782_() && stack.m_41784_().m_128441_("rotten")) {
            return new TextComponent("").m_7220_((Component)new TextComponent("Rotten ").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)"#00680A")))).m_7220_((Component)name.m_130940_(ChatFormatting.WHITE));
        }
        return name;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (stack.m_41782_() && stack.m_41784_().m_128441_("rotten")) {
            tooltip.add(tooltip.size(), (Component)new TextComponent("Rotten items can not be used in the vault").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
        }
    }

    @javax.annotation.Nullable
    private UUID getVaultId(ItemStack inhibitor) {
        CompoundTag tag = inhibitor.m_41783_();
        if (tag == null || !tag.m_128441_("VaultId")) {
            return null;
        }
        return tag.m_128342_("VaultId");
    }

    public void setVaultId(ItemStack inhibitor, UUID vaultId) {
        inhibitor.m_41784_().m_128362_("VaultId", vaultId);
    }

    public boolean isInvalid(Player player, @javax.annotation.Nullable UUID vaultId) {
        if (player.m_183503_().m_5776_()) {
            return ClientVaults.getActive().map(v -> !v.get(Vault.ID).equals(vaultId)).orElse(vaultId != null);
        }
        return ServerVaults.get(player.m_183503_()).map(v -> !v.get(Vault.ID).equals(vaultId)).orElse(vaultId != null);
    }
}

