/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.screen.CoinPouchScreen;
import iskallia.vault.container.inventory.CoinPouchContainer;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModSounds;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class CoinPouchItem
extends Item {
    private static ItemStack notifiableCoinPouchStack = ItemStack.f_41583_;
    private static long usedNotificationTime = -1L;
    public static final String PROGRESS = "progress";
    private static final float USED_NOTIFICATION_DURATION = 20.0f;

    public CoinPouchItem(ResourceLocation id) {
        super(new Item.Properties().m_41487_(1).m_41491_(ModItems.VAULT_MOD_GROUP));
        this.setRegistryName(id);
    }

    public Optional<TooltipComponent> m_142422_(ItemStack pStack) {
        return Optional.of(new CoinPouchTooltip(CoinPouchItem.getContainedStacks(pStack)));
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)new TextComponent("Soulbound").m_130948_(Style.f_131099_.m_178520_(9856253)));
    }

    public static int getCoinCount(ItemStack pouch) {
        CompoundTag invTag = pouch.m_41698_("Inventory");
        return invTag.m_128441_("BronzeStackSize") ? invTag.m_128451_("BronzeStackSize") : 0;
    }

    public static boolean interceptPlayerInventoryItemAddition(Inventory playerInventory, ItemStack toAdd) {
        if (!CoinPouchItem.isCoinItem(toAdd.m_41720_())) {
            return false;
        }
        Player player = playerInventory.f_35978_;
        if (player.f_36096_ instanceof CoinPouchContainer) {
            return false;
        }
        ItemStack pouchStack = ItemStack.f_41583_;
        for (int slot = 0; slot < playerInventory.m_6643_(); ++slot) {
            ItemStack invStack = playerInventory.m_8020_(slot);
            if (!(invStack.m_41720_() instanceof CoinPouchItem)) continue;
            pouchStack = invStack;
            break;
        }
        if (pouchStack.m_41619_()) {
            return false;
        }
        return pouchStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(handler -> {
            ItemStack remainder = handler.insertItem(CoinPouchItem.getCoinSlotIndex(toAdd.m_41720_()), toAdd, false);
            toAdd.m_41764_(remainder.m_41613_());
            return toAdd.m_41619_();
        }).orElse(false);
    }

    private static boolean isCoinItem(Item item) {
        return item == ModBlocks.BRONZE_COIN_PILE.m_5456_() || item == ModBlocks.SILVER_COIN_PILE.m_5456_() || item == ModBlocks.GOLD_COIN_PILE.m_5456_() || item == ModBlocks.PLATINUM_COIN_PILE.m_5456_();
    }

    private static int getCoinSlotIndex(Item item) {
        if (item == ModBlocks.BRONZE_COIN_PILE.m_5456_()) {
            return 0;
        }
        if (item == ModBlocks.SILVER_COIN_PILE.m_5456_()) {
            return 1;
        }
        if (item == ModBlocks.GOLD_COIN_PILE.m_5456_()) {
            return 2;
        }
        if (item == ModBlocks.PLATINUM_COIN_PILE.m_5456_()) {
            return 3;
        }
        return -1;
    }

    public static boolean extractCoins(ItemStack pouch, int coinAmount) {
        CompoundTag invTag = pouch.m_41698_("Inventory");
        int bronzeCount = invTag.m_128441_("BronzeStackSize") ? invTag.m_128451_("BronzeStackSize") : 0;
        int left = bronzeCount - coinAmount;
        if (left >= 0) {
            CoinPouchItem.setContainedStack(pouch, 0, left);
            return true;
        }
        return false;
    }

    public static ItemStack[] getContainedStacks(ItemStack pouch) {
        CompoundTag invTag = pouch.m_41698_("Inventory");
        int bronzeCount = invTag.m_128441_("BronzeStackSize") ? invTag.m_128451_("BronzeStackSize") : 0;
        int silverCount = invTag.m_128441_("SilverStackSize") ? invTag.m_128451_("SilverStackSize") : 0;
        int goldCount = invTag.m_128441_("GoldStackSize") ? invTag.m_128451_("GoldStackSize") : 0;
        int platinumCount = invTag.m_128441_("PlatinumStackSize") ? invTag.m_128451_("PlatinumStackSize") : 0;
        return new ItemStack[]{new ItemStack((ItemLike)ModBlocks.BRONZE_COIN_PILE, bronzeCount), new ItemStack((ItemLike)ModBlocks.SILVER_COIN_PILE, silverCount), new ItemStack((ItemLike)ModBlocks.GOLD_COIN_PILE, goldCount), new ItemStack((ItemLike)ModBlocks.PLATINUM_COIN_PILE, platinumCount)};
    }

    public static void setContainedStack(ItemStack pouch, int slot, int count) {
        CompoundTag invTag = pouch.m_41698_("Inventory");
        int[] multipliers = new int[]{1, 9, 81, 729};
        int bronzeCount = invTag.m_128451_("BronzeStackSize");
        if (slot >= 0 && slot < multipliers.length) {
            int remainderBronze = bronzeCount % multipliers[slot];
            int newBronzeCount = remainderBronze + count * multipliers[slot];
            invTag.m_128405_("BronzeStackSize", newBronzeCount);
            for (int i = 1; i < multipliers.length; ++i) {
                invTag.m_128405_(CoinPouchItem.getStackSizeKey(i), Math.floorDiv(newBronzeCount, multipliers[i]));
            }
            invTag.m_128405_(CoinPouchItem.getStackSizeKey(slot), count);
        }
    }

    public static int getTotalBronzeValue(Player player) {
        return CoinPouchItem.getTotalBronzeValue(player.m_150109_());
    }

    public static int getTotalBronzeValue(Inventory playerInventory) {
        AtomicInteger totalBronzeValue = new AtomicInteger();
        Player player = playerInventory.f_35978_;
        for (int slot = 0; slot < playerInventory.m_6643_(); ++slot) {
            ItemStack stack = playerInventory.m_8020_(slot);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            if (item == ModBlocks.VAULT_BRONZE.m_5456_()) {
                totalBronzeValue.addAndGet(stack.m_41613_());
            }
            if (!(item instanceof CoinPouchItem)) continue;
            CompoundTag invTag = stack.m_41698_("Inventory");
            int bronzeCount = invTag.m_128441_("BronzeStackSize") ? invTag.m_128451_("BronzeStackSize") : 0;
            totalBronzeValue.addAndGet(bronzeCount);
        }
        return totalBronzeValue.get();
    }

    public static int getValueFromPouch(ItemStack stack, String tag) {
        int coinValue = 0;
        if (stack.m_41720_() instanceof CoinPouchItem) {
            CompoundTag invTag = stack.m_41698_("Inventory");
            int count = invTag.m_128441_(tag) ? invTag.m_128451_(tag) : 0;
            coinValue += count;
        }
        return coinValue;
    }

    public static int getGoldAmount(Inventory playerInventory) {
        AtomicInteger goldAmount = new AtomicInteger();
        Player player = playerInventory.f_35978_;
        for (int slot = 0; slot < playerInventory.m_6643_(); ++slot) {
            ItemStack stack = playerInventory.m_8020_(slot);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            if (stack.m_150930_((Item)ModBlocks.VAULT_GOLD)) {
                goldAmount.addAndGet(stack.m_41613_());
            }
            if (!(item instanceof CoinPouchItem)) continue;
            CompoundTag invTag = stack.m_41698_("Inventory");
            int bronzeCount = invTag.m_128441_("BronzeStackSize") ? invTag.m_128451_("BronzeStackSize") : 0;
            goldAmount.addAndGet(bronzeCount / 81);
        }
        return goldAmount.get();
    }

    private static String getStackSizeKey(int slot) {
        return switch (slot) {
            case 0 -> "BronzeStackSize";
            case 1 -> "SilverStackSize";
            case 2 -> "GoldStackSize";
            case 3 -> "PlatinumStackSize";
            default -> throw new IllegalArgumentException("Invalid slot: " + slot);
        };
    }

    public static void setContainedStackFromGUI(ItemStack pouch, int slot, ItemStack stack) {
        CoinPouchItem.setContainedStack(pouch, slot, stack.m_41613_());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_ && player instanceof ServerPlayer) {
            int pouchSlot = hand == InteractionHand.OFF_HAND ? 40 : player.m_150109_().f_35977_;
            CoinPouchItem.openGUI((ServerPlayer)player, pouchSlot);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public static void openGUI(ServerPlayer player, final int pouchSlot) {
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)new MenuProvider(){

            public Component m_5446_() {
                return new TextComponent("Coin Pouch");
            }

            @javax.annotation.Nullable
            public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
                return new CoinPouchContainer(windowId, inventory, pouchSlot);
            }
        }, buf -> buf.writeInt(pouchSlot));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.m_41720_() != newStack.m_41720_();
    }

    public static NonNullSupplier<IItemHandler> getInventorySupplier(final ItemStack itemStack) {
        return new NonNullSupplier<IItemHandler>(){

            @Nonnull
            public IItemHandler get() {
                return new Handler(itemStack);
            }
        };
    }

    public void m_6883_(ItemStack stack, Level level, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (!level.f_46443_ && !((AttributeGearData)((Object)AttributeGearData.read(stack))).get(ModGearAttributes.SOULBOUND, VaultGearAttributeTypeMerger.anyTrue()).booleanValue()) {
            Boolean data = AttributeGearData.read(stack);
            ((AttributeGearData)((Object)data)).createOrReplaceAttributeValue(ModGearAttributes.SOULBOUND, true);
            ((AttributeGearData)((Object)data)).write(stack);
        } else if (level.f_46443_) {
            if (notifiableCoinPouchStack != stack && Minecraft.m_91087_().f_91080_ == null || !(Minecraft.m_91087_().f_91080_ instanceof CoinPouchScreen)) {
                if (!notifiableCoinPouchStack.m_41619_() && CoinPouchItem.getCoinCount(stack) < CoinPouchItem.getCoinCount(notifiableCoinPouchStack)) {
                    usedNotificationTime = level.m_46467_();
                }
                notifiableCoinPouchStack = stack;
            }
            if ((float)Math.abs(usedNotificationTime - level.m_46467_()) > 20.0f) {
                usedNotificationTime = -1L;
            }
        }
        super.m_6883_(stack, level, pEntity, pSlotId, pIsSelected);
    }

    @javax.annotation.Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @javax.annotation.Nullable CompoundTag nbt) {
        return new ICapabilityProvider(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @javax.annotation.Nullable Direction side) {
                return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? LazyOptional.of(CoinPouchItem.getInventorySupplier(stack)).cast() : LazyOptional.empty();
            }
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onAfterGuiItemRender(ItemStack stack, PoseStack poseStack) {
        if (CoinPouchItem.shouldRenderNotification(stack)) {
            poseStack.m_85849_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static boolean shouldRenderNotification(ItemStack stack) {
        if (Minecraft.m_91087_().f_91080_ instanceof CoinPouchScreen) {
            return false;
        }
        return stack == notifiableCoinPouchStack && usedNotificationTime > 0L;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onBeforeGuiItemRender(ItemStack stack, PoseStack poseStack) {
        if (CoinPouchItem.shouldRenderNotification(stack)) {
            poseStack.m_85836_();
            float additionalScale = 0.5f;
            long timePassedSinceNotification = (Minecraft.m_91087_().f_91073_.m_46467_() - usedNotificationTime) % 20L;
            float partial = 1.0f - Math.abs(((float)timePassedSinceNotification - 10.0f) / 10.0f);
            float scale = 1.0f + additionalScale * partial;
            poseStack.m_85841_(scale, scale, scale);
            if (timePassedSinceNotification == 0L) {
                float randomPitch = (float)(Math.random() * (double)0.2f + (double)0.9f);
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)ModSounds.COIN_POUCH_SHAKE, (float)randomPitch, (float)0.2f));
            }
        }
    }

    public static class CoinPouchTooltip
    implements TooltipComponent {
        public final ItemStack[] containedStacks;

        public CoinPouchTooltip(ItemStack[] containedStacks) {
            this.containedStacks = containedStacks;
        }
    }

    public static class Handler
    extends ItemStackHandler {
        protected final ItemStack delegate;

        public Handler(ItemStack delegate) {
            super(4);
            this.delegate = delegate;
            ItemStack[] containedStacks = CoinPouchItem.getContainedStacks(this.delegate);
            this.setSize(containedStacks.length);
            for (int i = 0; i < containedStacks.length; ++i) {
                this.stacks.set(i, (Object)containedStacks[i]);
            }
        }

        protected void onContentsChanged(int slot) {
            CoinPouchItem.setContainedStack(this.delegate, slot, this.getStackInSlot(slot).m_41613_());
        }

        protected void onGuiContentChanged(int slot) {
            CoinPouchItem.setContainedStackFromGUI(this.delegate, slot, this.getStackInSlot(slot));
        }

        public void setStackInSlotGUI(int slot, @Nonnull ItemStack stack) {
            this.validateSlotIndex(slot);
            this.stacks.set(slot, (Object)stack);
            this.onGuiContentChanged(slot);
        }

        public ItemStack extractItemGUI(int slot, int amount, boolean simulate) {
            if (amount == 0) {
                return ItemStack.f_41583_;
            }
            this.validateSlotIndex(slot);
            ItemStack existing = (ItemStack)this.stacks.get(slot);
            if (existing.m_41619_()) {
                return ItemStack.f_41583_;
            }
            int toExtract = Math.min(amount, existing.m_41741_());
            if (existing.m_41613_() <= toExtract) {
                if (!simulate) {
                    this.stacks.set(slot, (Object)ItemStack.f_41583_);
                    this.onGuiContentChanged(slot);
                    return existing;
                }
                return existing.m_41777_();
            }
            if (!simulate) {
                this.stacks.set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.m_41613_() - toExtract)));
                this.onGuiContentChanged(slot);
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
        }

        public int getSlotLimit(int slot) {
            return switch (slot) {
                case 0 -> 2147483582;
                case 1 -> 238609286;
                case 2 -> 26512142;
                case 3 -> 2945793;
                default -> 0;
            };
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return this.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            Item item = stack.m_41720_();
            return item == ModBlocks.BRONZE_COIN_PILE.m_5456_() && slot == 0 || item == ModBlocks.SILVER_COIN_PILE.m_5456_() && slot == 1 || item == ModBlocks.GOLD_COIN_PILE.m_5456_() && slot == 2 || item == ModBlocks.PLATINUM_COIN_PILE.m_5456_() && slot == 3;
        }
    }
}

